"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElasticsearchAccessPolicy = void 0;
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const cr = require("../../custom-resources"); // Automatically re-written from '@aws-cdk/custom-resources'
/**
 * Creates LogGroup resource policies.
 */
class ElasticsearchAccessPolicy extends cr.AwsCustomResource {
    constructor(scope, id, props) {
        const policyDocument = new iam.PolicyDocument({
            statements: props.accessPolicies,
        });
        super(scope, id, {
            resourceType: 'Custom::ElasticsearchAccessPolicy',
            onUpdate: {
                action: 'updateElasticsearchDomainConfig',
                service: 'ES',
                parameters: {
                    DomainName: props.domainName,
                    AccessPolicies: JSON.stringify(policyDocument.toJSON()),
                },
                // this is needed to limit the response body, otherwise it exceeds the CFN 4k limit
                outputPath: 'DomainConfig.ElasticsearchClusterConfig.AccessPolicies',
                physicalResourceId: cr.PhysicalResourceId.of(`${props.domainName}AccessPolicy`),
            },
            policy: cr.AwsCustomResourcePolicy.fromSdkCalls({ resources: [props.domainArn] }),
        });
    }
}
exports.ElasticsearchAccessPolicy = ElasticsearchAccessPolicy;
//# sourceMappingURL=data:application/json;base64,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