import * as cdk from "../../core";
import * as ga from './globalaccelerator.generated';
import { IListener } from './listener';
/**
 * The interface of the EndpointGroup
 */
export interface IEndpointGroup extends cdk.IResource {
    /**
     * EndpointGroup ARN
     * @attribute
     */
    readonly endpointGroupArn: string;
}
/**
 * Options for `addLoadBalancer`, `addElasticIpAddress` and `addEc2Instance` to add endpoints into the endpoint group
 */
export interface EndpointConfigurationOptions {
    /**
     * Indicates whether client IP address preservation is enabled for an Application Load Balancer endpoint
     *
     * @default true
     */
    readonly clientIpReservation?: boolean;
    /**
     * The weight associated with the endpoint. When you add weights to endpoints, you configure AWS Global Accelerator
     * to route traffic based on proportions that you specify. For example, you might specify endpoint weights of 4, 5,
     * 5, and 6 (sum=20). The result is that 4/20 of your traffic, on average, is routed to the first endpoint, 5/20 is
     * routed both to the second and third endpoints, and 6/20 is routed to the last endpoint.
     * @see https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoints-endpoint-weights.html
     * @default - not specified
     */
    readonly weight?: number;
}
/**
 * Properties to create EndpointConfiguration
 *
 */
export interface EndpointConfigurationProps extends EndpointConfigurationOptions {
    /**
     * The endopoint group reesource
     *
     * [disable-awslint:ref-via-interface]
     */
    readonly endpointGroup: EndpointGroup;
    /**
     * An ID for the endpoint. If the endpoint is a Network Load Balancer or Application Load Balancer,
     * this is the Amazon Resource Name (ARN) of the resource. If the endpoint is an Elastic IP address,
     * this is the Elastic IP address allocation ID. For EC2 instances, this is the EC2 instance ID.
     */
    readonly endpointId: string;
}
/**
 * LoadBalancer Interface
 */
export interface LoadBalancer {
    /**
     * The ARN of this load balancer
     */
    readonly loadBalancerArn: string;
}
/**
 * EC2 Instance interface
 */
export interface Ec2Instance {
    /**
     * The id of the instance resource
     */
    readonly instanceId: string;
}
/**
 * EIP Interface
 */
export interface ElasticIpAddress {
    /**
     * allocation ID of the EIP resoruce
     */
    readonly attrAllocationId: string;
}
/**
 * Property of the EndpointGroup
 */
export interface EndpointGroupProps {
    /**
     * Name of the endpoint group
     *
     * @default - logical ID of the resource
     */
    readonly endpointGroupName?: string;
    /**
     * The Amazon Resource Name (ARN) of the listener.
     */
    readonly listener: IListener;
    /**
     * The AWS Region where the endpoint group is located.
     *
     * @default - the region of the current stack
     */
    readonly region?: string;
}
/**
 * The class for endpoint configuration
 */
export declare class EndpointConfiguration extends cdk.Construct {
    /**
     * The property containing all the configuration to be rendered
     */
    readonly props: EndpointConfigurationProps;
    constructor(scope: cdk.Construct, id: string, props: EndpointConfigurationProps);
    /**
     * render the endpoint configuration for the endpoint group
     */
    renderEndpointConfiguration(): ga.CfnEndpointGroup.EndpointConfigurationProperty;
}
/**
 * EndpointGroup construct
 */
export declare class EndpointGroup extends cdk.Resource implements IEndpointGroup {
    /**
     * import from ARN
     */
    static fromEndpointGroupArn(scope: cdk.Construct, id: string, endpointGroupArn: string): IEndpointGroup;
    readonly endpointGroupArn: string;
    /**
     *
     * The name of the endpoint group
     *
     * @attribute
     */
    readonly endpointGroupName: string;
    /**
     * The array of the endpoints in this endpoint group
     */
    protected readonly endpoints: EndpointConfiguration[];
    constructor(scope: cdk.Construct, id: string, props: EndpointGroupProps);
    /**
     * Add an endpoint
     */
    addEndpoint(id: string, endpointId: string, props?: EndpointConfigurationOptions): EndpointConfiguration;
    /**
     * Add an Elastic Load Balancer as an endpoint in this endpoint group
     */
    addLoadBalancer(id: string, lb: LoadBalancer, props?: EndpointConfigurationOptions): EndpointConfiguration;
    /**
     * Add an EIP as an endpoint in this endpoint group
     */
    addElasticIpAddress(id: string, eip: ElasticIpAddress, props?: EndpointConfigurationOptions): EndpointConfiguration;
    /**
     * Add an EC2 Instance as an endpoint in this endpoint group
     */
    addEc2Instance(id: string, instance: Ec2Instance, props?: EndpointConfigurationOptions): EndpointConfiguration;
    private renderEndpoints;
}
