import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::Greengrass::ConnectorDefinition`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinition.html
 */
export interface CfnConnectorDefinitionProps {
    /**
     * `AWS::Greengrass::ConnectorDefinition.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinition.html#cfn-greengrass-connectordefinition-name
     */
    readonly name: string;
    /**
     * `AWS::Greengrass::ConnectorDefinition.InitialVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinition.html#cfn-greengrass-connectordefinition-initialversion
     */
    readonly initialVersion?: CfnConnectorDefinition.ConnectorDefinitionVersionProperty | cdk.IResolvable;
    /**
     * `AWS::Greengrass::ConnectorDefinition.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinition.html#cfn-greengrass-connectordefinition-tags
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::Greengrass::ConnectorDefinition`
 *
 * @cloudformationResource AWS::Greengrass::ConnectorDefinition
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinition.html
 */
export declare class CfnConnectorDefinition extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Greengrass::ConnectorDefinition";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * @cloudformationAttribute LatestVersionArn
     */
    readonly attrLatestVersionArn: string;
    /**
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::Greengrass::ConnectorDefinition.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinition.html#cfn-greengrass-connectordefinition-name
     */
    name: string;
    /**
     * `AWS::Greengrass::ConnectorDefinition.InitialVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinition.html#cfn-greengrass-connectordefinition-initialversion
     */
    initialVersion: CfnConnectorDefinition.ConnectorDefinitionVersionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Greengrass::ConnectorDefinition.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinition.html#cfn-greengrass-connectordefinition-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Greengrass::ConnectorDefinition`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnConnectorDefinitionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnConnectorDefinition {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-connectordefinition-connector.html
     */
    interface ConnectorProperty {
        /**
         * `CfnConnectorDefinition.ConnectorProperty.ConnectorArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-connectordefinition-connector.html#cfn-greengrass-connectordefinition-connector-connectorarn
         */
        readonly connectorArn: string;
        /**
         * `CfnConnectorDefinition.ConnectorProperty.Id`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-connectordefinition-connector.html#cfn-greengrass-connectordefinition-connector-id
         */
        readonly id: string;
        /**
         * `CfnConnectorDefinition.ConnectorProperty.Parameters`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-connectordefinition-connector.html#cfn-greengrass-connectordefinition-connector-parameters
         */
        readonly parameters?: any | cdk.IResolvable;
    }
}
export declare namespace CfnConnectorDefinition {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-connectordefinition-connectordefinitionversion.html
     */
    interface ConnectorDefinitionVersionProperty {
        /**
         * `CfnConnectorDefinition.ConnectorDefinitionVersionProperty.Connectors`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-connectordefinition-connectordefinitionversion.html#cfn-greengrass-connectordefinition-connectordefinitionversion-connectors
         */
        readonly connectors: Array<CfnConnectorDefinition.ConnectorProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::Greengrass::ConnectorDefinitionVersion`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinitionversion.html
 */
export interface CfnConnectorDefinitionVersionProps {
    /**
     * `AWS::Greengrass::ConnectorDefinitionVersion.ConnectorDefinitionId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinitionversion.html#cfn-greengrass-connectordefinitionversion-connectordefinitionid
     */
    readonly connectorDefinitionId: string;
    /**
     * `AWS::Greengrass::ConnectorDefinitionVersion.Connectors`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinitionversion.html#cfn-greengrass-connectordefinitionversion-connectors
     */
    readonly connectors: Array<CfnConnectorDefinitionVersion.ConnectorProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Greengrass::ConnectorDefinitionVersion`
 *
 * @cloudformationResource AWS::Greengrass::ConnectorDefinitionVersion
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinitionversion.html
 */
export declare class CfnConnectorDefinitionVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Greengrass::ConnectorDefinitionVersion";
    /**
     * `AWS::Greengrass::ConnectorDefinitionVersion.ConnectorDefinitionId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinitionversion.html#cfn-greengrass-connectordefinitionversion-connectordefinitionid
     */
    connectorDefinitionId: string;
    /**
     * `AWS::Greengrass::ConnectorDefinitionVersion.Connectors`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-connectordefinitionversion.html#cfn-greengrass-connectordefinitionversion-connectors
     */
    connectors: Array<CfnConnectorDefinitionVersion.ConnectorProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * Create a new `AWS::Greengrass::ConnectorDefinitionVersion`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnConnectorDefinitionVersionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnConnectorDefinitionVersion {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-connectordefinitionversion-connector.html
     */
    interface ConnectorProperty {
        /**
         * `CfnConnectorDefinitionVersion.ConnectorProperty.ConnectorArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-connectordefinitionversion-connector.html#cfn-greengrass-connectordefinitionversion-connector-connectorarn
         */
        readonly connectorArn: string;
        /**
         * `CfnConnectorDefinitionVersion.ConnectorProperty.Id`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-connectordefinitionversion-connector.html#cfn-greengrass-connectordefinitionversion-connector-id
         */
        readonly id: string;
        /**
         * `CfnConnectorDefinitionVersion.ConnectorProperty.Parameters`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-connectordefinitionversion-connector.html#cfn-greengrass-connectordefinitionversion-connector-parameters
         */
        readonly parameters?: any | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::Greengrass::CoreDefinition`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinition.html
 */
export interface CfnCoreDefinitionProps {
    /**
     * `AWS::Greengrass::CoreDefinition.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinition.html#cfn-greengrass-coredefinition-name
     */
    readonly name: string;
    /**
     * `AWS::Greengrass::CoreDefinition.InitialVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinition.html#cfn-greengrass-coredefinition-initialversion
     */
    readonly initialVersion?: CfnCoreDefinition.CoreDefinitionVersionProperty | cdk.IResolvable;
    /**
     * `AWS::Greengrass::CoreDefinition.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinition.html#cfn-greengrass-coredefinition-tags
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::Greengrass::CoreDefinition`
 *
 * @cloudformationResource AWS::Greengrass::CoreDefinition
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinition.html
 */
export declare class CfnCoreDefinition extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Greengrass::CoreDefinition";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * @cloudformationAttribute LatestVersionArn
     */
    readonly attrLatestVersionArn: string;
    /**
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::Greengrass::CoreDefinition.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinition.html#cfn-greengrass-coredefinition-name
     */
    name: string;
    /**
     * `AWS::Greengrass::CoreDefinition.InitialVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinition.html#cfn-greengrass-coredefinition-initialversion
     */
    initialVersion: CfnCoreDefinition.CoreDefinitionVersionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Greengrass::CoreDefinition.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinition.html#cfn-greengrass-coredefinition-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Greengrass::CoreDefinition`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCoreDefinitionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnCoreDefinition {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinition-core.html
     */
    interface CoreProperty {
        /**
         * `CfnCoreDefinition.CoreProperty.CertificateArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinition-core.html#cfn-greengrass-coredefinition-core-certificatearn
         */
        readonly certificateArn: string;
        /**
         * `CfnCoreDefinition.CoreProperty.Id`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinition-core.html#cfn-greengrass-coredefinition-core-id
         */
        readonly id: string;
        /**
         * `CfnCoreDefinition.CoreProperty.SyncShadow`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinition-core.html#cfn-greengrass-coredefinition-core-syncshadow
         */
        readonly syncShadow?: boolean | cdk.IResolvable;
        /**
         * `CfnCoreDefinition.CoreProperty.ThingArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinition-core.html#cfn-greengrass-coredefinition-core-thingarn
         */
        readonly thingArn: string;
    }
}
export declare namespace CfnCoreDefinition {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinition-coredefinitionversion.html
     */
    interface CoreDefinitionVersionProperty {
        /**
         * `CfnCoreDefinition.CoreDefinitionVersionProperty.Cores`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinition-coredefinitionversion.html#cfn-greengrass-coredefinition-coredefinitionversion-cores
         */
        readonly cores: Array<CfnCoreDefinition.CoreProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::Greengrass::CoreDefinitionVersion`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinitionversion.html
 */
export interface CfnCoreDefinitionVersionProps {
    /**
     * `AWS::Greengrass::CoreDefinitionVersion.CoreDefinitionId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinitionversion.html#cfn-greengrass-coredefinitionversion-coredefinitionid
     */
    readonly coreDefinitionId: string;
    /**
     * `AWS::Greengrass::CoreDefinitionVersion.Cores`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinitionversion.html#cfn-greengrass-coredefinitionversion-cores
     */
    readonly cores: Array<CfnCoreDefinitionVersion.CoreProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Greengrass::CoreDefinitionVersion`
 *
 * @cloudformationResource AWS::Greengrass::CoreDefinitionVersion
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinitionversion.html
 */
export declare class CfnCoreDefinitionVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Greengrass::CoreDefinitionVersion";
    /**
     * `AWS::Greengrass::CoreDefinitionVersion.CoreDefinitionId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinitionversion.html#cfn-greengrass-coredefinitionversion-coredefinitionid
     */
    coreDefinitionId: string;
    /**
     * `AWS::Greengrass::CoreDefinitionVersion.Cores`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinitionversion.html#cfn-greengrass-coredefinitionversion-cores
     */
    cores: Array<CfnCoreDefinitionVersion.CoreProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * Create a new `AWS::Greengrass::CoreDefinitionVersion`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCoreDefinitionVersionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnCoreDefinitionVersion {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinitionversion-core.html
     */
    interface CoreProperty {
        /**
         * `CfnCoreDefinitionVersion.CoreProperty.CertificateArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinitionversion-core.html#cfn-greengrass-coredefinitionversion-core-certificatearn
         */
        readonly certificateArn: string;
        /**
         * `CfnCoreDefinitionVersion.CoreProperty.Id`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinitionversion-core.html#cfn-greengrass-coredefinitionversion-core-id
         */
        readonly id: string;
        /**
         * `CfnCoreDefinitionVersion.CoreProperty.SyncShadow`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinitionversion-core.html#cfn-greengrass-coredefinitionversion-core-syncshadow
         */
        readonly syncShadow?: boolean | cdk.IResolvable;
        /**
         * `CfnCoreDefinitionVersion.CoreProperty.ThingArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinitionversion-core.html#cfn-greengrass-coredefinitionversion-core-thingarn
         */
        readonly thingArn: string;
    }
}
/**
 * Properties for defining a `AWS::Greengrass::DeviceDefinition`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinition.html
 */
export interface CfnDeviceDefinitionProps {
    /**
     * `AWS::Greengrass::DeviceDefinition.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinition.html#cfn-greengrass-devicedefinition-name
     */
    readonly name: string;
    /**
     * `AWS::Greengrass::DeviceDefinition.InitialVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinition.html#cfn-greengrass-devicedefinition-initialversion
     */
    readonly initialVersion?: CfnDeviceDefinition.DeviceDefinitionVersionProperty | cdk.IResolvable;
    /**
     * `AWS::Greengrass::DeviceDefinition.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinition.html#cfn-greengrass-devicedefinition-tags
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::Greengrass::DeviceDefinition`
 *
 * @cloudformationResource AWS::Greengrass::DeviceDefinition
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinition.html
 */
export declare class CfnDeviceDefinition extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Greengrass::DeviceDefinition";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * @cloudformationAttribute LatestVersionArn
     */
    readonly attrLatestVersionArn: string;
    /**
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::Greengrass::DeviceDefinition.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinition.html#cfn-greengrass-devicedefinition-name
     */
    name: string;
    /**
     * `AWS::Greengrass::DeviceDefinition.InitialVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinition.html#cfn-greengrass-devicedefinition-initialversion
     */
    initialVersion: CfnDeviceDefinition.DeviceDefinitionVersionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Greengrass::DeviceDefinition.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinition.html#cfn-greengrass-devicedefinition-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Greengrass::DeviceDefinition`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDeviceDefinitionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnDeviceDefinition {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-devicedefinition-device.html
     */
    interface DeviceProperty {
        /**
         * `CfnDeviceDefinition.DeviceProperty.CertificateArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-devicedefinition-device.html#cfn-greengrass-devicedefinition-device-certificatearn
         */
        readonly certificateArn: string;
        /**
         * `CfnDeviceDefinition.DeviceProperty.Id`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-devicedefinition-device.html#cfn-greengrass-devicedefinition-device-id
         */
        readonly id: string;
        /**
         * `CfnDeviceDefinition.DeviceProperty.SyncShadow`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-devicedefinition-device.html#cfn-greengrass-devicedefinition-device-syncshadow
         */
        readonly syncShadow?: boolean | cdk.IResolvable;
        /**
         * `CfnDeviceDefinition.DeviceProperty.ThingArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-devicedefinition-device.html#cfn-greengrass-devicedefinition-device-thingarn
         */
        readonly thingArn: string;
    }
}
export declare namespace CfnDeviceDefinition {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-devicedefinition-devicedefinitionversion.html
     */
    interface DeviceDefinitionVersionProperty {
        /**
         * `CfnDeviceDefinition.DeviceDefinitionVersionProperty.Devices`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-devicedefinition-devicedefinitionversion.html#cfn-greengrass-devicedefinition-devicedefinitionversion-devices
         */
        readonly devices: Array<CfnDeviceDefinition.DeviceProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::Greengrass::DeviceDefinitionVersion`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinitionversion.html
 */
export interface CfnDeviceDefinitionVersionProps {
    /**
     * `AWS::Greengrass::DeviceDefinitionVersion.DeviceDefinitionId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinitionversion.html#cfn-greengrass-devicedefinitionversion-devicedefinitionid
     */
    readonly deviceDefinitionId: string;
    /**
     * `AWS::Greengrass::DeviceDefinitionVersion.Devices`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinitionversion.html#cfn-greengrass-devicedefinitionversion-devices
     */
    readonly devices: Array<CfnDeviceDefinitionVersion.DeviceProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Greengrass::DeviceDefinitionVersion`
 *
 * @cloudformationResource AWS::Greengrass::DeviceDefinitionVersion
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinitionversion.html
 */
export declare class CfnDeviceDefinitionVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Greengrass::DeviceDefinitionVersion";
    /**
     * `AWS::Greengrass::DeviceDefinitionVersion.DeviceDefinitionId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinitionversion.html#cfn-greengrass-devicedefinitionversion-devicedefinitionid
     */
    deviceDefinitionId: string;
    /**
     * `AWS::Greengrass::DeviceDefinitionVersion.Devices`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-devicedefinitionversion.html#cfn-greengrass-devicedefinitionversion-devices
     */
    devices: Array<CfnDeviceDefinitionVersion.DeviceProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * Create a new `AWS::Greengrass::DeviceDefinitionVersion`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDeviceDefinitionVersionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnDeviceDefinitionVersion {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-devicedefinitionversion-device.html
     */
    interface DeviceProperty {
        /**
         * `CfnDeviceDefinitionVersion.DeviceProperty.CertificateArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-devicedefinitionversion-device.html#cfn-greengrass-devicedefinitionversion-device-certificatearn
         */
        readonly certificateArn: string;
        /**
         * `CfnDeviceDefinitionVersion.DeviceProperty.Id`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-devicedefinitionversion-device.html#cfn-greengrass-devicedefinitionversion-device-id
         */
        readonly id: string;
        /**
         * `CfnDeviceDefinitionVersion.DeviceProperty.SyncShadow`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-devicedefinitionversion-device.html#cfn-greengrass-devicedefinitionversion-device-syncshadow
         */
        readonly syncShadow?: boolean | cdk.IResolvable;
        /**
         * `CfnDeviceDefinitionVersion.DeviceProperty.ThingArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-devicedefinitionversion-device.html#cfn-greengrass-devicedefinitionversion-device-thingarn
         */
        readonly thingArn: string;
    }
}
/**
 * Properties for defining a `AWS::Greengrass::FunctionDefinition`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinition.html
 */
export interface CfnFunctionDefinitionProps {
    /**
     * `AWS::Greengrass::FunctionDefinition.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinition.html#cfn-greengrass-functiondefinition-name
     */
    readonly name: string;
    /**
     * `AWS::Greengrass::FunctionDefinition.InitialVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinition.html#cfn-greengrass-functiondefinition-initialversion
     */
    readonly initialVersion?: CfnFunctionDefinition.FunctionDefinitionVersionProperty | cdk.IResolvable;
    /**
     * `AWS::Greengrass::FunctionDefinition.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinition.html#cfn-greengrass-functiondefinition-tags
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::Greengrass::FunctionDefinition`
 *
 * @cloudformationResource AWS::Greengrass::FunctionDefinition
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinition.html
 */
export declare class CfnFunctionDefinition extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Greengrass::FunctionDefinition";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * @cloudformationAttribute LatestVersionArn
     */
    readonly attrLatestVersionArn: string;
    /**
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::Greengrass::FunctionDefinition.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinition.html#cfn-greengrass-functiondefinition-name
     */
    name: string;
    /**
     * `AWS::Greengrass::FunctionDefinition.InitialVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinition.html#cfn-greengrass-functiondefinition-initialversion
     */
    initialVersion: CfnFunctionDefinition.FunctionDefinitionVersionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Greengrass::FunctionDefinition.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinition.html#cfn-greengrass-functiondefinition-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Greengrass::FunctionDefinition`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFunctionDefinitionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnFunctionDefinition {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-defaultconfig.html
     */
    interface DefaultConfigProperty {
        /**
         * `CfnFunctionDefinition.DefaultConfigProperty.Execution`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-defaultconfig.html#cfn-greengrass-functiondefinition-defaultconfig-execution
         */
        readonly execution: CfnFunctionDefinition.ExecutionProperty | cdk.IResolvable;
    }
}
export declare namespace CfnFunctionDefinition {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-environment.html
     */
    interface EnvironmentProperty {
        /**
         * `CfnFunctionDefinition.EnvironmentProperty.AccessSysfs`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-environment.html#cfn-greengrass-functiondefinition-environment-accesssysfs
         */
        readonly accessSysfs?: boolean | cdk.IResolvable;
        /**
         * `CfnFunctionDefinition.EnvironmentProperty.Execution`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-environment.html#cfn-greengrass-functiondefinition-environment-execution
         */
        readonly execution?: CfnFunctionDefinition.ExecutionProperty | cdk.IResolvable;
        /**
         * `CfnFunctionDefinition.EnvironmentProperty.ResourceAccessPolicies`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-environment.html#cfn-greengrass-functiondefinition-environment-resourceaccesspolicies
         */
        readonly resourceAccessPolicies?: Array<CfnFunctionDefinition.ResourceAccessPolicyProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFunctionDefinition.EnvironmentProperty.Variables`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-environment.html#cfn-greengrass-functiondefinition-environment-variables
         */
        readonly variables?: any | cdk.IResolvable;
    }
}
export declare namespace CfnFunctionDefinition {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-execution.html
     */
    interface ExecutionProperty {
        /**
         * `CfnFunctionDefinition.ExecutionProperty.IsolationMode`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-execution.html#cfn-greengrass-functiondefinition-execution-isolationmode
         */
        readonly isolationMode?: string;
        /**
         * `CfnFunctionDefinition.ExecutionProperty.RunAs`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-execution.html#cfn-greengrass-functiondefinition-execution-runas
         */
        readonly runAs?: CfnFunctionDefinition.RunAsProperty | cdk.IResolvable;
    }
}
export declare namespace CfnFunctionDefinition {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-function.html
     */
    interface FunctionProperty {
        /**
         * `CfnFunctionDefinition.FunctionProperty.FunctionArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-function.html#cfn-greengrass-functiondefinition-function-functionarn
         */
        readonly functionArn: string;
        /**
         * `CfnFunctionDefinition.FunctionProperty.FunctionConfiguration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-function.html#cfn-greengrass-functiondefinition-function-functionconfiguration
         */
        readonly functionConfiguration: CfnFunctionDefinition.FunctionConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnFunctionDefinition.FunctionProperty.Id`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-function.html#cfn-greengrass-functiondefinition-function-id
         */
        readonly id: string;
    }
}
export declare namespace CfnFunctionDefinition {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-functionconfiguration.html
     */
    interface FunctionConfigurationProperty {
        /**
         * `CfnFunctionDefinition.FunctionConfigurationProperty.EncodingType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-functionconfiguration.html#cfn-greengrass-functiondefinition-functionconfiguration-encodingtype
         */
        readonly encodingType?: string;
        /**
         * `CfnFunctionDefinition.FunctionConfigurationProperty.Environment`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-functionconfiguration.html#cfn-greengrass-functiondefinition-functionconfiguration-environment
         */
        readonly environment?: CfnFunctionDefinition.EnvironmentProperty | cdk.IResolvable;
        /**
         * `CfnFunctionDefinition.FunctionConfigurationProperty.ExecArgs`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-functionconfiguration.html#cfn-greengrass-functiondefinition-functionconfiguration-execargs
         */
        readonly execArgs?: string;
        /**
         * `CfnFunctionDefinition.FunctionConfigurationProperty.Executable`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-functionconfiguration.html#cfn-greengrass-functiondefinition-functionconfiguration-executable
         */
        readonly executable?: string;
        /**
         * `CfnFunctionDefinition.FunctionConfigurationProperty.MemorySize`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-functionconfiguration.html#cfn-greengrass-functiondefinition-functionconfiguration-memorysize
         */
        readonly memorySize?: number;
        /**
         * `CfnFunctionDefinition.FunctionConfigurationProperty.Pinned`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-functionconfiguration.html#cfn-greengrass-functiondefinition-functionconfiguration-pinned
         */
        readonly pinned?: boolean | cdk.IResolvable;
        /**
         * `CfnFunctionDefinition.FunctionConfigurationProperty.Timeout`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-functionconfiguration.html#cfn-greengrass-functiondefinition-functionconfiguration-timeout
         */
        readonly timeout?: number;
    }
}
export declare namespace CfnFunctionDefinition {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-functiondefinitionversion.html
     */
    interface FunctionDefinitionVersionProperty {
        /**
         * `CfnFunctionDefinition.FunctionDefinitionVersionProperty.DefaultConfig`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-functiondefinitionversion.html#cfn-greengrass-functiondefinition-functiondefinitionversion-defaultconfig
         */
        readonly defaultConfig?: CfnFunctionDefinition.DefaultConfigProperty | cdk.IResolvable;
        /**
         * `CfnFunctionDefinition.FunctionDefinitionVersionProperty.Functions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-functiondefinitionversion.html#cfn-greengrass-functiondefinition-functiondefinitionversion-functions
         */
        readonly functions: Array<CfnFunctionDefinition.FunctionProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnFunctionDefinition {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-resourceaccesspolicy.html
     */
    interface ResourceAccessPolicyProperty {
        /**
         * `CfnFunctionDefinition.ResourceAccessPolicyProperty.Permission`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-resourceaccesspolicy.html#cfn-greengrass-functiondefinition-resourceaccesspolicy-permission
         */
        readonly permission?: string;
        /**
         * `CfnFunctionDefinition.ResourceAccessPolicyProperty.ResourceId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-resourceaccesspolicy.html#cfn-greengrass-functiondefinition-resourceaccesspolicy-resourceid
         */
        readonly resourceId: string;
    }
}
export declare namespace CfnFunctionDefinition {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-runas.html
     */
    interface RunAsProperty {
        /**
         * `CfnFunctionDefinition.RunAsProperty.Gid`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-runas.html#cfn-greengrass-functiondefinition-runas-gid
         */
        readonly gid?: number;
        /**
         * `CfnFunctionDefinition.RunAsProperty.Uid`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinition-runas.html#cfn-greengrass-functiondefinition-runas-uid
         */
        readonly uid?: number;
    }
}
/**
 * Properties for defining a `AWS::Greengrass::FunctionDefinitionVersion`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html
 */
export interface CfnFunctionDefinitionVersionProps {
    /**
     * `AWS::Greengrass::FunctionDefinitionVersion.FunctionDefinitionId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html#cfn-greengrass-functiondefinitionversion-functiondefinitionid
     */
    readonly functionDefinitionId: string;
    /**
     * `AWS::Greengrass::FunctionDefinitionVersion.Functions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html#cfn-greengrass-functiondefinitionversion-functions
     */
    readonly functions: Array<CfnFunctionDefinitionVersion.FunctionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Greengrass::FunctionDefinitionVersion.DefaultConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html#cfn-greengrass-functiondefinitionversion-defaultconfig
     */
    readonly defaultConfig?: CfnFunctionDefinitionVersion.DefaultConfigProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Greengrass::FunctionDefinitionVersion`
 *
 * @cloudformationResource AWS::Greengrass::FunctionDefinitionVersion
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html
 */
export declare class CfnFunctionDefinitionVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Greengrass::FunctionDefinitionVersion";
    /**
     * `AWS::Greengrass::FunctionDefinitionVersion.FunctionDefinitionId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html#cfn-greengrass-functiondefinitionversion-functiondefinitionid
     */
    functionDefinitionId: string;
    /**
     * `AWS::Greengrass::FunctionDefinitionVersion.Functions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html#cfn-greengrass-functiondefinitionversion-functions
     */
    functions: Array<CfnFunctionDefinitionVersion.FunctionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Greengrass::FunctionDefinitionVersion.DefaultConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html#cfn-greengrass-functiondefinitionversion-defaultconfig
     */
    defaultConfig: CfnFunctionDefinitionVersion.DefaultConfigProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Greengrass::FunctionDefinitionVersion`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFunctionDefinitionVersionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnFunctionDefinitionVersion {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-defaultconfig.html
     */
    interface DefaultConfigProperty {
        /**
         * `CfnFunctionDefinitionVersion.DefaultConfigProperty.Execution`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-defaultconfig.html#cfn-greengrass-functiondefinitionversion-defaultconfig-execution
         */
        readonly execution: CfnFunctionDefinitionVersion.ExecutionProperty | cdk.IResolvable;
    }
}
export declare namespace CfnFunctionDefinitionVersion {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-environment.html
     */
    interface EnvironmentProperty {
        /**
         * `CfnFunctionDefinitionVersion.EnvironmentProperty.AccessSysfs`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-environment.html#cfn-greengrass-functiondefinitionversion-environment-accesssysfs
         */
        readonly accessSysfs?: boolean | cdk.IResolvable;
        /**
         * `CfnFunctionDefinitionVersion.EnvironmentProperty.Execution`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-environment.html#cfn-greengrass-functiondefinitionversion-environment-execution
         */
        readonly execution?: CfnFunctionDefinitionVersion.ExecutionProperty | cdk.IResolvable;
        /**
         * `CfnFunctionDefinitionVersion.EnvironmentProperty.ResourceAccessPolicies`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-environment.html#cfn-greengrass-functiondefinitionversion-environment-resourceaccesspolicies
         */
        readonly resourceAccessPolicies?: Array<CfnFunctionDefinitionVersion.ResourceAccessPolicyProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFunctionDefinitionVersion.EnvironmentProperty.Variables`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-environment.html#cfn-greengrass-functiondefinitionversion-environment-variables
         */
        readonly variables?: any | cdk.IResolvable;
    }
}
export declare namespace CfnFunctionDefinitionVersion {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-execution.html
     */
    interface ExecutionProperty {
        /**
         * `CfnFunctionDefinitionVersion.ExecutionProperty.IsolationMode`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-execution.html#cfn-greengrass-functiondefinitionversion-execution-isolationmode
         */
        readonly isolationMode?: string;
        /**
         * `CfnFunctionDefinitionVersion.ExecutionProperty.RunAs`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-execution.html#cfn-greengrass-functiondefinitionversion-execution-runas
         */
        readonly runAs?: CfnFunctionDefinitionVersion.RunAsProperty | cdk.IResolvable;
    }
}
export declare namespace CfnFunctionDefinitionVersion {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-function.html
     */
    interface FunctionProperty {
        /**
         * `CfnFunctionDefinitionVersion.FunctionProperty.FunctionArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-function.html#cfn-greengrass-functiondefinitionversion-function-functionarn
         */
        readonly functionArn: string;
        /**
         * `CfnFunctionDefinitionVersion.FunctionProperty.FunctionConfiguration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-function.html#cfn-greengrass-functiondefinitionversion-function-functionconfiguration
         */
        readonly functionConfiguration: CfnFunctionDefinitionVersion.FunctionConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnFunctionDefinitionVersion.FunctionProperty.Id`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-function.html#cfn-greengrass-functiondefinitionversion-function-id
         */
        readonly id: string;
    }
}
export declare namespace CfnFunctionDefinitionVersion {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-functionconfiguration.html
     */
    interface FunctionConfigurationProperty {
        /**
         * `CfnFunctionDefinitionVersion.FunctionConfigurationProperty.EncodingType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-functionconfiguration.html#cfn-greengrass-functiondefinitionversion-functionconfiguration-encodingtype
         */
        readonly encodingType?: string;
        /**
         * `CfnFunctionDefinitionVersion.FunctionConfigurationProperty.Environment`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-functionconfiguration.html#cfn-greengrass-functiondefinitionversion-functionconfiguration-environment
         */
        readonly environment?: CfnFunctionDefinitionVersion.EnvironmentProperty | cdk.IResolvable;
        /**
         * `CfnFunctionDefinitionVersion.FunctionConfigurationProperty.ExecArgs`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-functionconfiguration.html#cfn-greengrass-functiondefinitionversion-functionconfiguration-execargs
         */
        readonly execArgs?: string;
        /**
         * `CfnFunctionDefinitionVersion.FunctionConfigurationProperty.Executable`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-functionconfiguration.html#cfn-greengrass-functiondefinitionversion-functionconfiguration-executable
         */
        readonly executable?: string;
        /**
         * `CfnFunctionDefinitionVersion.FunctionConfigurationProperty.MemorySize`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-functionconfiguration.html#cfn-greengrass-functiondefinitionversion-functionconfiguration-memorysize
         */
        readonly memorySize?: number;
        /**
         * `CfnFunctionDefinitionVersion.FunctionConfigurationProperty.Pinned`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-functionconfiguration.html#cfn-greengrass-functiondefinitionversion-functionconfiguration-pinned
         */
        readonly pinned?: boolean | cdk.IResolvable;
        /**
         * `CfnFunctionDefinitionVersion.FunctionConfigurationProperty.Timeout`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-functionconfiguration.html#cfn-greengrass-functiondefinitionversion-functionconfiguration-timeout
         */
        readonly timeout?: number;
    }
}
export declare namespace CfnFunctionDefinitionVersion {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-resourceaccesspolicy.html
     */
    interface ResourceAccessPolicyProperty {
        /**
         * `CfnFunctionDefinitionVersion.ResourceAccessPolicyProperty.Permission`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-resourceaccesspolicy.html#cfn-greengrass-functiondefinitionversion-resourceaccesspolicy-permission
         */
        readonly permission?: string;
        /**
         * `CfnFunctionDefinitionVersion.ResourceAccessPolicyProperty.ResourceId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-resourceaccesspolicy.html#cfn-greengrass-functiondefinitionversion-resourceaccesspolicy-resourceid
         */
        readonly resourceId: string;
    }
}
export declare namespace CfnFunctionDefinitionVersion {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-runas.html
     */
    interface RunAsProperty {
        /**
         * `CfnFunctionDefinitionVersion.RunAsProperty.Gid`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-runas.html#cfn-greengrass-functiondefinitionversion-runas-gid
         */
        readonly gid?: number;
        /**
         * `CfnFunctionDefinitionVersion.RunAsProperty.Uid`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-runas.html#cfn-greengrass-functiondefinitionversion-runas-uid
         */
        readonly uid?: number;
    }
}
/**
 * Properties for defining a `AWS::Greengrass::Group`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html
 */
export interface CfnGroupProps {
    /**
     * `AWS::Greengrass::Group.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html#cfn-greengrass-group-name
     */
    readonly name: string;
    /**
     * `AWS::Greengrass::Group.InitialVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html#cfn-greengrass-group-initialversion
     */
    readonly initialVersion?: CfnGroup.GroupVersionProperty | cdk.IResolvable;
    /**
     * `AWS::Greengrass::Group.RoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html#cfn-greengrass-group-rolearn
     */
    readonly roleArn?: string;
    /**
     * `AWS::Greengrass::Group.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html#cfn-greengrass-group-tags
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::Greengrass::Group`
 *
 * @cloudformationResource AWS::Greengrass::Group
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html
 */
export declare class CfnGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Greengrass::Group";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * @cloudformationAttribute LatestVersionArn
     */
    readonly attrLatestVersionArn: string;
    /**
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * @cloudformationAttribute RoleArn
     */
    readonly attrRoleArn: string;
    /**
     * @cloudformationAttribute RoleAttachedAt
     */
    readonly attrRoleAttachedAt: string;
    /**
     * `AWS::Greengrass::Group.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html#cfn-greengrass-group-name
     */
    name: string;
    /**
     * `AWS::Greengrass::Group.InitialVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html#cfn-greengrass-group-initialversion
     */
    initialVersion: CfnGroup.GroupVersionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Greengrass::Group.RoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html#cfn-greengrass-group-rolearn
     */
    roleArn: string | undefined;
    /**
     * `AWS::Greengrass::Group.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html#cfn-greengrass-group-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Greengrass::Group`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnGroupProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-group-groupversion.html
     */
    interface GroupVersionProperty {
        /**
         * `CfnGroup.GroupVersionProperty.ConnectorDefinitionVersionArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-group-groupversion.html#cfn-greengrass-group-groupversion-connectordefinitionversionarn
         */
        readonly connectorDefinitionVersionArn?: string;
        /**
         * `CfnGroup.GroupVersionProperty.CoreDefinitionVersionArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-group-groupversion.html#cfn-greengrass-group-groupversion-coredefinitionversionarn
         */
        readonly coreDefinitionVersionArn?: string;
        /**
         * `CfnGroup.GroupVersionProperty.DeviceDefinitionVersionArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-group-groupversion.html#cfn-greengrass-group-groupversion-devicedefinitionversionarn
         */
        readonly deviceDefinitionVersionArn?: string;
        /**
         * `CfnGroup.GroupVersionProperty.FunctionDefinitionVersionArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-group-groupversion.html#cfn-greengrass-group-groupversion-functiondefinitionversionarn
         */
        readonly functionDefinitionVersionArn?: string;
        /**
         * `CfnGroup.GroupVersionProperty.LoggerDefinitionVersionArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-group-groupversion.html#cfn-greengrass-group-groupversion-loggerdefinitionversionarn
         */
        readonly loggerDefinitionVersionArn?: string;
        /**
         * `CfnGroup.GroupVersionProperty.ResourceDefinitionVersionArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-group-groupversion.html#cfn-greengrass-group-groupversion-resourcedefinitionversionarn
         */
        readonly resourceDefinitionVersionArn?: string;
        /**
         * `CfnGroup.GroupVersionProperty.SubscriptionDefinitionVersionArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-group-groupversion.html#cfn-greengrass-group-groupversion-subscriptiondefinitionversionarn
         */
        readonly subscriptionDefinitionVersionArn?: string;
    }
}
/**
 * Properties for defining a `AWS::Greengrass::GroupVersion`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html
 */
export interface CfnGroupVersionProps {
    /**
     * `AWS::Greengrass::GroupVersion.GroupId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-groupid
     */
    readonly groupId: string;
    /**
     * `AWS::Greengrass::GroupVersion.ConnectorDefinitionVersionArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-connectordefinitionversionarn
     */
    readonly connectorDefinitionVersionArn?: string;
    /**
     * `AWS::Greengrass::GroupVersion.CoreDefinitionVersionArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-coredefinitionversionarn
     */
    readonly coreDefinitionVersionArn?: string;
    /**
     * `AWS::Greengrass::GroupVersion.DeviceDefinitionVersionArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-devicedefinitionversionarn
     */
    readonly deviceDefinitionVersionArn?: string;
    /**
     * `AWS::Greengrass::GroupVersion.FunctionDefinitionVersionArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-functiondefinitionversionarn
     */
    readonly functionDefinitionVersionArn?: string;
    /**
     * `AWS::Greengrass::GroupVersion.LoggerDefinitionVersionArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-loggerdefinitionversionarn
     */
    readonly loggerDefinitionVersionArn?: string;
    /**
     * `AWS::Greengrass::GroupVersion.ResourceDefinitionVersionArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-resourcedefinitionversionarn
     */
    readonly resourceDefinitionVersionArn?: string;
    /**
     * `AWS::Greengrass::GroupVersion.SubscriptionDefinitionVersionArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-subscriptiondefinitionversionarn
     */
    readonly subscriptionDefinitionVersionArn?: string;
}
/**
 * A CloudFormation `AWS::Greengrass::GroupVersion`
 *
 * @cloudformationResource AWS::Greengrass::GroupVersion
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html
 */
export declare class CfnGroupVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Greengrass::GroupVersion";
    /**
     * `AWS::Greengrass::GroupVersion.GroupId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-groupid
     */
    groupId: string;
    /**
     * `AWS::Greengrass::GroupVersion.ConnectorDefinitionVersionArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-connectordefinitionversionarn
     */
    connectorDefinitionVersionArn: string | undefined;
    /**
     * `AWS::Greengrass::GroupVersion.CoreDefinitionVersionArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-coredefinitionversionarn
     */
    coreDefinitionVersionArn: string | undefined;
    /**
     * `AWS::Greengrass::GroupVersion.DeviceDefinitionVersionArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-devicedefinitionversionarn
     */
    deviceDefinitionVersionArn: string | undefined;
    /**
     * `AWS::Greengrass::GroupVersion.FunctionDefinitionVersionArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-functiondefinitionversionarn
     */
    functionDefinitionVersionArn: string | undefined;
    /**
     * `AWS::Greengrass::GroupVersion.LoggerDefinitionVersionArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-loggerdefinitionversionarn
     */
    loggerDefinitionVersionArn: string | undefined;
    /**
     * `AWS::Greengrass::GroupVersion.ResourceDefinitionVersionArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-resourcedefinitionversionarn
     */
    resourceDefinitionVersionArn: string | undefined;
    /**
     * `AWS::Greengrass::GroupVersion.SubscriptionDefinitionVersionArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-groupversion.html#cfn-greengrass-groupversion-subscriptiondefinitionversionarn
     */
    subscriptionDefinitionVersionArn: string | undefined;
    /**
     * Create a new `AWS::Greengrass::GroupVersion`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnGroupVersionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Greengrass::LoggerDefinition`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinition.html
 */
export interface CfnLoggerDefinitionProps {
    /**
     * `AWS::Greengrass::LoggerDefinition.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinition.html#cfn-greengrass-loggerdefinition-name
     */
    readonly name: string;
    /**
     * `AWS::Greengrass::LoggerDefinition.InitialVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinition.html#cfn-greengrass-loggerdefinition-initialversion
     */
    readonly initialVersion?: CfnLoggerDefinition.LoggerDefinitionVersionProperty | cdk.IResolvable;
    /**
     * `AWS::Greengrass::LoggerDefinition.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinition.html#cfn-greengrass-loggerdefinition-tags
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::Greengrass::LoggerDefinition`
 *
 * @cloudformationResource AWS::Greengrass::LoggerDefinition
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinition.html
 */
export declare class CfnLoggerDefinition extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Greengrass::LoggerDefinition";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * @cloudformationAttribute LatestVersionArn
     */
    readonly attrLatestVersionArn: string;
    /**
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::Greengrass::LoggerDefinition.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinition.html#cfn-greengrass-loggerdefinition-name
     */
    name: string;
    /**
     * `AWS::Greengrass::LoggerDefinition.InitialVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinition.html#cfn-greengrass-loggerdefinition-initialversion
     */
    initialVersion: CfnLoggerDefinition.LoggerDefinitionVersionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Greengrass::LoggerDefinition.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinition.html#cfn-greengrass-loggerdefinition-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Greengrass::LoggerDefinition`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLoggerDefinitionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnLoggerDefinition {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-logger.html
     */
    interface LoggerProperty {
        /**
         * `CfnLoggerDefinition.LoggerProperty.Component`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-logger.html#cfn-greengrass-loggerdefinition-logger-component
         */
        readonly component: string;
        /**
         * `CfnLoggerDefinition.LoggerProperty.Id`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-logger.html#cfn-greengrass-loggerdefinition-logger-id
         */
        readonly id: string;
        /**
         * `CfnLoggerDefinition.LoggerProperty.Level`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-logger.html#cfn-greengrass-loggerdefinition-logger-level
         */
        readonly level: string;
        /**
         * `CfnLoggerDefinition.LoggerProperty.Space`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-logger.html#cfn-greengrass-loggerdefinition-logger-space
         */
        readonly space?: number;
        /**
         * `CfnLoggerDefinition.LoggerProperty.Type`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-logger.html#cfn-greengrass-loggerdefinition-logger-type
         */
        readonly type: string;
    }
}
export declare namespace CfnLoggerDefinition {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-loggerdefinitionversion.html
     */
    interface LoggerDefinitionVersionProperty {
        /**
         * `CfnLoggerDefinition.LoggerDefinitionVersionProperty.Loggers`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinition-loggerdefinitionversion.html#cfn-greengrass-loggerdefinition-loggerdefinitionversion-loggers
         */
        readonly loggers: Array<CfnLoggerDefinition.LoggerProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::Greengrass::LoggerDefinitionVersion`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinitionversion.html
 */
export interface CfnLoggerDefinitionVersionProps {
    /**
     * `AWS::Greengrass::LoggerDefinitionVersion.LoggerDefinitionId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinitionversion.html#cfn-greengrass-loggerdefinitionversion-loggerdefinitionid
     */
    readonly loggerDefinitionId: string;
    /**
     * `AWS::Greengrass::LoggerDefinitionVersion.Loggers`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinitionversion.html#cfn-greengrass-loggerdefinitionversion-loggers
     */
    readonly loggers: Array<CfnLoggerDefinitionVersion.LoggerProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Greengrass::LoggerDefinitionVersion`
 *
 * @cloudformationResource AWS::Greengrass::LoggerDefinitionVersion
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinitionversion.html
 */
export declare class CfnLoggerDefinitionVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Greengrass::LoggerDefinitionVersion";
    /**
     * `AWS::Greengrass::LoggerDefinitionVersion.LoggerDefinitionId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinitionversion.html#cfn-greengrass-loggerdefinitionversion-loggerdefinitionid
     */
    loggerDefinitionId: string;
    /**
     * `AWS::Greengrass::LoggerDefinitionVersion.Loggers`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-loggerdefinitionversion.html#cfn-greengrass-loggerdefinitionversion-loggers
     */
    loggers: Array<CfnLoggerDefinitionVersion.LoggerProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * Create a new `AWS::Greengrass::LoggerDefinitionVersion`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLoggerDefinitionVersionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnLoggerDefinitionVersion {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinitionversion-logger.html
     */
    interface LoggerProperty {
        /**
         * `CfnLoggerDefinitionVersion.LoggerProperty.Component`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinitionversion-logger.html#cfn-greengrass-loggerdefinitionversion-logger-component
         */
        readonly component: string;
        /**
         * `CfnLoggerDefinitionVersion.LoggerProperty.Id`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinitionversion-logger.html#cfn-greengrass-loggerdefinitionversion-logger-id
         */
        readonly id: string;
        /**
         * `CfnLoggerDefinitionVersion.LoggerProperty.Level`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinitionversion-logger.html#cfn-greengrass-loggerdefinitionversion-logger-level
         */
        readonly level: string;
        /**
         * `CfnLoggerDefinitionVersion.LoggerProperty.Space`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinitionversion-logger.html#cfn-greengrass-loggerdefinitionversion-logger-space
         */
        readonly space?: number;
        /**
         * `CfnLoggerDefinitionVersion.LoggerProperty.Type`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-loggerdefinitionversion-logger.html#cfn-greengrass-loggerdefinitionversion-logger-type
         */
        readonly type: string;
    }
}
/**
 * Properties for defining a `AWS::Greengrass::ResourceDefinition`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinition.html
 */
export interface CfnResourceDefinitionProps {
    /**
     * `AWS::Greengrass::ResourceDefinition.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinition.html#cfn-greengrass-resourcedefinition-name
     */
    readonly name: string;
    /**
     * `AWS::Greengrass::ResourceDefinition.InitialVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinition.html#cfn-greengrass-resourcedefinition-initialversion
     */
    readonly initialVersion?: CfnResourceDefinition.ResourceDefinitionVersionProperty | cdk.IResolvable;
    /**
     * `AWS::Greengrass::ResourceDefinition.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinition.html#cfn-greengrass-resourcedefinition-tags
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::Greengrass::ResourceDefinition`
 *
 * @cloudformationResource AWS::Greengrass::ResourceDefinition
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinition.html
 */
export declare class CfnResourceDefinition extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Greengrass::ResourceDefinition";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * @cloudformationAttribute LatestVersionArn
     */
    readonly attrLatestVersionArn: string;
    /**
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::Greengrass::ResourceDefinition.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinition.html#cfn-greengrass-resourcedefinition-name
     */
    name: string;
    /**
     * `AWS::Greengrass::ResourceDefinition.InitialVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinition.html#cfn-greengrass-resourcedefinition-initialversion
     */
    initialVersion: CfnResourceDefinition.ResourceDefinitionVersionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Greengrass::ResourceDefinition.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinition.html#cfn-greengrass-resourcedefinition-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Greengrass::ResourceDefinition`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnResourceDefinitionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnResourceDefinition {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-groupownersetting.html
     */
    interface GroupOwnerSettingProperty {
        /**
         * `CfnResourceDefinition.GroupOwnerSettingProperty.AutoAddGroupOwner`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-groupownersetting.html#cfn-greengrass-resourcedefinition-groupownersetting-autoaddgroupowner
         */
        readonly autoAddGroupOwner: boolean | cdk.IResolvable;
        /**
         * `CfnResourceDefinition.GroupOwnerSettingProperty.GroupOwner`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-groupownersetting.html#cfn-greengrass-resourcedefinition-groupownersetting-groupowner
         */
        readonly groupOwner?: string;
    }
}
export declare namespace CfnResourceDefinition {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-localdeviceresourcedata.html
     */
    interface LocalDeviceResourceDataProperty {
        /**
         * `CfnResourceDefinition.LocalDeviceResourceDataProperty.GroupOwnerSetting`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-localdeviceresourcedata.html#cfn-greengrass-resourcedefinition-localdeviceresourcedata-groupownersetting
         */
        readonly groupOwnerSetting?: CfnResourceDefinition.GroupOwnerSettingProperty | cdk.IResolvable;
        /**
         * `CfnResourceDefinition.LocalDeviceResourceDataProperty.SourcePath`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-localdeviceresourcedata.html#cfn-greengrass-resourcedefinition-localdeviceresourcedata-sourcepath
         */
        readonly sourcePath: string;
    }
}
export declare namespace CfnResourceDefinition {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-localvolumeresourcedata.html
     */
    interface LocalVolumeResourceDataProperty {
        /**
         * `CfnResourceDefinition.LocalVolumeResourceDataProperty.DestinationPath`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-localvolumeresourcedata.html#cfn-greengrass-resourcedefinition-localvolumeresourcedata-destinationpath
         */
        readonly destinationPath: string;
        /**
         * `CfnResourceDefinition.LocalVolumeResourceDataProperty.GroupOwnerSetting`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-localvolumeresourcedata.html#cfn-greengrass-resourcedefinition-localvolumeresourcedata-groupownersetting
         */
        readonly groupOwnerSetting?: CfnResourceDefinition.GroupOwnerSettingProperty | cdk.IResolvable;
        /**
         * `CfnResourceDefinition.LocalVolumeResourceDataProperty.SourcePath`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-localvolumeresourcedata.html#cfn-greengrass-resourcedefinition-localvolumeresourcedata-sourcepath
         */
        readonly sourcePath: string;
    }
}
export declare namespace CfnResourceDefinition {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-resourcedatacontainer.html
     */
    interface ResourceDataContainerProperty {
        /**
         * `CfnResourceDefinition.ResourceDataContainerProperty.LocalDeviceResourceData`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-resourcedatacontainer.html#cfn-greengrass-resourcedefinition-resourcedatacontainer-localdeviceresourcedata
         */
        readonly localDeviceResourceData?: CfnResourceDefinition.LocalDeviceResourceDataProperty | cdk.IResolvable;
        /**
         * `CfnResourceDefinition.ResourceDataContainerProperty.LocalVolumeResourceData`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-resourcedatacontainer.html#cfn-greengrass-resourcedefinition-resourcedatacontainer-localvolumeresourcedata
         */
        readonly localVolumeResourceData?: CfnResourceDefinition.LocalVolumeResourceDataProperty | cdk.IResolvable;
        /**
         * `CfnResourceDefinition.ResourceDataContainerProperty.S3MachineLearningModelResourceData`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-resourcedatacontainer.html#cfn-greengrass-resourcedefinition-resourcedatacontainer-s3machinelearningmodelresourcedata
         */
        readonly s3MachineLearningModelResourceData?: CfnResourceDefinition.S3MachineLearningModelResourceDataProperty | cdk.IResolvable;
        /**
         * `CfnResourceDefinition.ResourceDataContainerProperty.SageMakerMachineLearningModelResourceData`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-resourcedatacontainer.html#cfn-greengrass-resourcedefinition-resourcedatacontainer-sagemakermachinelearningmodelresourcedata
         */
        readonly sageMakerMachineLearningModelResourceData?: CfnResourceDefinition.SageMakerMachineLearningModelResourceDataProperty | cdk.IResolvable;
        /**
         * `CfnResourceDefinition.ResourceDataContainerProperty.SecretsManagerSecretResourceData`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-resourcedatacontainer.html#cfn-greengrass-resourcedefinition-resourcedatacontainer-secretsmanagersecretresourcedata
         */
        readonly secretsManagerSecretResourceData?: CfnResourceDefinition.SecretsManagerSecretResourceDataProperty | cdk.IResolvable;
    }
}
export declare namespace CfnResourceDefinition {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-resourcedefinitionversion.html
     */
    interface ResourceDefinitionVersionProperty {
        /**
         * `CfnResourceDefinition.ResourceDefinitionVersionProperty.Resources`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-resourcedefinitionversion.html#cfn-greengrass-resourcedefinition-resourcedefinitionversion-resources
         */
        readonly resources: Array<CfnResourceDefinition.ResourceInstanceProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnResourceDefinition {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-resourcedownloadownersetting.html
     */
    interface ResourceDownloadOwnerSettingProperty {
        /**
         * `CfnResourceDefinition.ResourceDownloadOwnerSettingProperty.GroupOwner`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-resourcedownloadownersetting.html#cfn-greengrass-resourcedefinition-resourcedownloadownersetting-groupowner
         */
        readonly groupOwner: string;
        /**
         * `CfnResourceDefinition.ResourceDownloadOwnerSettingProperty.GroupPermission`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-resourcedownloadownersetting.html#cfn-greengrass-resourcedefinition-resourcedownloadownersetting-grouppermission
         */
        readonly groupPermission: string;
    }
}
export declare namespace CfnResourceDefinition {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-resourceinstance.html
     */
    interface ResourceInstanceProperty {
        /**
         * `CfnResourceDefinition.ResourceInstanceProperty.Id`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-resourceinstance.html#cfn-greengrass-resourcedefinition-resourceinstance-id
         */
        readonly id: string;
        /**
         * `CfnResourceDefinition.ResourceInstanceProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-resourceinstance.html#cfn-greengrass-resourcedefinition-resourceinstance-name
         */
        readonly name: string;
        /**
         * `CfnResourceDefinition.ResourceInstanceProperty.ResourceDataContainer`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-resourceinstance.html#cfn-greengrass-resourcedefinition-resourceinstance-resourcedatacontainer
         */
        readonly resourceDataContainer: CfnResourceDefinition.ResourceDataContainerProperty | cdk.IResolvable;
    }
}
export declare namespace CfnResourceDefinition {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-s3machinelearningmodelresourcedata.html
     */
    interface S3MachineLearningModelResourceDataProperty {
        /**
         * `CfnResourceDefinition.S3MachineLearningModelResourceDataProperty.DestinationPath`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-s3machinelearningmodelresourcedata.html#cfn-greengrass-resourcedefinition-s3machinelearningmodelresourcedata-destinationpath
         */
        readonly destinationPath: string;
        /**
         * `CfnResourceDefinition.S3MachineLearningModelResourceDataProperty.OwnerSetting`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-s3machinelearningmodelresourcedata.html#cfn-greengrass-resourcedefinition-s3machinelearningmodelresourcedata-ownersetting
         */
        readonly ownerSetting?: CfnResourceDefinition.ResourceDownloadOwnerSettingProperty | cdk.IResolvable;
        /**
         * `CfnResourceDefinition.S3MachineLearningModelResourceDataProperty.S3Uri`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-s3machinelearningmodelresourcedata.html#cfn-greengrass-resourcedefinition-s3machinelearningmodelresourcedata-s3uri
         */
        readonly s3Uri: string;
    }
}
export declare namespace CfnResourceDefinition {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-sagemakermachinelearningmodelresourcedata.html
     */
    interface SageMakerMachineLearningModelResourceDataProperty {
        /**
         * `CfnResourceDefinition.SageMakerMachineLearningModelResourceDataProperty.DestinationPath`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-sagemakermachinelearningmodelresourcedata.html#cfn-greengrass-resourcedefinition-sagemakermachinelearningmodelresourcedata-destinationpath
         */
        readonly destinationPath: string;
        /**
         * `CfnResourceDefinition.SageMakerMachineLearningModelResourceDataProperty.OwnerSetting`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-sagemakermachinelearningmodelresourcedata.html#cfn-greengrass-resourcedefinition-sagemakermachinelearningmodelresourcedata-ownersetting
         */
        readonly ownerSetting?: CfnResourceDefinition.ResourceDownloadOwnerSettingProperty | cdk.IResolvable;
        /**
         * `CfnResourceDefinition.SageMakerMachineLearningModelResourceDataProperty.SageMakerJobArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-sagemakermachinelearningmodelresourcedata.html#cfn-greengrass-resourcedefinition-sagemakermachinelearningmodelresourcedata-sagemakerjobarn
         */
        readonly sageMakerJobArn: string;
    }
}
export declare namespace CfnResourceDefinition {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-secretsmanagersecretresourcedata.html
     */
    interface SecretsManagerSecretResourceDataProperty {
        /**
         * `CfnResourceDefinition.SecretsManagerSecretResourceDataProperty.ARN`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-secretsmanagersecretresourcedata.html#cfn-greengrass-resourcedefinition-secretsmanagersecretresourcedata-arn
         */
        readonly arn: string;
        /**
         * `CfnResourceDefinition.SecretsManagerSecretResourceDataProperty.AdditionalStagingLabelsToDownload`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinition-secretsmanagersecretresourcedata.html#cfn-greengrass-resourcedefinition-secretsmanagersecretresourcedata-additionalstaginglabelstodownload
         */
        readonly additionalStagingLabelsToDownload?: string[];
    }
}
/**
 * Properties for defining a `AWS::Greengrass::ResourceDefinitionVersion`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinitionversion.html
 */
export interface CfnResourceDefinitionVersionProps {
    /**
     * `AWS::Greengrass::ResourceDefinitionVersion.ResourceDefinitionId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinitionversion.html#cfn-greengrass-resourcedefinitionversion-resourcedefinitionid
     */
    readonly resourceDefinitionId: string;
    /**
     * `AWS::Greengrass::ResourceDefinitionVersion.Resources`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinitionversion.html#cfn-greengrass-resourcedefinitionversion-resources
     */
    readonly resources: Array<CfnResourceDefinitionVersion.ResourceInstanceProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Greengrass::ResourceDefinitionVersion`
 *
 * @cloudformationResource AWS::Greengrass::ResourceDefinitionVersion
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinitionversion.html
 */
export declare class CfnResourceDefinitionVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Greengrass::ResourceDefinitionVersion";
    /**
     * `AWS::Greengrass::ResourceDefinitionVersion.ResourceDefinitionId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinitionversion.html#cfn-greengrass-resourcedefinitionversion-resourcedefinitionid
     */
    resourceDefinitionId: string;
    /**
     * `AWS::Greengrass::ResourceDefinitionVersion.Resources`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-resourcedefinitionversion.html#cfn-greengrass-resourcedefinitionversion-resources
     */
    resources: Array<CfnResourceDefinitionVersion.ResourceInstanceProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * Create a new `AWS::Greengrass::ResourceDefinitionVersion`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnResourceDefinitionVersionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnResourceDefinitionVersion {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-groupownersetting.html
     */
    interface GroupOwnerSettingProperty {
        /**
         * `CfnResourceDefinitionVersion.GroupOwnerSettingProperty.AutoAddGroupOwner`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-groupownersetting.html#cfn-greengrass-resourcedefinitionversion-groupownersetting-autoaddgroupowner
         */
        readonly autoAddGroupOwner: boolean | cdk.IResolvable;
        /**
         * `CfnResourceDefinitionVersion.GroupOwnerSettingProperty.GroupOwner`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-groupownersetting.html#cfn-greengrass-resourcedefinitionversion-groupownersetting-groupowner
         */
        readonly groupOwner?: string;
    }
}
export declare namespace CfnResourceDefinitionVersion {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-localdeviceresourcedata.html
     */
    interface LocalDeviceResourceDataProperty {
        /**
         * `CfnResourceDefinitionVersion.LocalDeviceResourceDataProperty.GroupOwnerSetting`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-localdeviceresourcedata.html#cfn-greengrass-resourcedefinitionversion-localdeviceresourcedata-groupownersetting
         */
        readonly groupOwnerSetting?: CfnResourceDefinitionVersion.GroupOwnerSettingProperty | cdk.IResolvable;
        /**
         * `CfnResourceDefinitionVersion.LocalDeviceResourceDataProperty.SourcePath`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-localdeviceresourcedata.html#cfn-greengrass-resourcedefinitionversion-localdeviceresourcedata-sourcepath
         */
        readonly sourcePath: string;
    }
}
export declare namespace CfnResourceDefinitionVersion {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-localvolumeresourcedata.html
     */
    interface LocalVolumeResourceDataProperty {
        /**
         * `CfnResourceDefinitionVersion.LocalVolumeResourceDataProperty.DestinationPath`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-localvolumeresourcedata.html#cfn-greengrass-resourcedefinitionversion-localvolumeresourcedata-destinationpath
         */
        readonly destinationPath: string;
        /**
         * `CfnResourceDefinitionVersion.LocalVolumeResourceDataProperty.GroupOwnerSetting`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-localvolumeresourcedata.html#cfn-greengrass-resourcedefinitionversion-localvolumeresourcedata-groupownersetting
         */
        readonly groupOwnerSetting?: CfnResourceDefinitionVersion.GroupOwnerSettingProperty | cdk.IResolvable;
        /**
         * `CfnResourceDefinitionVersion.LocalVolumeResourceDataProperty.SourcePath`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-localvolumeresourcedata.html#cfn-greengrass-resourcedefinitionversion-localvolumeresourcedata-sourcepath
         */
        readonly sourcePath: string;
    }
}
export declare namespace CfnResourceDefinitionVersion {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedatacontainer.html
     */
    interface ResourceDataContainerProperty {
        /**
         * `CfnResourceDefinitionVersion.ResourceDataContainerProperty.LocalDeviceResourceData`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedatacontainer.html#cfn-greengrass-resourcedefinitionversion-resourcedatacontainer-localdeviceresourcedata
         */
        readonly localDeviceResourceData?: CfnResourceDefinitionVersion.LocalDeviceResourceDataProperty | cdk.IResolvable;
        /**
         * `CfnResourceDefinitionVersion.ResourceDataContainerProperty.LocalVolumeResourceData`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedatacontainer.html#cfn-greengrass-resourcedefinitionversion-resourcedatacontainer-localvolumeresourcedata
         */
        readonly localVolumeResourceData?: CfnResourceDefinitionVersion.LocalVolumeResourceDataProperty | cdk.IResolvable;
        /**
         * `CfnResourceDefinitionVersion.ResourceDataContainerProperty.S3MachineLearningModelResourceData`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedatacontainer.html#cfn-greengrass-resourcedefinitionversion-resourcedatacontainer-s3machinelearningmodelresourcedata
         */
        readonly s3MachineLearningModelResourceData?: CfnResourceDefinitionVersion.S3MachineLearningModelResourceDataProperty | cdk.IResolvable;
        /**
         * `CfnResourceDefinitionVersion.ResourceDataContainerProperty.SageMakerMachineLearningModelResourceData`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedatacontainer.html#cfn-greengrass-resourcedefinitionversion-resourcedatacontainer-sagemakermachinelearningmodelresourcedata
         */
        readonly sageMakerMachineLearningModelResourceData?: CfnResourceDefinitionVersion.SageMakerMachineLearningModelResourceDataProperty | cdk.IResolvable;
        /**
         * `CfnResourceDefinitionVersion.ResourceDataContainerProperty.SecretsManagerSecretResourceData`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedatacontainer.html#cfn-greengrass-resourcedefinitionversion-resourcedatacontainer-secretsmanagersecretresourcedata
         */
        readonly secretsManagerSecretResourceData?: CfnResourceDefinitionVersion.SecretsManagerSecretResourceDataProperty | cdk.IResolvable;
    }
}
export declare namespace CfnResourceDefinitionVersion {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedownloadownersetting.html
     */
    interface ResourceDownloadOwnerSettingProperty {
        /**
         * `CfnResourceDefinitionVersion.ResourceDownloadOwnerSettingProperty.GroupOwner`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedownloadownersetting.html#cfn-greengrass-resourcedefinitionversion-resourcedownloadownersetting-groupowner
         */
        readonly groupOwner: string;
        /**
         * `CfnResourceDefinitionVersion.ResourceDownloadOwnerSettingProperty.GroupPermission`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourcedownloadownersetting.html#cfn-greengrass-resourcedefinitionversion-resourcedownloadownersetting-grouppermission
         */
        readonly groupPermission: string;
    }
}
export declare namespace CfnResourceDefinitionVersion {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourceinstance.html
     */
    interface ResourceInstanceProperty {
        /**
         * `CfnResourceDefinitionVersion.ResourceInstanceProperty.Id`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourceinstance.html#cfn-greengrass-resourcedefinitionversion-resourceinstance-id
         */
        readonly id: string;
        /**
         * `CfnResourceDefinitionVersion.ResourceInstanceProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourceinstance.html#cfn-greengrass-resourcedefinitionversion-resourceinstance-name
         */
        readonly name: string;
        /**
         * `CfnResourceDefinitionVersion.ResourceInstanceProperty.ResourceDataContainer`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourceinstance.html#cfn-greengrass-resourcedefinitionversion-resourceinstance-resourcedatacontainer
         */
        readonly resourceDataContainer: CfnResourceDefinitionVersion.ResourceDataContainerProperty | cdk.IResolvable;
    }
}
export declare namespace CfnResourceDefinitionVersion {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-s3machinelearningmodelresourcedata.html
     */
    interface S3MachineLearningModelResourceDataProperty {
        /**
         * `CfnResourceDefinitionVersion.S3MachineLearningModelResourceDataProperty.DestinationPath`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-s3machinelearningmodelresourcedata.html#cfn-greengrass-resourcedefinitionversion-s3machinelearningmodelresourcedata-destinationpath
         */
        readonly destinationPath: string;
        /**
         * `CfnResourceDefinitionVersion.S3MachineLearningModelResourceDataProperty.OwnerSetting`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-s3machinelearningmodelresourcedata.html#cfn-greengrass-resourcedefinitionversion-s3machinelearningmodelresourcedata-ownersetting
         */
        readonly ownerSetting?: CfnResourceDefinitionVersion.ResourceDownloadOwnerSettingProperty | cdk.IResolvable;
        /**
         * `CfnResourceDefinitionVersion.S3MachineLearningModelResourceDataProperty.S3Uri`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-s3machinelearningmodelresourcedata.html#cfn-greengrass-resourcedefinitionversion-s3machinelearningmodelresourcedata-s3uri
         */
        readonly s3Uri: string;
    }
}
export declare namespace CfnResourceDefinitionVersion {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-sagemakermachinelearningmodelresourcedata.html
     */
    interface SageMakerMachineLearningModelResourceDataProperty {
        /**
         * `CfnResourceDefinitionVersion.SageMakerMachineLearningModelResourceDataProperty.DestinationPath`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-sagemakermachinelearningmodelresourcedata.html#cfn-greengrass-resourcedefinitionversion-sagemakermachinelearningmodelresourcedata-destinationpath
         */
        readonly destinationPath: string;
        /**
         * `CfnResourceDefinitionVersion.SageMakerMachineLearningModelResourceDataProperty.OwnerSetting`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-sagemakermachinelearningmodelresourcedata.html#cfn-greengrass-resourcedefinitionversion-sagemakermachinelearningmodelresourcedata-ownersetting
         */
        readonly ownerSetting?: CfnResourceDefinitionVersion.ResourceDownloadOwnerSettingProperty | cdk.IResolvable;
        /**
         * `CfnResourceDefinitionVersion.SageMakerMachineLearningModelResourceDataProperty.SageMakerJobArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-sagemakermachinelearningmodelresourcedata.html#cfn-greengrass-resourcedefinitionversion-sagemakermachinelearningmodelresourcedata-sagemakerjobarn
         */
        readonly sageMakerJobArn: string;
    }
}
export declare namespace CfnResourceDefinitionVersion {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-secretsmanagersecretresourcedata.html
     */
    interface SecretsManagerSecretResourceDataProperty {
        /**
         * `CfnResourceDefinitionVersion.SecretsManagerSecretResourceDataProperty.ARN`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-secretsmanagersecretresourcedata.html#cfn-greengrass-resourcedefinitionversion-secretsmanagersecretresourcedata-arn
         */
        readonly arn: string;
        /**
         * `CfnResourceDefinitionVersion.SecretsManagerSecretResourceDataProperty.AdditionalStagingLabelsToDownload`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-secretsmanagersecretresourcedata.html#cfn-greengrass-resourcedefinitionversion-secretsmanagersecretresourcedata-additionalstaginglabelstodownload
         */
        readonly additionalStagingLabelsToDownload?: string[];
    }
}
/**
 * Properties for defining a `AWS::Greengrass::SubscriptionDefinition`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinition.html
 */
export interface CfnSubscriptionDefinitionProps {
    /**
     * `AWS::Greengrass::SubscriptionDefinition.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinition.html#cfn-greengrass-subscriptiondefinition-name
     */
    readonly name: string;
    /**
     * `AWS::Greengrass::SubscriptionDefinition.InitialVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinition.html#cfn-greengrass-subscriptiondefinition-initialversion
     */
    readonly initialVersion?: CfnSubscriptionDefinition.SubscriptionDefinitionVersionProperty | cdk.IResolvable;
    /**
     * `AWS::Greengrass::SubscriptionDefinition.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinition.html#cfn-greengrass-subscriptiondefinition-tags
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::Greengrass::SubscriptionDefinition`
 *
 * @cloudformationResource AWS::Greengrass::SubscriptionDefinition
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinition.html
 */
export declare class CfnSubscriptionDefinition extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Greengrass::SubscriptionDefinition";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * @cloudformationAttribute LatestVersionArn
     */
    readonly attrLatestVersionArn: string;
    /**
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::Greengrass::SubscriptionDefinition.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinition.html#cfn-greengrass-subscriptiondefinition-name
     */
    name: string;
    /**
     * `AWS::Greengrass::SubscriptionDefinition.InitialVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinition.html#cfn-greengrass-subscriptiondefinition-initialversion
     */
    initialVersion: CfnSubscriptionDefinition.SubscriptionDefinitionVersionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Greengrass::SubscriptionDefinition.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinition.html#cfn-greengrass-subscriptiondefinition-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Greengrass::SubscriptionDefinition`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSubscriptionDefinitionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnSubscriptionDefinition {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-subscriptiondefinition-subscription.html
     */
    interface SubscriptionProperty {
        /**
         * `CfnSubscriptionDefinition.SubscriptionProperty.Id`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-subscriptiondefinition-subscription.html#cfn-greengrass-subscriptiondefinition-subscription-id
         */
        readonly id: string;
        /**
         * `CfnSubscriptionDefinition.SubscriptionProperty.Source`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-subscriptiondefinition-subscription.html#cfn-greengrass-subscriptiondefinition-subscription-source
         */
        readonly source: string;
        /**
         * `CfnSubscriptionDefinition.SubscriptionProperty.Subject`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-subscriptiondefinition-subscription.html#cfn-greengrass-subscriptiondefinition-subscription-subject
         */
        readonly subject: string;
        /**
         * `CfnSubscriptionDefinition.SubscriptionProperty.Target`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-subscriptiondefinition-subscription.html#cfn-greengrass-subscriptiondefinition-subscription-target
         */
        readonly target: string;
    }
}
export declare namespace CfnSubscriptionDefinition {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-subscriptiondefinition-subscriptiondefinitionversion.html
     */
    interface SubscriptionDefinitionVersionProperty {
        /**
         * `CfnSubscriptionDefinition.SubscriptionDefinitionVersionProperty.Subscriptions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-subscriptiondefinition-subscriptiondefinitionversion.html#cfn-greengrass-subscriptiondefinition-subscriptiondefinitionversion-subscriptions
         */
        readonly subscriptions: Array<CfnSubscriptionDefinition.SubscriptionProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::Greengrass::SubscriptionDefinitionVersion`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinitionversion.html
 */
export interface CfnSubscriptionDefinitionVersionProps {
    /**
     * `AWS::Greengrass::SubscriptionDefinitionVersion.SubscriptionDefinitionId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinitionversion.html#cfn-greengrass-subscriptiondefinitionversion-subscriptiondefinitionid
     */
    readonly subscriptionDefinitionId: string;
    /**
     * `AWS::Greengrass::SubscriptionDefinitionVersion.Subscriptions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinitionversion.html#cfn-greengrass-subscriptiondefinitionversion-subscriptions
     */
    readonly subscriptions: Array<CfnSubscriptionDefinitionVersion.SubscriptionProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Greengrass::SubscriptionDefinitionVersion`
 *
 * @cloudformationResource AWS::Greengrass::SubscriptionDefinitionVersion
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinitionversion.html
 */
export declare class CfnSubscriptionDefinitionVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Greengrass::SubscriptionDefinitionVersion";
    /**
     * `AWS::Greengrass::SubscriptionDefinitionVersion.SubscriptionDefinitionId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinitionversion.html#cfn-greengrass-subscriptiondefinitionversion-subscriptiondefinitionid
     */
    subscriptionDefinitionId: string;
    /**
     * `AWS::Greengrass::SubscriptionDefinitionVersion.Subscriptions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-subscriptiondefinitionversion.html#cfn-greengrass-subscriptiondefinitionversion-subscriptions
     */
    subscriptions: Array<CfnSubscriptionDefinitionVersion.SubscriptionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * Create a new `AWS::Greengrass::SubscriptionDefinitionVersion`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSubscriptionDefinitionVersionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnSubscriptionDefinitionVersion {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-subscriptiondefinitionversion-subscription.html
     */
    interface SubscriptionProperty {
        /**
         * `CfnSubscriptionDefinitionVersion.SubscriptionProperty.Id`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-subscriptiondefinitionversion-subscription.html#cfn-greengrass-subscriptiondefinitionversion-subscription-id
         */
        readonly id: string;
        /**
         * `CfnSubscriptionDefinitionVersion.SubscriptionProperty.Source`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-subscriptiondefinitionversion-subscription.html#cfn-greengrass-subscriptiondefinitionversion-subscription-source
         */
        readonly source: string;
        /**
         * `CfnSubscriptionDefinitionVersion.SubscriptionProperty.Subject`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-subscriptiondefinitionversion-subscription.html#cfn-greengrass-subscriptiondefinitionversion-subscription-subject
         */
        readonly subject: string;
        /**
         * `CfnSubscriptionDefinitionVersion.SubscriptionProperty.Target`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-subscriptiondefinitionversion-subscription.html#cfn-greengrass-subscriptiondefinitionversion-subscription-target
         */
        readonly target: string;
    }
}
