"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PythonFunction = void 0;
const fs = require("fs");
const path = require("path");
const lambda = require("../../aws-lambda"); // Automatically re-written from '@aws-cdk/aws-lambda'
const bundling_1 = require("./bundling");
/**
 * A Python Lambda function
 */
class PythonFunction extends lambda.Function {
    constructor(scope, id, props) {
        var _a, _b, _c;
        if (props.runtime && props.runtime.family !== lambda.RuntimeFamily.PYTHON) {
            throw new Error('Only `PYTHON` runtimes are supported.');
        }
        if (props.index && !/\.py$/.test(props.index)) {
            throw new Error('Only Python (.py) index files are supported.');
        }
        // Entry and defaults
        const entry = path.resolve(props.entry);
        const index = (_a = props.index) !== null && _a !== void 0 ? _a : 'index.py';
        const resolvedIndex = path.resolve(entry, index);
        if (!fs.existsSync(resolvedIndex)) {
            throw new Error(`Cannot find index file at ${resolvedIndex}`);
        }
        const handler = (_b = props.handler) !== null && _b !== void 0 ? _b : 'handler';
        const runtime = (_c = props.runtime) !== null && _c !== void 0 ? _c : lambda.Runtime.PYTHON_3_7;
        super(scope, id, {
            ...props,
            runtime,
            code: bundling_1.bundle({
                ...props,
                entry,
                runtime,
            }),
            handler: `${index.slice(0, -3)}.${handler}`,
        });
    }
}
exports.PythonFunction = PythonFunction;
//# sourceMappingURL=data:application/json;base64,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