"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventInvokeConfig = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const destination_1 = require("./destination");
const lambda_generated_1 = require("./lambda.generated");
/**
 * Configure options for asynchronous invocation on a version or an alias
 *
 * By default, Lambda retries an asynchronous invocation twice if the function
 * returns an error. It retains events in a queue for up to six hours. When an
 * event fails all processing attempts or stays in the asynchronous invocation
 * queue for too long, Lambda discards it.
 */
class EventInvokeConfig extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        if (props.maxEventAge && (props.maxEventAge.toSeconds() < 60 || props.maxEventAge.toSeconds() > 21600)) {
            throw new Error('`maximumEventAge` must represent a `Duration` that is between 60 and 21600 seconds.');
        }
        if (props.retryAttempts && (props.retryAttempts < 0 || props.retryAttempts > 2)) {
            throw new Error('`retryAttempts` must be between 0 and 2.');
        }
        new lambda_generated_1.CfnEventInvokeConfig(this, 'Resource', {
            destinationConfig: props.onFailure || props.onSuccess
                ? {
                    ...props.onFailure ? { onFailure: props.onFailure.bind(this, props.function, { type: destination_1.DestinationType.FAILURE }) } : {},
                    ...props.onSuccess ? { onSuccess: props.onSuccess.bind(this, props.function, { type: destination_1.DestinationType.SUCCESS }) } : {},
                }
                : undefined,
            functionName: props.function.functionName,
            maximumEventAgeInSeconds: props.maxEventAge && props.maxEventAge.toSeconds(),
            maximumRetryAttempts: props.retryAttempts !== undefined ? props.retryAttempts : undefined,
            qualifier: props.qualifier || '$LATEST',
        });
    }
}
exports.EventInvokeConfig = EventInvokeConfig;
//# sourceMappingURL=data:application/json;base64,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