"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileSystem = void 0;
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * Represents the filesystem for the Lambda function
 * @experimental
 */
class FileSystem {
    /**
     * @param config the FileSystem configurations for the Lambda function
     */
    constructor(config) {
        this.config = config;
    }
    /**
     * mount the filesystem from Amazon EFS
     * @param ap the Amazon EFS access point
     * @param mountPath the target path in the lambda runtime environment
     */
    static fromEfsAccessPoint(ap, mountPath) {
        return new FileSystem({
            localMountPath: mountPath,
            arn: ap.accessPointArn,
            dependency: [ap.fileSystem.mountTargetsAvailable],
            connections: ap.fileSystem.connections,
            policies: [
                new iam.PolicyStatement({
                    actions: ['elasticfilesystem:ClientMount'],
                    resources: ['*'],
                    conditions: {
                        StringEquals: {
                            'elasticfilesystem:AccessPointArn': ap.accessPointArn,
                        },
                    },
                }),
                new iam.PolicyStatement({
                    actions: ['elasticfilesystem:ClientWrite'],
                    resources: [core_1.Stack.of(ap).formatArn({
                            service: 'elasticfilesystem',
                            resource: 'file-system',
                            resourceName: ap.fileSystem.fileSystemId,
                        })],
                }),
            ],
        });
    }
}
exports.FileSystem = FileSystem;
//# sourceMappingURL=data:application/json;base64,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