import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::ManagedBlockchain::Member`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html
 */
export interface CfnMemberProps {
    /**
     * `AWS::ManagedBlockchain::Member.MemberConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-memberconfiguration
     */
    readonly memberConfiguration: CfnMember.MemberConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::ManagedBlockchain::Member.InvitationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-invitationid
     */
    readonly invitationId?: string;
    /**
     * `AWS::ManagedBlockchain::Member.NetworkConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-networkconfiguration
     */
    readonly networkConfiguration?: CfnMember.NetworkConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::ManagedBlockchain::Member.NetworkId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-networkid
     */
    readonly networkId?: string;
}
/**
 * A CloudFormation `AWS::ManagedBlockchain::Member`
 *
 * @cloudformationResource AWS::ManagedBlockchain::Member
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html
 */
export declare class CfnMember extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ManagedBlockchain::Member";
    /**
     * @cloudformationAttribute MemberId
     */
    readonly attrMemberId: string;
    /**
     * @cloudformationAttribute NetworkId
     */
    readonly attrNetworkId: string;
    /**
     * `AWS::ManagedBlockchain::Member.MemberConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-memberconfiguration
     */
    memberConfiguration: CfnMember.MemberConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::ManagedBlockchain::Member.InvitationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-invitationid
     */
    invitationId: string | undefined;
    /**
     * `AWS::ManagedBlockchain::Member.NetworkConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-networkconfiguration
     */
    networkConfiguration: CfnMember.NetworkConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ManagedBlockchain::Member.NetworkId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-member.html#cfn-managedblockchain-member-networkid
     */
    networkId: string | undefined;
    /**
     * Create a new `AWS::ManagedBlockchain::Member`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnMemberProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnMember {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-approvalthresholdpolicy.html
     */
    interface ApprovalThresholdPolicyProperty {
        /**
         * `CfnMember.ApprovalThresholdPolicyProperty.ProposalDurationInHours`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-approvalthresholdpolicy.html#cfn-managedblockchain-member-approvalthresholdpolicy-proposaldurationinhours
         */
        readonly proposalDurationInHours?: number;
        /**
         * `CfnMember.ApprovalThresholdPolicyProperty.ThresholdComparator`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-approvalthresholdpolicy.html#cfn-managedblockchain-member-approvalthresholdpolicy-thresholdcomparator
         */
        readonly thresholdComparator?: string;
        /**
         * `CfnMember.ApprovalThresholdPolicyProperty.ThresholdPercentage`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-approvalthresholdpolicy.html#cfn-managedblockchain-member-approvalthresholdpolicy-thresholdpercentage
         */
        readonly thresholdPercentage?: number;
    }
}
export declare namespace CfnMember {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberconfiguration.html
     */
    interface MemberConfigurationProperty {
        /**
         * `CfnMember.MemberConfigurationProperty.Description`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberconfiguration.html#cfn-managedblockchain-member-memberconfiguration-description
         */
        readonly description?: string;
        /**
         * `CfnMember.MemberConfigurationProperty.MemberFrameworkConfiguration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberconfiguration.html#cfn-managedblockchain-member-memberconfiguration-memberframeworkconfiguration
         */
        readonly memberFrameworkConfiguration?: CfnMember.MemberFrameworkConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnMember.MemberConfigurationProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberconfiguration.html#cfn-managedblockchain-member-memberconfiguration-name
         */
        readonly name: string;
    }
}
export declare namespace CfnMember {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberfabricconfiguration.html
     */
    interface MemberFabricConfigurationProperty {
        /**
         * `CfnMember.MemberFabricConfigurationProperty.AdminPassword`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberfabricconfiguration.html#cfn-managedblockchain-member-memberfabricconfiguration-adminpassword
         */
        readonly adminPassword: string;
        /**
         * `CfnMember.MemberFabricConfigurationProperty.AdminUsername`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberfabricconfiguration.html#cfn-managedblockchain-member-memberfabricconfiguration-adminusername
         */
        readonly adminUsername: string;
    }
}
export declare namespace CfnMember {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberframeworkconfiguration.html
     */
    interface MemberFrameworkConfigurationProperty {
        /**
         * `CfnMember.MemberFrameworkConfigurationProperty.MemberFabricConfiguration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-memberframeworkconfiguration.html#cfn-managedblockchain-member-memberframeworkconfiguration-memberfabricconfiguration
         */
        readonly memberFabricConfiguration?: CfnMember.MemberFabricConfigurationProperty | cdk.IResolvable;
    }
}
export declare namespace CfnMember {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html
     */
    interface NetworkConfigurationProperty {
        /**
         * `CfnMember.NetworkConfigurationProperty.Description`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html#cfn-managedblockchain-member-networkconfiguration-description
         */
        readonly description?: string;
        /**
         * `CfnMember.NetworkConfigurationProperty.Framework`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html#cfn-managedblockchain-member-networkconfiguration-framework
         */
        readonly framework: string;
        /**
         * `CfnMember.NetworkConfigurationProperty.FrameworkVersion`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html#cfn-managedblockchain-member-networkconfiguration-frameworkversion
         */
        readonly frameworkVersion: string;
        /**
         * `CfnMember.NetworkConfigurationProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html#cfn-managedblockchain-member-networkconfiguration-name
         */
        readonly name: string;
        /**
         * `CfnMember.NetworkConfigurationProperty.NetworkFrameworkConfiguration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html#cfn-managedblockchain-member-networkconfiguration-networkframeworkconfiguration
         */
        readonly networkFrameworkConfiguration?: CfnMember.NetworkFrameworkConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnMember.NetworkConfigurationProperty.VotingPolicy`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkconfiguration.html#cfn-managedblockchain-member-networkconfiguration-votingpolicy
         */
        readonly votingPolicy: CfnMember.VotingPolicyProperty | cdk.IResolvable;
    }
}
export declare namespace CfnMember {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkfabricconfiguration.html
     */
    interface NetworkFabricConfigurationProperty {
        /**
         * `CfnMember.NetworkFabricConfigurationProperty.Edition`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkfabricconfiguration.html#cfn-managedblockchain-member-networkfabricconfiguration-edition
         */
        readonly edition: string;
    }
}
export declare namespace CfnMember {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkframeworkconfiguration.html
     */
    interface NetworkFrameworkConfigurationProperty {
        /**
         * `CfnMember.NetworkFrameworkConfigurationProperty.NetworkFabricConfiguration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-networkframeworkconfiguration.html#cfn-managedblockchain-member-networkframeworkconfiguration-networkfabricconfiguration
         */
        readonly networkFabricConfiguration?: CfnMember.NetworkFabricConfigurationProperty | cdk.IResolvable;
    }
}
export declare namespace CfnMember {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-votingpolicy.html
     */
    interface VotingPolicyProperty {
        /**
         * `CfnMember.VotingPolicyProperty.ApprovalThresholdPolicy`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-member-votingpolicy.html#cfn-managedblockchain-member-votingpolicy-approvalthresholdpolicy
         */
        readonly approvalThresholdPolicy?: CfnMember.ApprovalThresholdPolicyProperty | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::ManagedBlockchain::Node`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-node.html
 */
export interface CfnNodeProps {
    /**
     * `AWS::ManagedBlockchain::Node.MemberId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-node.html#cfn-managedblockchain-node-memberid
     */
    readonly memberId: string;
    /**
     * `AWS::ManagedBlockchain::Node.NetworkId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-node.html#cfn-managedblockchain-node-networkid
     */
    readonly networkId: string;
    /**
     * `AWS::ManagedBlockchain::Node.NodeConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-node.html#cfn-managedblockchain-node-nodeconfiguration
     */
    readonly nodeConfiguration: CfnNode.NodeConfigurationProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::ManagedBlockchain::Node`
 *
 * @cloudformationResource AWS::ManagedBlockchain::Node
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-node.html
 */
export declare class CfnNode extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ManagedBlockchain::Node";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute MemberId
     */
    readonly attrMemberId: string;
    /**
     * @cloudformationAttribute NetworkId
     */
    readonly attrNetworkId: string;
    /**
     * @cloudformationAttribute NodeId
     */
    readonly attrNodeId: string;
    /**
     * `AWS::ManagedBlockchain::Node.MemberId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-node.html#cfn-managedblockchain-node-memberid
     */
    memberId: string;
    /**
     * `AWS::ManagedBlockchain::Node.NetworkId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-node.html#cfn-managedblockchain-node-networkid
     */
    networkId: string;
    /**
     * `AWS::ManagedBlockchain::Node.NodeConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-managedblockchain-node.html#cfn-managedblockchain-node-nodeconfiguration
     */
    nodeConfiguration: CfnNode.NodeConfigurationProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::ManagedBlockchain::Node`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNodeProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnNode {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-node-nodeconfiguration.html
     */
    interface NodeConfigurationProperty {
        /**
         * `CfnNode.NodeConfigurationProperty.AvailabilityZone`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-node-nodeconfiguration.html#cfn-managedblockchain-node-nodeconfiguration-availabilityzone
         */
        readonly availabilityZone: string;
        /**
         * `CfnNode.NodeConfigurationProperty.InstanceType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-managedblockchain-node-nodeconfiguration.html#cfn-managedblockchain-node-nodeconfiguration-instancetype
         */
        readonly instanceType: string;
    }
}
