import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::OpsWorks::App`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html
 */
export interface CfnAppProps {
    /**
     * `AWS::OpsWorks::App.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-name
     */
    readonly name: string;
    /**
     * `AWS::OpsWorks::App.StackId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-stackid
     */
    readonly stackId: string;
    /**
     * `AWS::OpsWorks::App.Type`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-type
     */
    readonly type: string;
    /**
     * `AWS::OpsWorks::App.AppSource`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-appsource
     */
    readonly appSource?: CfnApp.SourceProperty | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::App.Attributes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-attributes
     */
    readonly attributes?: {
        [key: string]: (string);
    } | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::App.DataSources`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-datasources
     */
    readonly dataSources?: Array<CfnApp.DataSourceProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::App.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-description
     */
    readonly description?: string;
    /**
     * `AWS::OpsWorks::App.Domains`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-domains
     */
    readonly domains?: string[];
    /**
     * `AWS::OpsWorks::App.EnableSsl`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-enablessl
     */
    readonly enableSsl?: boolean | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::App.Environment`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-environment
     */
    readonly environment?: Array<CfnApp.EnvironmentVariableProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::App.Shortname`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-shortname
     */
    readonly shortname?: string;
    /**
     * `AWS::OpsWorks::App.SslConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-sslconfiguration
     */
    readonly sslConfiguration?: CfnApp.SslConfigurationProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::OpsWorks::App`
 *
 * @cloudformationResource AWS::OpsWorks::App
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html
 */
export declare class CfnApp extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::OpsWorks::App";
    /**
     * `AWS::OpsWorks::App.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-name
     */
    name: string;
    /**
     * `AWS::OpsWorks::App.StackId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-stackid
     */
    stackId: string;
    /**
     * `AWS::OpsWorks::App.Type`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-type
     */
    type: string;
    /**
     * `AWS::OpsWorks::App.AppSource`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-appsource
     */
    appSource: CfnApp.SourceProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::App.Attributes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-attributes
     */
    attributes: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::App.DataSources`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-datasources
     */
    dataSources: Array<CfnApp.DataSourceProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::App.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-description
     */
    description: string | undefined;
    /**
     * `AWS::OpsWorks::App.Domains`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-domains
     */
    domains: string[] | undefined;
    /**
     * `AWS::OpsWorks::App.EnableSsl`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-enablessl
     */
    enableSsl: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::App.Environment`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-environment
     */
    environment: Array<CfnApp.EnvironmentVariableProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::App.Shortname`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-shortname
     */
    shortname: string | undefined;
    /**
     * `AWS::OpsWorks::App.SslConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-app.html#cfn-opsworks-app-sslconfiguration
     */
    sslConfiguration: CfnApp.SslConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::OpsWorks::App`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAppProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnApp {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-app-datasource.html
     */
    interface DataSourceProperty {
        /**
         * `CfnApp.DataSourceProperty.Arn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-app-datasource.html#cfn-opsworks-app-datasource-arn
         */
        readonly arn?: string;
        /**
         * `CfnApp.DataSourceProperty.DatabaseName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-app-datasource.html#cfn-opsworks-app-datasource-databasename
         */
        readonly databaseName?: string;
        /**
         * `CfnApp.DataSourceProperty.Type`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-app-datasource.html#cfn-opsworks-app-datasource-type
         */
        readonly type?: string;
    }
}
export declare namespace CfnApp {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-app-environment.html
     */
    interface EnvironmentVariableProperty {
        /**
         * `CfnApp.EnvironmentVariableProperty.Key`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-app-environment.html#cfn-opsworks-app-environment-key
         */
        readonly key: string;
        /**
         * `CfnApp.EnvironmentVariableProperty.Secure`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-app-environment.html#cfn-opsworks-app-environment-secure
         */
        readonly secure?: boolean | cdk.IResolvable;
        /**
         * `CfnApp.EnvironmentVariableProperty.Value`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-app-environment.html#value
         */
        readonly value: string;
    }
}
export declare namespace CfnApp {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html
     */
    interface SourceProperty {
        /**
         * `CfnApp.SourceProperty.Password`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html#cfn-opsworks-custcookbooksource-pw
         */
        readonly password?: string;
        /**
         * `CfnApp.SourceProperty.Revision`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html#cfn-opsworks-custcookbooksource-revision
         */
        readonly revision?: string;
        /**
         * `CfnApp.SourceProperty.SshKey`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html#cfn-opsworks-custcookbooksource-sshkey
         */
        readonly sshKey?: string;
        /**
         * `CfnApp.SourceProperty.Type`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html#cfn-opsworks-custcookbooksource-type
         */
        readonly type?: string;
        /**
         * `CfnApp.SourceProperty.Url`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html#cfn-opsworks-custcookbooksource-url
         */
        readonly url?: string;
        /**
         * `CfnApp.SourceProperty.Username`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html#cfn-opsworks-custcookbooksource-username
         */
        readonly username?: string;
    }
}
export declare namespace CfnApp {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-app-sslconfiguration.html
     */
    interface SslConfigurationProperty {
        /**
         * `CfnApp.SslConfigurationProperty.Certificate`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-app-sslconfiguration.html#cfn-opsworks-app-sslconfig-certificate
         */
        readonly certificate?: string;
        /**
         * `CfnApp.SslConfigurationProperty.Chain`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-app-sslconfiguration.html#cfn-opsworks-app-sslconfig-chain
         */
        readonly chain?: string;
        /**
         * `CfnApp.SslConfigurationProperty.PrivateKey`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-app-sslconfiguration.html#cfn-opsworks-app-sslconfig-privatekey
         */
        readonly privateKey?: string;
    }
}
/**
 * Properties for defining a `AWS::OpsWorks::ElasticLoadBalancerAttachment`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-elbattachment.html
 */
export interface CfnElasticLoadBalancerAttachmentProps {
    /**
     * `AWS::OpsWorks::ElasticLoadBalancerAttachment.ElasticLoadBalancerName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-elbattachment.html#cfn-opsworks-elbattachment-elbname
     */
    readonly elasticLoadBalancerName: string;
    /**
     * `AWS::OpsWorks::ElasticLoadBalancerAttachment.LayerId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-elbattachment.html#cfn-opsworks-elbattachment-layerid
     */
    readonly layerId: string;
}
/**
 * A CloudFormation `AWS::OpsWorks::ElasticLoadBalancerAttachment`
 *
 * @cloudformationResource AWS::OpsWorks::ElasticLoadBalancerAttachment
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-elbattachment.html
 */
export declare class CfnElasticLoadBalancerAttachment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::OpsWorks::ElasticLoadBalancerAttachment";
    /**
     * `AWS::OpsWorks::ElasticLoadBalancerAttachment.ElasticLoadBalancerName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-elbattachment.html#cfn-opsworks-elbattachment-elbname
     */
    elasticLoadBalancerName: string;
    /**
     * `AWS::OpsWorks::ElasticLoadBalancerAttachment.LayerId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-elbattachment.html#cfn-opsworks-elbattachment-layerid
     */
    layerId: string;
    /**
     * Create a new `AWS::OpsWorks::ElasticLoadBalancerAttachment`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnElasticLoadBalancerAttachmentProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::OpsWorks::Instance`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html
 */
export interface CfnInstanceProps {
    /**
     * `AWS::OpsWorks::Instance.InstanceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-instancetype
     */
    readonly instanceType: string;
    /**
     * `AWS::OpsWorks::Instance.LayerIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-layerids
     */
    readonly layerIds: string[];
    /**
     * `AWS::OpsWorks::Instance.StackId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-stackid
     */
    readonly stackId: string;
    /**
     * `AWS::OpsWorks::Instance.AgentVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-agentversion
     */
    readonly agentVersion?: string;
    /**
     * `AWS::OpsWorks::Instance.AmiId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-amiid
     */
    readonly amiId?: string;
    /**
     * `AWS::OpsWorks::Instance.Architecture`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-architecture
     */
    readonly architecture?: string;
    /**
     * `AWS::OpsWorks::Instance.AutoScalingType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-autoscalingtype
     */
    readonly autoScalingType?: string;
    /**
     * `AWS::OpsWorks::Instance.AvailabilityZone`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-availabilityzone
     */
    readonly availabilityZone?: string;
    /**
     * `AWS::OpsWorks::Instance.BlockDeviceMappings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-blockdevicemappings
     */
    readonly blockDeviceMappings?: Array<CfnInstance.BlockDeviceMappingProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Instance.EbsOptimized`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-ebsoptimized
     */
    readonly ebsOptimized?: boolean | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Instance.ElasticIps`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-elasticips
     */
    readonly elasticIps?: string[];
    /**
     * `AWS::OpsWorks::Instance.Hostname`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-hostname
     */
    readonly hostname?: string;
    /**
     * `AWS::OpsWorks::Instance.InstallUpdatesOnBoot`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-installupdatesonboot
     */
    readonly installUpdatesOnBoot?: boolean | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Instance.Os`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-os
     */
    readonly os?: string;
    /**
     * `AWS::OpsWorks::Instance.RootDeviceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-rootdevicetype
     */
    readonly rootDeviceType?: string;
    /**
     * `AWS::OpsWorks::Instance.SshKeyName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-sshkeyname
     */
    readonly sshKeyName?: string;
    /**
     * `AWS::OpsWorks::Instance.SubnetId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-subnetid
     */
    readonly subnetId?: string;
    /**
     * `AWS::OpsWorks::Instance.Tenancy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-tenancy
     */
    readonly tenancy?: string;
    /**
     * `AWS::OpsWorks::Instance.TimeBasedAutoScaling`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-timebasedautoscaling
     */
    readonly timeBasedAutoScaling?: CfnInstance.TimeBasedAutoScalingProperty | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Instance.VirtualizationType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-virtualizationtype
     */
    readonly virtualizationType?: string;
    /**
     * `AWS::OpsWorks::Instance.Volumes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-volumes
     */
    readonly volumes?: string[];
}
/**
 * A CloudFormation `AWS::OpsWorks::Instance`
 *
 * @cloudformationResource AWS::OpsWorks::Instance
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html
 */
export declare class CfnInstance extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::OpsWorks::Instance";
    /**
     * @cloudformationAttribute AvailabilityZone
     */
    readonly attrAvailabilityZone: string;
    /**
     * @cloudformationAttribute PrivateDnsName
     */
    readonly attrPrivateDnsName: string;
    /**
     * @cloudformationAttribute PrivateIp
     */
    readonly attrPrivateIp: string;
    /**
     * @cloudformationAttribute PublicDnsName
     */
    readonly attrPublicDnsName: string;
    /**
     * @cloudformationAttribute PublicIp
     */
    readonly attrPublicIp: string;
    /**
     * `AWS::OpsWorks::Instance.InstanceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-instancetype
     */
    instanceType: string;
    /**
     * `AWS::OpsWorks::Instance.LayerIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-layerids
     */
    layerIds: string[];
    /**
     * `AWS::OpsWorks::Instance.StackId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-stackid
     */
    stackId: string;
    /**
     * `AWS::OpsWorks::Instance.AgentVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-agentversion
     */
    agentVersion: string | undefined;
    /**
     * `AWS::OpsWorks::Instance.AmiId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-amiid
     */
    amiId: string | undefined;
    /**
     * `AWS::OpsWorks::Instance.Architecture`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-architecture
     */
    architecture: string | undefined;
    /**
     * `AWS::OpsWorks::Instance.AutoScalingType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-autoscalingtype
     */
    autoScalingType: string | undefined;
    /**
     * `AWS::OpsWorks::Instance.AvailabilityZone`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-availabilityzone
     */
    availabilityZone: string | undefined;
    /**
     * `AWS::OpsWorks::Instance.BlockDeviceMappings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-blockdevicemappings
     */
    blockDeviceMappings: Array<CfnInstance.BlockDeviceMappingProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Instance.EbsOptimized`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-ebsoptimized
     */
    ebsOptimized: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Instance.ElasticIps`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-elasticips
     */
    elasticIps: string[] | undefined;
    /**
     * `AWS::OpsWorks::Instance.Hostname`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-hostname
     */
    hostname: string | undefined;
    /**
     * `AWS::OpsWorks::Instance.InstallUpdatesOnBoot`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-installupdatesonboot
     */
    installUpdatesOnBoot: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Instance.Os`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-os
     */
    os: string | undefined;
    /**
     * `AWS::OpsWorks::Instance.RootDeviceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-rootdevicetype
     */
    rootDeviceType: string | undefined;
    /**
     * `AWS::OpsWorks::Instance.SshKeyName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-sshkeyname
     */
    sshKeyName: string | undefined;
    /**
     * `AWS::OpsWorks::Instance.SubnetId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-subnetid
     */
    subnetId: string | undefined;
    /**
     * `AWS::OpsWorks::Instance.Tenancy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-tenancy
     */
    tenancy: string | undefined;
    /**
     * `AWS::OpsWorks::Instance.TimeBasedAutoScaling`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-timebasedautoscaling
     */
    timeBasedAutoScaling: CfnInstance.TimeBasedAutoScalingProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Instance.VirtualizationType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-virtualizationtype
     */
    virtualizationType: string | undefined;
    /**
     * `AWS::OpsWorks::Instance.Volumes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-instance.html#cfn-opsworks-instance-volumes
     */
    volumes: string[] | undefined;
    /**
     * Create a new `AWS::OpsWorks::Instance`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnInstanceProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnInstance {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-blockdevicemapping.html
     */
    interface BlockDeviceMappingProperty {
        /**
         * `CfnInstance.BlockDeviceMappingProperty.DeviceName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-blockdevicemapping.html#cfn-opsworks-instance-blockdevicemapping-devicename
         */
        readonly deviceName?: string;
        /**
         * `CfnInstance.BlockDeviceMappingProperty.Ebs`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-blockdevicemapping.html#cfn-opsworks-instance-blockdevicemapping-ebs
         */
        readonly ebs?: CfnInstance.EbsBlockDeviceProperty | cdk.IResolvable;
        /**
         * `CfnInstance.BlockDeviceMappingProperty.NoDevice`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-blockdevicemapping.html#cfn-opsworks-instance-blockdevicemapping-nodevice
         */
        readonly noDevice?: string;
        /**
         * `CfnInstance.BlockDeviceMappingProperty.VirtualName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-blockdevicemapping.html#cfn-opsworks-instance-blockdevicemapping-virtualname
         */
        readonly virtualName?: string;
    }
}
export declare namespace CfnInstance {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-ebsblockdevice.html
     */
    interface EbsBlockDeviceProperty {
        /**
         * `CfnInstance.EbsBlockDeviceProperty.DeleteOnTermination`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-ebsblockdevice.html#cfn-opsworks-instance-ebsblockdevice-deleteontermination
         */
        readonly deleteOnTermination?: boolean | cdk.IResolvable;
        /**
         * `CfnInstance.EbsBlockDeviceProperty.Iops`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-ebsblockdevice.html#cfn-opsworks-instance-ebsblockdevice-iops
         */
        readonly iops?: number;
        /**
         * `CfnInstance.EbsBlockDeviceProperty.SnapshotId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-ebsblockdevice.html#cfn-opsworks-instance-ebsblockdevice-snapshotid
         */
        readonly snapshotId?: string;
        /**
         * `CfnInstance.EbsBlockDeviceProperty.VolumeSize`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-ebsblockdevice.html#cfn-opsworks-instance-ebsblockdevice-volumesize
         */
        readonly volumeSize?: number;
        /**
         * `CfnInstance.EbsBlockDeviceProperty.VolumeType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-ebsblockdevice.html#cfn-opsworks-instance-ebsblockdevice-volumetype
         */
        readonly volumeType?: string;
    }
}
export declare namespace CfnInstance {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-timebasedautoscaling.html
     */
    interface TimeBasedAutoScalingProperty {
        /**
         * `CfnInstance.TimeBasedAutoScalingProperty.Friday`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-timebasedautoscaling.html#cfn-opsworks-instance-timebasedautoscaling-friday
         */
        readonly friday?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnInstance.TimeBasedAutoScalingProperty.Monday`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-timebasedautoscaling.html#cfn-opsworks-instance-timebasedautoscaling-monday
         */
        readonly monday?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnInstance.TimeBasedAutoScalingProperty.Saturday`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-timebasedautoscaling.html#cfn-opsworks-instance-timebasedautoscaling-saturday
         */
        readonly saturday?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnInstance.TimeBasedAutoScalingProperty.Sunday`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-timebasedautoscaling.html#cfn-opsworks-instance-timebasedautoscaling-sunday
         */
        readonly sunday?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnInstance.TimeBasedAutoScalingProperty.Thursday`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-timebasedautoscaling.html#cfn-opsworks-instance-timebasedautoscaling-thursday
         */
        readonly thursday?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnInstance.TimeBasedAutoScalingProperty.Tuesday`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-timebasedautoscaling.html#cfn-opsworks-instance-timebasedautoscaling-tuesday
         */
        readonly tuesday?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnInstance.TimeBasedAutoScalingProperty.Wednesday`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-instance-timebasedautoscaling.html#cfn-opsworks-instance-timebasedautoscaling-wednesday
         */
        readonly wednesday?: {
            [key: string]: (string);
        } | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::OpsWorks::Layer`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html
 */
export interface CfnLayerProps {
    /**
     * `AWS::OpsWorks::Layer.AutoAssignElasticIps`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-autoassignelasticips
     */
    readonly autoAssignElasticIps: boolean | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Layer.AutoAssignPublicIps`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-autoassignpublicips
     */
    readonly autoAssignPublicIps: boolean | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Layer.EnableAutoHealing`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-enableautohealing
     */
    readonly enableAutoHealing: boolean | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Layer.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-name
     */
    readonly name: string;
    /**
     * `AWS::OpsWorks::Layer.Shortname`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-shortname
     */
    readonly shortname: string;
    /**
     * `AWS::OpsWorks::Layer.StackId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-stackid
     */
    readonly stackId: string;
    /**
     * `AWS::OpsWorks::Layer.Type`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-type
     */
    readonly type: string;
    /**
     * `AWS::OpsWorks::Layer.Attributes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-attributes
     */
    readonly attributes?: {
        [key: string]: (string);
    } | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Layer.CustomInstanceProfileArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-custominstanceprofilearn
     */
    readonly customInstanceProfileArn?: string;
    /**
     * `AWS::OpsWorks::Layer.CustomJson`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-customjson
     */
    readonly customJson?: any | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Layer.CustomRecipes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-customrecipes
     */
    readonly customRecipes?: CfnLayer.RecipesProperty | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Layer.CustomSecurityGroupIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-customsecuritygroupids
     */
    readonly customSecurityGroupIds?: string[];
    /**
     * `AWS::OpsWorks::Layer.InstallUpdatesOnBoot`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-installupdatesonboot
     */
    readonly installUpdatesOnBoot?: boolean | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Layer.LifecycleEventConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-lifecycleeventconfiguration
     */
    readonly lifecycleEventConfiguration?: CfnLayer.LifecycleEventConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Layer.LoadBasedAutoScaling`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-loadbasedautoscaling
     */
    readonly loadBasedAutoScaling?: CfnLayer.LoadBasedAutoScalingProperty | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Layer.Packages`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-packages
     */
    readonly packages?: string[];
    /**
     * `AWS::OpsWorks::Layer.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::OpsWorks::Layer.UseEbsOptimizedInstances`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-useebsoptimizedinstances
     */
    readonly useEbsOptimizedInstances?: boolean | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Layer.VolumeConfigurations`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-volumeconfigurations
     */
    readonly volumeConfigurations?: Array<CfnLayer.VolumeConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::OpsWorks::Layer`
 *
 * @cloudformationResource AWS::OpsWorks::Layer
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html
 */
export declare class CfnLayer extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::OpsWorks::Layer";
    /**
     * `AWS::OpsWorks::Layer.AutoAssignElasticIps`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-autoassignelasticips
     */
    autoAssignElasticIps: boolean | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Layer.AutoAssignPublicIps`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-autoassignpublicips
     */
    autoAssignPublicIps: boolean | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Layer.EnableAutoHealing`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-enableautohealing
     */
    enableAutoHealing: boolean | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Layer.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-name
     */
    name: string;
    /**
     * `AWS::OpsWorks::Layer.Shortname`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-shortname
     */
    shortname: string;
    /**
     * `AWS::OpsWorks::Layer.StackId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-stackid
     */
    stackId: string;
    /**
     * `AWS::OpsWorks::Layer.Type`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-type
     */
    type: string;
    /**
     * `AWS::OpsWorks::Layer.Attributes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-attributes
     */
    attributes: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Layer.CustomInstanceProfileArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-custominstanceprofilearn
     */
    customInstanceProfileArn: string | undefined;
    /**
     * `AWS::OpsWorks::Layer.CustomJson`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-customjson
     */
    customJson: any | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Layer.CustomRecipes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-customrecipes
     */
    customRecipes: CfnLayer.RecipesProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Layer.CustomSecurityGroupIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-customsecuritygroupids
     */
    customSecurityGroupIds: string[] | undefined;
    /**
     * `AWS::OpsWorks::Layer.InstallUpdatesOnBoot`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-installupdatesonboot
     */
    installUpdatesOnBoot: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Layer.LifecycleEventConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-lifecycleeventconfiguration
     */
    lifecycleEventConfiguration: CfnLayer.LifecycleEventConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Layer.LoadBasedAutoScaling`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-loadbasedautoscaling
     */
    loadBasedAutoScaling: CfnLayer.LoadBasedAutoScalingProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Layer.Packages`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-packages
     */
    packages: string[] | undefined;
    /**
     * `AWS::OpsWorks::Layer.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::OpsWorks::Layer.UseEbsOptimizedInstances`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-useebsoptimizedinstances
     */
    useEbsOptimizedInstances: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Layer.VolumeConfigurations`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-layer.html#cfn-opsworks-layer-volumeconfigurations
     */
    volumeConfigurations: Array<CfnLayer.VolumeConfigurationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::OpsWorks::Layer`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLayerProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnLayer {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-loadbasedautoscaling-autoscalingthresholds.html
     */
    interface AutoScalingThresholdsProperty {
        /**
         * `CfnLayer.AutoScalingThresholdsProperty.CpuThreshold`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-loadbasedautoscaling-autoscalingthresholds.html#cfn-opsworks-layer-loadbasedautoscaling-autoscalingthresholds-cputhreshold
         */
        readonly cpuThreshold?: number;
        /**
         * `CfnLayer.AutoScalingThresholdsProperty.IgnoreMetricsTime`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-loadbasedautoscaling-autoscalingthresholds.html#cfn-opsworks-layer-loadbasedautoscaling-autoscalingthresholds-ignoremetricstime
         */
        readonly ignoreMetricsTime?: number;
        /**
         * `CfnLayer.AutoScalingThresholdsProperty.InstanceCount`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-loadbasedautoscaling-autoscalingthresholds.html#cfn-opsworks-layer-loadbasedautoscaling-autoscalingthresholds-instancecount
         */
        readonly instanceCount?: number;
        /**
         * `CfnLayer.AutoScalingThresholdsProperty.LoadThreshold`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-loadbasedautoscaling-autoscalingthresholds.html#cfn-opsworks-layer-loadbasedautoscaling-autoscalingthresholds-loadthreshold
         */
        readonly loadThreshold?: number;
        /**
         * `CfnLayer.AutoScalingThresholdsProperty.MemoryThreshold`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-loadbasedautoscaling-autoscalingthresholds.html#cfn-opsworks-layer-loadbasedautoscaling-autoscalingthresholds-memorythreshold
         */
        readonly memoryThreshold?: number;
        /**
         * `CfnLayer.AutoScalingThresholdsProperty.ThresholdsWaitTime`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-loadbasedautoscaling-autoscalingthresholds.html#cfn-opsworks-layer-loadbasedautoscaling-autoscalingthresholds-thresholdwaittime
         */
        readonly thresholdsWaitTime?: number;
    }
}
export declare namespace CfnLayer {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-lifecycleeventconfiguration.html
     */
    interface LifecycleEventConfigurationProperty {
        /**
         * `CfnLayer.LifecycleEventConfigurationProperty.ShutdownEventConfiguration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-lifecycleeventconfiguration.html#cfn-opsworks-layer-lifecycleconfiguration-shutdowneventconfiguration
         */
        readonly shutdownEventConfiguration?: CfnLayer.ShutdownEventConfigurationProperty | cdk.IResolvable;
    }
}
export declare namespace CfnLayer {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-loadbasedautoscaling.html
     */
    interface LoadBasedAutoScalingProperty {
        /**
         * `CfnLayer.LoadBasedAutoScalingProperty.DownScaling`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-loadbasedautoscaling.html#cfn-opsworks-layer-loadbasedautoscaling-downscaling
         */
        readonly downScaling?: CfnLayer.AutoScalingThresholdsProperty | cdk.IResolvable;
        /**
         * `CfnLayer.LoadBasedAutoScalingProperty.Enable`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-loadbasedautoscaling.html#cfn-opsworks-layer-loadbasedautoscaling-enable
         */
        readonly enable?: boolean | cdk.IResolvable;
        /**
         * `CfnLayer.LoadBasedAutoScalingProperty.UpScaling`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-loadbasedautoscaling.html#cfn-opsworks-layer-loadbasedautoscaling-upscaling
         */
        readonly upScaling?: CfnLayer.AutoScalingThresholdsProperty | cdk.IResolvable;
    }
}
export declare namespace CfnLayer {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-recipes.html
     */
    interface RecipesProperty {
        /**
         * `CfnLayer.RecipesProperty.Configure`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-recipes.html#cfn-opsworks-layer-customrecipes-configure
         */
        readonly configure?: string[];
        /**
         * `CfnLayer.RecipesProperty.Deploy`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-recipes.html#cfn-opsworks-layer-customrecipes-deploy
         */
        readonly deploy?: string[];
        /**
         * `CfnLayer.RecipesProperty.Setup`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-recipes.html#cfn-opsworks-layer-customrecipes-setup
         */
        readonly setup?: string[];
        /**
         * `CfnLayer.RecipesProperty.Shutdown`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-recipes.html#cfn-opsworks-layer-customrecipes-shutdown
         */
        readonly shutdown?: string[];
        /**
         * `CfnLayer.RecipesProperty.Undeploy`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-recipes.html#cfn-opsworks-layer-customrecipes-undeploy
         */
        readonly undeploy?: string[];
    }
}
export declare namespace CfnLayer {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-lifecycleeventconfiguration-shutdowneventconfiguration.html
     */
    interface ShutdownEventConfigurationProperty {
        /**
         * `CfnLayer.ShutdownEventConfigurationProperty.DelayUntilElbConnectionsDrained`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-lifecycleeventconfiguration-shutdowneventconfiguration.html#cfn-opsworks-layer-lifecycleconfiguration-shutdowneventconfiguration-delayuntilelbconnectionsdrained
         */
        readonly delayUntilElbConnectionsDrained?: boolean | cdk.IResolvable;
        /**
         * `CfnLayer.ShutdownEventConfigurationProperty.ExecutionTimeout`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-lifecycleeventconfiguration-shutdowneventconfiguration.html#cfn-opsworks-layer-lifecycleconfiguration-shutdowneventconfiguration-executiontimeout
         */
        readonly executionTimeout?: number;
    }
}
export declare namespace CfnLayer {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-volumeconfiguration.html
     */
    interface VolumeConfigurationProperty {
        /**
         * `CfnLayer.VolumeConfigurationProperty.Encrypted`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-volumeconfiguration.html#cfn-opsworks-layer-volumeconfiguration-encrypted
         */
        readonly encrypted?: boolean | cdk.IResolvable;
        /**
         * `CfnLayer.VolumeConfigurationProperty.Iops`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-volumeconfiguration.html#cfn-opsworks-layer-volconfig-iops
         */
        readonly iops?: number;
        /**
         * `CfnLayer.VolumeConfigurationProperty.MountPoint`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-volumeconfiguration.html#cfn-opsworks-layer-volconfig-mountpoint
         */
        readonly mountPoint?: string;
        /**
         * `CfnLayer.VolumeConfigurationProperty.NumberOfDisks`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-volumeconfiguration.html#cfn-opsworks-layer-volconfig-numberofdisks
         */
        readonly numberOfDisks?: number;
        /**
         * `CfnLayer.VolumeConfigurationProperty.RaidLevel`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-volumeconfiguration.html#cfn-opsworks-layer-volconfig-raidlevel
         */
        readonly raidLevel?: number;
        /**
         * `CfnLayer.VolumeConfigurationProperty.Size`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-volumeconfiguration.html#cfn-opsworks-layer-volconfig-size
         */
        readonly size?: number;
        /**
         * `CfnLayer.VolumeConfigurationProperty.VolumeType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-layer-volumeconfiguration.html#cfn-opsworks-layer-volconfig-volumetype
         */
        readonly volumeType?: string;
    }
}
/**
 * Properties for defining a `AWS::OpsWorks::Stack`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html
 */
export interface CfnStackProps {
    /**
     * `AWS::OpsWorks::Stack.DefaultInstanceProfileArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultinstanceprof
     */
    readonly defaultInstanceProfileArn: string;
    /**
     * `AWS::OpsWorks::Stack.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-name
     */
    readonly name: string;
    /**
     * `AWS::OpsWorks::Stack.ServiceRoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-servicerolearn
     */
    readonly serviceRoleArn: string;
    /**
     * `AWS::OpsWorks::Stack.AgentVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-agentversion
     */
    readonly agentVersion?: string;
    /**
     * `AWS::OpsWorks::Stack.Attributes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-attributes
     */
    readonly attributes?: {
        [key: string]: (string);
    } | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Stack.ChefConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-chefconfiguration
     */
    readonly chefConfiguration?: CfnStack.ChefConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Stack.CloneAppIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-cloneappids
     */
    readonly cloneAppIds?: string[];
    /**
     * `AWS::OpsWorks::Stack.ClonePermissions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-clonepermissions
     */
    readonly clonePermissions?: boolean | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Stack.ConfigurationManager`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-configmanager
     */
    readonly configurationManager?: CfnStack.StackConfigurationManagerProperty | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Stack.CustomCookbooksSource`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-custcookbooksource
     */
    readonly customCookbooksSource?: CfnStack.SourceProperty | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Stack.CustomJson`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-custjson
     */
    readonly customJson?: any | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Stack.DefaultAvailabilityZone`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultaz
     */
    readonly defaultAvailabilityZone?: string;
    /**
     * `AWS::OpsWorks::Stack.DefaultOs`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultos
     */
    readonly defaultOs?: string;
    /**
     * `AWS::OpsWorks::Stack.DefaultRootDeviceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultrootdevicetype
     */
    readonly defaultRootDeviceType?: string;
    /**
     * `AWS::OpsWorks::Stack.DefaultSshKeyName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultsshkeyname
     */
    readonly defaultSshKeyName?: string;
    /**
     * `AWS::OpsWorks::Stack.DefaultSubnetId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#defaultsubnet
     */
    readonly defaultSubnetId?: string;
    /**
     * `AWS::OpsWorks::Stack.EcsClusterArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-ecsclusterarn
     */
    readonly ecsClusterArn?: string;
    /**
     * `AWS::OpsWorks::Stack.ElasticIps`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-elasticips
     */
    readonly elasticIps?: Array<CfnStack.ElasticIpProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Stack.HostnameTheme`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-hostnametheme
     */
    readonly hostnameTheme?: string;
    /**
     * `AWS::OpsWorks::Stack.RdsDbInstances`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-rdsdbinstances
     */
    readonly rdsDbInstances?: Array<CfnStack.RdsDbInstanceProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Stack.SourceStackId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-sourcestackid
     */
    readonly sourceStackId?: string;
    /**
     * `AWS::OpsWorks::Stack.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::OpsWorks::Stack.UseCustomCookbooks`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#usecustcookbooks
     */
    readonly useCustomCookbooks?: boolean | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Stack.UseOpsworksSecurityGroups`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-useopsworkssecuritygroups
     */
    readonly useOpsworksSecurityGroups?: boolean | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::Stack.VpcId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-vpcid
     */
    readonly vpcId?: string;
}
/**
 * A CloudFormation `AWS::OpsWorks::Stack`
 *
 * @cloudformationResource AWS::OpsWorks::Stack
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html
 */
export declare class CfnStack extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::OpsWorks::Stack";
    /**
     * `AWS::OpsWorks::Stack.DefaultInstanceProfileArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultinstanceprof
     */
    defaultInstanceProfileArn: string;
    /**
     * `AWS::OpsWorks::Stack.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-name
     */
    name: string;
    /**
     * `AWS::OpsWorks::Stack.ServiceRoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-servicerolearn
     */
    serviceRoleArn: string;
    /**
     * `AWS::OpsWorks::Stack.AgentVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-agentversion
     */
    agentVersion: string | undefined;
    /**
     * `AWS::OpsWorks::Stack.Attributes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-attributes
     */
    attributes: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Stack.ChefConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-chefconfiguration
     */
    chefConfiguration: CfnStack.ChefConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Stack.CloneAppIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-cloneappids
     */
    cloneAppIds: string[] | undefined;
    /**
     * `AWS::OpsWorks::Stack.ClonePermissions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-clonepermissions
     */
    clonePermissions: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Stack.ConfigurationManager`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-configmanager
     */
    configurationManager: CfnStack.StackConfigurationManagerProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Stack.CustomCookbooksSource`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-custcookbooksource
     */
    customCookbooksSource: CfnStack.SourceProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Stack.CustomJson`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-custjson
     */
    customJson: any | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Stack.DefaultAvailabilityZone`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultaz
     */
    defaultAvailabilityZone: string | undefined;
    /**
     * `AWS::OpsWorks::Stack.DefaultOs`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultos
     */
    defaultOs: string | undefined;
    /**
     * `AWS::OpsWorks::Stack.DefaultRootDeviceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultrootdevicetype
     */
    defaultRootDeviceType: string | undefined;
    /**
     * `AWS::OpsWorks::Stack.DefaultSshKeyName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultsshkeyname
     */
    defaultSshKeyName: string | undefined;
    /**
     * `AWS::OpsWorks::Stack.DefaultSubnetId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#defaultsubnet
     */
    defaultSubnetId: string | undefined;
    /**
     * `AWS::OpsWorks::Stack.EcsClusterArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-ecsclusterarn
     */
    ecsClusterArn: string | undefined;
    /**
     * `AWS::OpsWorks::Stack.ElasticIps`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-elasticips
     */
    elasticIps: Array<CfnStack.ElasticIpProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Stack.HostnameTheme`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-hostnametheme
     */
    hostnameTheme: string | undefined;
    /**
     * `AWS::OpsWorks::Stack.RdsDbInstances`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-rdsdbinstances
     */
    rdsDbInstances: Array<CfnStack.RdsDbInstanceProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Stack.SourceStackId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-sourcestackid
     */
    sourceStackId: string | undefined;
    /**
     * `AWS::OpsWorks::Stack.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::OpsWorks::Stack.UseCustomCookbooks`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#usecustcookbooks
     */
    useCustomCookbooks: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Stack.UseOpsworksSecurityGroups`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-useopsworkssecuritygroups
     */
    useOpsworksSecurityGroups: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::Stack.VpcId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-vpcid
     */
    vpcId: string | undefined;
    /**
     * Create a new `AWS::OpsWorks::Stack`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnStackProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnStack {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-chefconfiguration.html
     */
    interface ChefConfigurationProperty {
        /**
         * `CfnStack.ChefConfigurationProperty.BerkshelfVersion`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-chefconfiguration.html#cfn-opsworks-chefconfiguration-berkshelfversion
         */
        readonly berkshelfVersion?: string;
        /**
         * `CfnStack.ChefConfigurationProperty.ManageBerkshelf`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-chefconfiguration.html#cfn-opsworks-chefconfiguration-berkshelfversion
         */
        readonly manageBerkshelf?: boolean | cdk.IResolvable;
    }
}
export declare namespace CfnStack {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-elasticip.html
     */
    interface ElasticIpProperty {
        /**
         * `CfnStack.ElasticIpProperty.Ip`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-elasticip.html#cfn-opsworks-stack-elasticip-ip
         */
        readonly ip: string;
        /**
         * `CfnStack.ElasticIpProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-elasticip.html#cfn-opsworks-stack-elasticip-name
         */
        readonly name?: string;
    }
}
export declare namespace CfnStack {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-rdsdbinstance.html
     */
    interface RdsDbInstanceProperty {
        /**
         * `CfnStack.RdsDbInstanceProperty.DbPassword`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-rdsdbinstance.html#cfn-opsworks-stack-rdsdbinstance-dbpassword
         */
        readonly dbPassword: string;
        /**
         * `CfnStack.RdsDbInstanceProperty.DbUser`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-rdsdbinstance.html#cfn-opsworks-stack-rdsdbinstance-dbuser
         */
        readonly dbUser: string;
        /**
         * `CfnStack.RdsDbInstanceProperty.RdsDbInstanceArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-rdsdbinstance.html#cfn-opsworks-stack-rdsdbinstance-rdsdbinstancearn
         */
        readonly rdsDbInstanceArn: string;
    }
}
export declare namespace CfnStack {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html
     */
    interface SourceProperty {
        /**
         * `CfnStack.SourceProperty.Password`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html#cfn-opsworks-custcookbooksource-password
         */
        readonly password?: string;
        /**
         * `CfnStack.SourceProperty.Revision`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html#cfn-opsworks-custcookbooksource-revision
         */
        readonly revision?: string;
        /**
         * `CfnStack.SourceProperty.SshKey`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html#cfn-opsworks-custcookbooksource-sshkey
         */
        readonly sshKey?: string;
        /**
         * `CfnStack.SourceProperty.Type`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html#cfn-opsworks-custcookbooksource-type
         */
        readonly type?: string;
        /**
         * `CfnStack.SourceProperty.Url`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html#cfn-opsworks-custcookbooksource-url
         */
        readonly url?: string;
        /**
         * `CfnStack.SourceProperty.Username`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html#cfn-opsworks-custcookbooksource-username
         */
        readonly username?: string;
    }
}
export declare namespace CfnStack {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-stackconfigmanager.html
     */
    interface StackConfigurationManagerProperty {
        /**
         * `CfnStack.StackConfigurationManagerProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-stackconfigmanager.html#cfn-opsworks-configmanager-name
         */
        readonly name?: string;
        /**
         * `CfnStack.StackConfigurationManagerProperty.Version`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-stackconfigmanager.html#cfn-opsworks-configmanager-version
         */
        readonly version?: string;
    }
}
/**
 * Properties for defining a `AWS::OpsWorks::UserProfile`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-userprofile.html
 */
export interface CfnUserProfileProps {
    /**
     * `AWS::OpsWorks::UserProfile.IamUserArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-userprofile.html#cfn-opsworks-userprofile-iamuserarn
     */
    readonly iamUserArn: string;
    /**
     * `AWS::OpsWorks::UserProfile.AllowSelfManagement`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-userprofile.html#cfn-opsworks-userprofile-allowselfmanagement
     */
    readonly allowSelfManagement?: boolean | cdk.IResolvable;
    /**
     * `AWS::OpsWorks::UserProfile.SshPublicKey`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-userprofile.html#cfn-opsworks-userprofile-sshpublickey
     */
    readonly sshPublicKey?: string;
    /**
     * `AWS::OpsWorks::UserProfile.SshUsername`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-userprofile.html#cfn-opsworks-userprofile-sshusername
     */
    readonly sshUsername?: string;
}
/**
 * A CloudFormation `AWS::OpsWorks::UserProfile`
 *
 * @cloudformationResource AWS::OpsWorks::UserProfile
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-userprofile.html
 */
export declare class CfnUserProfile extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::OpsWorks::UserProfile";
    /**
     * @cloudformationAttribute SshUsername
     */
    readonly attrSshUsername: string;
    /**
     * `AWS::OpsWorks::UserProfile.IamUserArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-userprofile.html#cfn-opsworks-userprofile-iamuserarn
     */
    iamUserArn: string;
    /**
     * `AWS::OpsWorks::UserProfile.AllowSelfManagement`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-userprofile.html#cfn-opsworks-userprofile-allowselfmanagement
     */
    allowSelfManagement: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::OpsWorks::UserProfile.SshPublicKey`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-userprofile.html#cfn-opsworks-userprofile-sshpublickey
     */
    sshPublicKey: string | undefined;
    /**
     * `AWS::OpsWorks::UserProfile.SshUsername`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-userprofile.html#cfn-opsworks-userprofile-sshusername
     */
    sshUsername: string | undefined;
    /**
     * Create a new `AWS::OpsWorks::UserProfile`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnUserProfileProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::OpsWorks::Volume`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-volume.html
 */
export interface CfnVolumeProps {
    /**
     * `AWS::OpsWorks::Volume.Ec2VolumeId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-volume.html#cfn-opsworks-volume-ec2volumeid
     */
    readonly ec2VolumeId: string;
    /**
     * `AWS::OpsWorks::Volume.StackId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-volume.html#cfn-opsworks-volume-stackid
     */
    readonly stackId: string;
    /**
     * `AWS::OpsWorks::Volume.MountPoint`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-volume.html#cfn-opsworks-volume-mountpoint
     */
    readonly mountPoint?: string;
    /**
     * `AWS::OpsWorks::Volume.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-volume.html#cfn-opsworks-volume-name
     */
    readonly name?: string;
}
/**
 * A CloudFormation `AWS::OpsWorks::Volume`
 *
 * @cloudformationResource AWS::OpsWorks::Volume
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-volume.html
 */
export declare class CfnVolume extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::OpsWorks::Volume";
    /**
     * `AWS::OpsWorks::Volume.Ec2VolumeId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-volume.html#cfn-opsworks-volume-ec2volumeid
     */
    ec2VolumeId: string;
    /**
     * `AWS::OpsWorks::Volume.StackId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-volume.html#cfn-opsworks-volume-stackid
     */
    stackId: string;
    /**
     * `AWS::OpsWorks::Volume.MountPoint`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-volume.html#cfn-opsworks-volume-mountpoint
     */
    mountPoint: string | undefined;
    /**
     * `AWS::OpsWorks::Volume.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-volume.html#cfn-opsworks-volume-name
     */
    name: string | undefined;
    /**
     * Create a new `AWS::OpsWorks::Volume`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVolumeProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
