import * as kms from "../../aws-kms";
import * as secretsmanager from "../../aws-secretsmanager";
import { Construct } from "../../core";
/**
 * Construction properties for a DatabaseSecret.
 */
export interface DatabaseSecretProps {
    /**
     * The username.
     */
    readonly username: string;
    /**
     * The KMS key to use to encrypt the secret.
     *
     * @default default master key
     */
    readonly encryptionKey?: kms.IKey;
    /**
     * The master secret which will be used to rotate this secret.
     *
     * @default - no master secret information will be included
     */
    readonly masterSecret?: secretsmanager.ISecret;
    /**
     * Characters to not include in the generated password.
     *
     * @default " %+~`#$&*()|[]{}:;<>?!'/@\"\\"
     */
    readonly excludeCharacters?: string;
}
/**
 * A database secret.
 *
 * @resource AWS::SecretsManager::Secret
 */
export declare class DatabaseSecret extends secretsmanager.Secret {
    constructor(scope: Construct, id: string, props: DatabaseSecretProps);
}
