import * as ec2 from "../../aws-ec2";
import { Construct, IResource, RemovalPolicy, Resource } from "../../core";
/**
 * Interface for a subnet group.
 */
export interface ISubnetGroup extends IResource {
    /**
     * The name of the subnet group.
     * @attribute
     */
    readonly subnetGroupName: string;
}
/**
 * Properties for creating a SubnetGroup.
 */
export interface SubnetGroupProps {
    /**
     * Description of the subnet group.
     */
    readonly description: string;
    /**
     * The VPC to place the subnet group in.
     */
    readonly vpc: ec2.IVpc;
    /**
     * The name of the subnet group.
     *
     * @default - a name is generated
     */
    readonly subnetGroupName?: string;
    /**
     * Which subnets within the VPC to associate with this group.
     *
     * @default - private subnets
     */
    readonly vpcSubnets?: ec2.SubnetSelection;
    /**
     * The removal policy to apply when the subnet group are removed
     * from the stack or replaced during an update.
     *
     * @default RemovalPolicy.DESTROY
     */
    readonly removalPolicy?: RemovalPolicy;
}
/**
 * Class for creating a RDS DB subnet group
 *
 * @resource AWS::RDS::DBSubnetGroup
 */
export declare class SubnetGroup extends Resource implements ISubnetGroup {
    /**
     * Imports an existing subnet group by name.
     */
    static fromSubnetGroupName(scope: Construct, id: string, subnetGroupName: string): ISubnetGroup;
    readonly subnetGroupName: string;
    constructor(scope: Construct, id: string, props: SubnetGroupProps);
}
