"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubnetGroup = void 0;
const ec2 = require("../../aws-ec2"); // Automatically re-written from '@aws-cdk/aws-ec2'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const rds_generated_1 = require("./rds.generated");
/**
 * Class for creating a RDS DB subnet group
 *
 * @resource AWS::RDS::DBSubnetGroup
 */
class SubnetGroup extends core_1.Resource {
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        const { subnetIds } = props.vpc.selectSubnets((_a = props.vpcSubnets) !== null && _a !== void 0 ? _a : { subnetType: ec2.SubnetType.PRIVATE });
        // Using 'Default' as the resource id for historical reasons (usage from `Instance` and `Cluster`).
        const subnetGroup = new rds_generated_1.CfnDBSubnetGroup(this, 'Default', {
            dbSubnetGroupDescription: props.description,
            dbSubnetGroupName: props.subnetGroupName,
            subnetIds,
        });
        if (props.removalPolicy) {
            subnetGroup.applyRemovalPolicy(props.removalPolicy);
        }
        this.subnetGroupName = subnetGroup.ref;
    }
    /**
     * Imports an existing subnet group by name.
     */
    static fromSubnetGroupName(scope, id, subnetGroupName) {
        return new class extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.subnetGroupName = subnetGroupName;
            }
        }(scope, id);
    }
}
exports.SubnetGroup = SubnetGroup;
//# sourceMappingURL=data:application/json;base64,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