"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BucketPolicy = void 0;
const aws_iam_1 = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const s3_generated_1 = require("./s3.generated");
/**
 * Applies an Amazon S3 bucket policy to an Amazon S3 bucket.
 */
class BucketPolicy extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * A policy document containing permissions to add to the specified bucket.
         * For more information, see Access Policy Language Overview in the Amazon
         * Simple Storage Service Developer Guide.
         */
        this.document = new aws_iam_1.PolicyDocument();
        if (!props.bucket.bucketName) {
            throw new Error('Bucket doesn\'t have a bucketName defined');
        }
        this.resource = new s3_generated_1.CfnBucketPolicy(this, 'Resource', {
            bucket: props.bucket.bucketName,
            policyDocument: this.document,
        });
        if (props.removalPolicy) {
            this.resource.applyRemovalPolicy(props.removalPolicy);
        }
    }
    /**
     * Sets the removal policy for the BucketPolicy.
     * @param removalPolicy the RemovalPolicy to set.
     */
    applyRemovalPolicy(removalPolicy) {
        this.resource.applyRemovalPolicy(removalPolicy);
    }
}
exports.BucketPolicy = BucketPolicy;
//# sourceMappingURL=data:application/json;base64,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