"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CnameInstance = void 0;
const instance_1 = require("./instance");
const namespace_1 = require("./namespace");
const service_1 = require("./service");
const servicediscovery_generated_1 = require("./servicediscovery.generated");
/**
 * Instance that is accessible using a domain name (CNAME).
 * @resource AWS::ServiceDiscovery::Instance
 */
class CnameInstance extends instance_1.InstanceBase {
    constructor(scope, id, props) {
        super(scope, id);
        if (props.service.namespace.type === namespace_1.NamespaceType.HTTP) {
            throw new Error('Namespace associated with Service must be a DNS Namespace.');
        }
        if (props.service.dnsRecordType !== service_1.DnsRecordType.CNAME) {
            throw new Error('A `CnameIntance` can only be used with a service using a `CNAME` record.');
        }
        const resource = new servicediscovery_generated_1.CfnInstance(this, 'Resource', {
            instanceId: props.instanceId || this.uniqueInstanceId(),
            serviceId: props.service.serviceId,
            instanceAttributes: {
                AWS_INSTANCE_CNAME: props.instanceCname,
                ...props.customAttributes,
            },
        });
        this.service = props.service;
        this.instanceId = resource.ref;
        this.cname = props.instanceCname;
    }
}
exports.CnameInstance = CnameInstance;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY25hbWUtaW5zdGFuY2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJjbmFtZS1pbnN0YW5jZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFDQSx5Q0FBNkQ7QUFDN0QsMkNBQTRDO0FBQzVDLHVDQUFvRDtBQUNwRCw2RUFBMkQ7QUFxQjNEOzs7R0FHRztBQUNILE1BQWEsYUFBYyxTQUFRLHVCQUFZO0lBYTNDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBeUI7UUFDL0QsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUNqQixJQUFJLEtBQUssQ0FBQyxPQUFPLENBQUMsU0FBUyxDQUFDLElBQUksS0FBSyx5QkFBYSxDQUFDLElBQUksRUFBRTtZQUNyRCxNQUFNLElBQUksS0FBSyxDQUFDLDREQUE0RCxDQUFDLENBQUM7U0FDakY7UUFDRCxJQUFJLEtBQUssQ0FBQyxPQUFPLENBQUMsYUFBYSxLQUFLLHVCQUFhLENBQUMsS0FBSyxFQUFFO1lBQ3JELE1BQU0sSUFBSSxLQUFLLENBQUMsMEVBQTBFLENBQUMsQ0FBQztTQUMvRjtRQUNELE1BQU0sUUFBUSxHQUFHLElBQUksd0NBQVcsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQy9DLFVBQVUsRUFBRSxLQUFLLENBQUMsVUFBVSxJQUFJLElBQUksQ0FBQyxnQkFBZ0IsRUFBRTtZQUN2RCxTQUFTLEVBQUUsS0FBSyxDQUFDLE9BQU8sQ0FBQyxTQUFTO1lBQ2xDLGtCQUFrQixFQUFFO2dCQUNoQixrQkFBa0IsRUFBRSxLQUFLLENBQUMsYUFBYTtnQkFDdkMsR0FBRyxLQUFLLENBQUMsZ0JBQWdCO2FBQzVCO1NBQ0osQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDO1FBQzdCLElBQUksQ0FBQyxVQUFVLEdBQUcsUUFBUSxDQUFDLEdBQUcsQ0FBQztRQUMvQixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQyxhQUFhLENBQUM7SUFDckMsQ0FBQztDQUNKO0FBakNELHNDQWlDQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgQmFzZUluc3RhbmNlUHJvcHMsIEluc3RhbmNlQmFzZSB9IGZyb20gJy4vaW5zdGFuY2UnO1xuaW1wb3J0IHsgTmFtZXNwYWNlVHlwZSB9IGZyb20gJy4vbmFtZXNwYWNlJztcbmltcG9ydCB7IERuc1JlY29yZFR5cGUsIElTZXJ2aWNlIH0gZnJvbSAnLi9zZXJ2aWNlJztcbmltcG9ydCB7IENmbkluc3RhbmNlIH0gZnJvbSAnLi9zZXJ2aWNlZGlzY292ZXJ5LmdlbmVyYXRlZCc7XG4vKlxuICogUHJvcGVydGllcyBmb3IgYSBDbmFtZUluc3RhbmNlIHVzZWQgZm9yIHNlcnZpY2UjcmVnaXN0ZXJDbmFtZUluc3RhbmNlXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ25hbWVJbnN0YW5jZUJhc2VQcm9wcyBleHRlbmRzIEJhc2VJbnN0YW5jZVByb3BzIHtcbiAgICAvKipcbiAgICAgKiBJZiB0aGUgc2VydmljZSBjb25maWd1cmF0aW9uIGluY2x1ZGVzIGEgQ05BTUUgcmVjb3JkLCB0aGUgZG9tYWluIG5hbWUgdGhhdCB5b3Ugd2FudCBSb3V0ZSA1MyB0b1xuICAgICAqIHJldHVybiBpbiByZXNwb25zZSB0byBETlMgcXVlcmllcywgZm9yIGV4YW1wbGUsIGV4YW1wbGUuY29tLiBUaGlzIHZhbHVlIGlzIHJlcXVpcmVkIGlmIHRoZVxuICAgICAqIHNlcnZpY2Ugc3BlY2lmaWVkIGJ5IFNlcnZpY2VJZCBpbmNsdWRlcyBzZXR0aW5ncyBmb3IgYW4gQ05BTUUgcmVjb3JkLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGluc3RhbmNlQ25hbWU6IHN0cmluZztcbn1cbi8qXG4gKiBQcm9wZXJ0aWVzIGZvciBhIENuYW1lSW5zdGFuY2VcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBDbmFtZUluc3RhbmNlUHJvcHMgZXh0ZW5kcyBDbmFtZUluc3RhbmNlQmFzZVByb3BzIHtcbiAgICAvKipcbiAgICAgKiBUaGUgQ2xvdWRtYXAgc2VydmljZSB0aGlzIHJlc291cmNlIGlzIHJlZ2lzdGVyZWQgdG8uXG4gICAgICovXG4gICAgcmVhZG9ubHkgc2VydmljZTogSVNlcnZpY2U7XG59XG4vKipcbiAqIEluc3RhbmNlIHRoYXQgaXMgYWNjZXNzaWJsZSB1c2luZyBhIGRvbWFpbiBuYW1lIChDTkFNRSkuXG4gKiBAcmVzb3VyY2UgQVdTOjpTZXJ2aWNlRGlzY292ZXJ5OjpJbnN0YW5jZVxuICovXG5leHBvcnQgY2xhc3MgQ25hbWVJbnN0YW5jZSBleHRlbmRzIEluc3RhbmNlQmFzZSB7XG4gICAgLyoqXG4gICAgICogVGhlIElkIG9mIHRoZSBpbnN0YW5jZVxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBpbnN0YW5jZUlkOiBzdHJpbmc7XG4gICAgLyoqXG4gICAgICogVGhlIENsb3VkbWFwIHNlcnZpY2UgdG8gd2hpY2ggdGhlIGluc3RhbmNlIGlzIHJlZ2lzdGVyZWQuXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IHNlcnZpY2U6IElTZXJ2aWNlO1xuICAgIC8qKlxuICAgICAqIFRoZSBkb21haW4gbmFtZSByZXR1cm5lZCBieSBETlMgcXVlcmllcyBmb3IgdGhlIGluc3RhbmNlXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGNuYW1lOiBzdHJpbmc7XG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IENuYW1lSW5zdGFuY2VQcm9wcykge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQpO1xuICAgICAgICBpZiAocHJvcHMuc2VydmljZS5uYW1lc3BhY2UudHlwZSA9PT0gTmFtZXNwYWNlVHlwZS5IVFRQKSB7XG4gICAgICAgICAgICB0aHJvdyBuZXcgRXJyb3IoJ05hbWVzcGFjZSBhc3NvY2lhdGVkIHdpdGggU2VydmljZSBtdXN0IGJlIGEgRE5TIE5hbWVzcGFjZS4nKTtcbiAgICAgICAgfVxuICAgICAgICBpZiAocHJvcHMuc2VydmljZS5kbnNSZWNvcmRUeXBlICE9PSBEbnNSZWNvcmRUeXBlLkNOQU1FKSB7XG4gICAgICAgICAgICB0aHJvdyBuZXcgRXJyb3IoJ0EgYENuYW1lSW50YW5jZWAgY2FuIG9ubHkgYmUgdXNlZCB3aXRoIGEgc2VydmljZSB1c2luZyBhIGBDTkFNRWAgcmVjb3JkLicpO1xuICAgICAgICB9XG4gICAgICAgIGNvbnN0IHJlc291cmNlID0gbmV3IENmbkluc3RhbmNlKHRoaXMsICdSZXNvdXJjZScsIHtcbiAgICAgICAgICAgIGluc3RhbmNlSWQ6IHByb3BzLmluc3RhbmNlSWQgfHwgdGhpcy51bmlxdWVJbnN0YW5jZUlkKCksXG4gICAgICAgICAgICBzZXJ2aWNlSWQ6IHByb3BzLnNlcnZpY2Uuc2VydmljZUlkLFxuICAgICAgICAgICAgaW5zdGFuY2VBdHRyaWJ1dGVzOiB7XG4gICAgICAgICAgICAgICAgQVdTX0lOU1RBTkNFX0NOQU1FOiBwcm9wcy5pbnN0YW5jZUNuYW1lLFxuICAgICAgICAgICAgICAgIC4uLnByb3BzLmN1c3RvbUF0dHJpYnV0ZXMsXG4gICAgICAgICAgICB9LFxuICAgICAgICB9KTtcbiAgICAgICAgdGhpcy5zZXJ2aWNlID0gcHJvcHMuc2VydmljZTtcbiAgICAgICAgdGhpcy5pbnN0YW5jZUlkID0gcmVzb3VyY2UucmVmO1xuICAgICAgICB0aGlzLmNuYW1lID0gcHJvcHMuaW5zdGFuY2VDbmFtZTtcbiAgICB9XG59XG4iXX0=