"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PrivateDnsNamespace = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const namespace_1 = require("./namespace");
const service_1 = require("./service");
const servicediscovery_generated_1 = require("./servicediscovery.generated");
/**
 * Define a Service Discovery HTTP Namespace
 */
class PrivateDnsNamespace extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        if (props.vpc === undefined) {
            throw new Error('VPC must be specified for PrivateDNSNamespaces');
        }
        const ns = new servicediscovery_generated_1.CfnPrivateDnsNamespace(this, 'Resource', {
            name: props.name,
            description: props.description,
            vpc: props.vpc.vpcId,
        });
        this.namespaceName = props.name;
        this.namespaceId = ns.attrId;
        this.namespaceArn = ns.attrArn;
        this.type = namespace_1.NamespaceType.DNS_PRIVATE;
    }
    static fromPrivateDnsNamespaceAttributes(scope, id, attrs) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.namespaceName = attrs.namespaceName;
                this.namespaceId = attrs.namespaceId;
                this.namespaceArn = attrs.namespaceArn;
                this.type = namespace_1.NamespaceType.DNS_PRIVATE;
            }
        }
        return new Import(scope, id);
    }
    /** @attribute */
    get privateDnsNamespaceArn() { return this.namespaceArn; }
    /** @attribute */
    get privateDnsNamespaceName() { return this.namespaceName; }
    /** @attribute */
    get privateDnsNamespaceId() { return this.namespaceId; }
    /**
     * Creates a service within the namespace
     */
    createService(id, props) {
        return new service_1.Service(this, id, {
            namespace: this,
            ...props,
        });
    }
}
exports.PrivateDnsNamespace = PrivateDnsNamespace;
//# sourceMappingURL=data:application/json;base64,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