"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PublicDnsNamespace = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const namespace_1 = require("./namespace");
const service_1 = require("./service");
const servicediscovery_generated_1 = require("./servicediscovery.generated");
/**
 * Define a Public DNS Namespace
 */
class PublicDnsNamespace extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        const ns = new servicediscovery_generated_1.CfnPublicDnsNamespace(this, 'Resource', {
            name: props.name,
            description: props.description,
        });
        this.namespaceName = props.name;
        this.namespaceId = ns.attrId;
        this.namespaceArn = ns.attrArn;
        this.type = namespace_1.NamespaceType.DNS_PUBLIC;
    }
    static fromPublicDnsNamespaceAttributes(scope, id, attrs) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.namespaceName = attrs.namespaceName;
                this.namespaceId = attrs.namespaceId;
                this.namespaceArn = attrs.namespaceArn;
                this.type = namespace_1.NamespaceType.DNS_PUBLIC;
            }
        }
        return new Import(scope, id);
    }
    /** @attribute */
    get publicDnsNamespaceArn() { return this.namespaceArn; }
    /** @attribute */
    get publicDnsNamespaceName() { return this.namespaceName; }
    /** @attribute */
    get publicDnsNamespaceId() { return this.namespaceId; }
    /**
     * Creates a service within the namespace
     */
    createService(id, props) {
        return new service_1.Service(this, id, {
            namespace: this,
            ...props,
        });
    }
}
exports.PublicDnsNamespace = PublicDnsNamespace;
//# sourceMappingURL=data:application/json;base64,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