"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Stop = void 0;
/**
 * Terminates the evaluation of the receipt rule set and optionally publishes a
 * notification to Amazon SNS.
 */
class Stop {
    constructor(props = {}) {
        this.props = props;
    }
    bind(_rule) {
        return {
            stopAction: {
                scope: 'RuleSet',
                topicArn: this.props.topic ? this.props.topic.topicArn : undefined,
            },
        };
    }
}
exports.Stop = Stop;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RvcC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInN0b3AudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBV0E7OztHQUdHO0FBQ0gsTUFBYSxJQUFJO0lBQ2IsWUFBNkIsUUFBbUIsRUFBRTtRQUFyQixVQUFLLEdBQUwsS0FBSyxDQUFnQjtJQUNsRCxDQUFDO0lBQ00sSUFBSSxDQUFDLEtBQXVCO1FBQy9CLE9BQU87WUFDSCxVQUFVLEVBQUU7Z0JBQ1IsS0FBSyxFQUFFLFNBQVM7Z0JBQ2hCLFFBQVEsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxTQUFTO2FBQ3JFO1NBQ0osQ0FBQztJQUNOLENBQUM7Q0FDSjtBQVhELG9CQVdDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgc2VzIGZyb20gXCIuLi8uLi9hd3Mtc2VzXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3Mtc2VzJ1xuaW1wb3J0ICogYXMgc25zIGZyb20gXCIuLi8uLi9hd3Mtc25zXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3Mtc25zJ1xuLyoqXG4gKiBDb25zdHJ1Y3Rpb24gcHJvcGVydGllcyBmb3IgYSBzdG9wIGFjdGlvbi5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBTdG9wUHJvcHMge1xuICAgIC8qKlxuICAgICAqIFRoZSBTTlMgdG9waWMgdG8gbm90aWZ5IHdoZW4gdGhlIHN0b3AgYWN0aW9uIGlzIHRha2VuLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHRvcGljPzogc25zLklUb3BpYztcbn1cbi8qKlxuICogVGVybWluYXRlcyB0aGUgZXZhbHVhdGlvbiBvZiB0aGUgcmVjZWlwdCBydWxlIHNldCBhbmQgb3B0aW9uYWxseSBwdWJsaXNoZXMgYVxuICogbm90aWZpY2F0aW9uIHRvIEFtYXpvbiBTTlMuXG4gKi9cbmV4cG9ydCBjbGFzcyBTdG9wIGltcGxlbWVudHMgc2VzLklSZWNlaXB0UnVsZUFjdGlvbiB7XG4gICAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBwcm9wczogU3RvcFByb3BzID0ge30pIHtcbiAgICB9XG4gICAgcHVibGljIGJpbmQoX3J1bGU6IHNlcy5JUmVjZWlwdFJ1bGUpOiBzZXMuUmVjZWlwdFJ1bGVBY3Rpb25Db25maWcge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgc3RvcEFjdGlvbjoge1xuICAgICAgICAgICAgICAgIHNjb3BlOiAnUnVsZVNldCcsXG4gICAgICAgICAgICAgICAgdG9waWNBcm46IHRoaXMucHJvcHMudG9waWMgPyB0aGlzLnByb3BzLnRvcGljLnRvcGljQXJuIDogdW5kZWZpbmVkLFxuICAgICAgICAgICAgfSxcbiAgICAgICAgfTtcbiAgICB9XG59XG4iXX0=