"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReceiptRuleSet = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const receipt_rule_1 = require("./receipt-rule");
const ses_generated_1 = require("./ses.generated");
/**
 * A new or imported receipt rule set.
 */
class ReceiptRuleSetBase extends core_1.Resource {
    /**
     * Adds a new receipt rule in this rule set. The new rule is added after
     * the last added rule unless `after` is specified.
     */
    addRule(id, options) {
        this.lastAddedRule = new receipt_rule_1.ReceiptRule(this, id, {
            after: this.lastAddedRule ? this.lastAddedRule : undefined,
            ruleSet: this,
            ...options,
        });
        return this.lastAddedRule;
    }
    /**
     * Adds a drop spam rule
     */
    addDropSpamRule() {
        const dropSpam = new receipt_rule_1.DropSpamReceiptRule(this, 'DropSpam', {
            ruleSet: this,
        });
        this.lastAddedRule = dropSpam.rule;
    }
}
/**
 * A new receipt rule set.
 */
class ReceiptRuleSet extends ReceiptRuleSetBase {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.receiptRuleSetName,
        });
        const resource = new ses_generated_1.CfnReceiptRuleSet(this, 'Resource', {
            ruleSetName: this.physicalName,
        });
        this.receiptRuleSetName = resource.ref;
        if (props) {
            const rules = props.rules || [];
            rules.forEach((ruleOption, idx) => this.addRule(`Rule${idx}`, ruleOption));
            if (props.dropSpam) {
                this.addDropSpamRule();
            }
        }
    }
    /**
     * Import an exported receipt rule set.
     */
    static fromReceiptRuleSetName(scope, id, receiptRuleSetName) {
        class Import extends ReceiptRuleSetBase {
            constructor() {
                super(...arguments);
                this.receiptRuleSetName = receiptRuleSetName;
            }
        }
        return new Import(scope, id);
    }
}
exports.ReceiptRuleSet = ReceiptRuleSet;
//# sourceMappingURL=data:application/json;base64,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