"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmsSubscription = void 0;
const sns = require("../../aws-sns"); // Automatically re-written from '@aws-cdk/aws-sns'
/**
 * Use an sms address as a subscription target
 */
class SmsSubscription {
    constructor(phoneNumber, props = {}) {
        this.phoneNumber = phoneNumber;
        this.props = props;
    }
    bind(_topic) {
        return {
            subscriberId: this.phoneNumber,
            endpoint: this.phoneNumber,
            protocol: sns.SubscriptionProtocol.SMS,
            filterPolicy: this.props.filterPolicy,
        };
    }
}
exports.SmsSubscription = SmsSubscription;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic21zLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic21zLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLHFDQUFxQyxDQUFDLG1EQUFtRDtBQU96Rjs7R0FFRztBQUNILE1BQWEsZUFBZTtJQUN4QixZQUE2QixXQUFtQixFQUFtQixRQUE4QixFQUFFO1FBQXRFLGdCQUFXLEdBQVgsV0FBVyxDQUFRO1FBQW1CLFVBQUssR0FBTCxLQUFLLENBQTJCO0lBQ25HLENBQUM7SUFDTSxJQUFJLENBQUMsTUFBa0I7UUFDMUIsT0FBTztZQUNILFlBQVksRUFBRSxJQUFJLENBQUMsV0FBVztZQUM5QixRQUFRLEVBQUUsSUFBSSxDQUFDLFdBQVc7WUFDMUIsUUFBUSxFQUFFLEdBQUcsQ0FBQyxvQkFBb0IsQ0FBQyxHQUFHO1lBQ3RDLFlBQVksRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFlBQVk7U0FDeEMsQ0FBQztJQUNOLENBQUM7Q0FDSjtBQVhELDBDQVdDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgc25zIGZyb20gXCIuLi8uLi9hd3Mtc25zXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3Mtc25zJ1xuaW1wb3J0IHsgU3Vic2NyaXB0aW9uUHJvcHMgfSBmcm9tICcuL3N1YnNjcmlwdGlvbic7XG4vKipcbiAqIE9wdGlvbnMgZm9yIFNNUyBzdWJzY3JpcHRpb25zLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIFNtc1N1YnNjcmlwdGlvblByb3BzIGV4dGVuZHMgU3Vic2NyaXB0aW9uUHJvcHMge1xufVxuLyoqXG4gKiBVc2UgYW4gc21zIGFkZHJlc3MgYXMgYSBzdWJzY3JpcHRpb24gdGFyZ2V0XG4gKi9cbmV4cG9ydCBjbGFzcyBTbXNTdWJzY3JpcHRpb24gaW1wbGVtZW50cyBzbnMuSVRvcGljU3Vic2NyaXB0aW9uIHtcbiAgICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IHBob25lTnVtYmVyOiBzdHJpbmcsIHByaXZhdGUgcmVhZG9ubHkgcHJvcHM6IFNtc1N1YnNjcmlwdGlvblByb3BzID0ge30pIHtcbiAgICB9XG4gICAgcHVibGljIGJpbmQoX3RvcGljOiBzbnMuSVRvcGljKTogc25zLlRvcGljU3Vic2NyaXB0aW9uQ29uZmlnIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIHN1YnNjcmliZXJJZDogdGhpcy5waG9uZU51bWJlcixcbiAgICAgICAgICAgIGVuZHBvaW50OiB0aGlzLnBob25lTnVtYmVyLFxuICAgICAgICAgICAgcHJvdG9jb2w6IHNucy5TdWJzY3JpcHRpb25Qcm90b2NvbC5TTVMsXG4gICAgICAgICAgICBmaWx0ZXJQb2xpY3k6IHRoaXMucHJvcHMuZmlsdGVyUG9saWN5LFxuICAgICAgICB9O1xuICAgIH1cbn1cbiJdfQ==