"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TopicPolicy = void 0;
const aws_iam_1 = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const sns_generated_1 = require("./sns.generated");
/**
 * Applies a policy to SNS topics.
 */
class TopicPolicy extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * The IAM policy document for this policy.
         */
        this.document = new aws_iam_1.PolicyDocument({
            // statements must be unique, so we use the statement index.
            // potantially SIDs can change as a result of order change, but this should
            // not have an impact on the policy evaluation.
            // https://docs.aws.amazon.com/sns/latest/dg/AccessPolicyLanguage_SpecialInfo.html
            assignSids: true,
        });
        new sns_generated_1.CfnTopicPolicy(this, 'Resource', {
            policyDocument: this.document,
            topics: props.topics.map(t => t.topicArn),
        });
    }
}
exports.TopicPolicy = TopicPolicy;
//# sourceMappingURL=data:application/json;base64,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