import * as iam from "../../aws-iam";
import * as lambda from "../../aws-lambda";
import * as sfn from "../../aws-stepfunctions";
import * as cdk from "../../core";
/**
 * Properties for EvaluateExpression
 *
 * @experimental
 */
export interface EvaluateExpressionProps extends sfn.TaskStateBaseProps {
    /**
     * The expression to evaluate. The expression may contain state paths.
     *
     * @example '$.a + $.b'
     */
    readonly expression: string;
    /**
     * The runtime language to use to evaluate the expression.
     *
     * @default lambda.Runtime.NODEJS_10_X
     */
    readonly runtime?: lambda.Runtime;
}
/**
 * A Step Functions Task to evaluate an expression
 *
 * OUTPUT: the output of this task is the evaluated expression.
 *
 * @experimental
 */
export declare class EvaluateExpression extends sfn.TaskStateBase {
    private readonly props;
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    protected readonly taskPolicies?: iam.PolicyStatement[];
    private readonly evalFn;
    constructor(scope: cdk.Construct, id: string, props: EvaluateExpressionProps);
}
