"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceIntegrationPattern = void 0;
/**
 * Three ways to call an integrated service: Request Response, Run a Job and Wait for a Callback with Task Token.
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html
 *
 * Here, they are named as FIRE_AND_FORGET, SYNC and WAIT_FOR_TASK_TOKEN respectly.
 *
 * @default FIRE_AND_FORGET
 */
var ServiceIntegrationPattern;
(function (ServiceIntegrationPattern) {
    /**
     * Call a service and progress to the next state immediately after the API call completes
     */
    ServiceIntegrationPattern["FIRE_AND_FORGET"] = "FIRE_AND_FORGET";
    /**
     * Call a service and wait for a job to complete.
     */
    ServiceIntegrationPattern["SYNC"] = "SYNC";
    /**
     * Call a service with a task token and wait until that token is returned by SendTaskSuccess/SendTaskFailure with paylaod
     */
    ServiceIntegrationPattern["WAIT_FOR_TASK_TOKEN"] = "WAIT_FOR_TASK_TOKEN";
})(ServiceIntegrationPattern = exports.ServiceIntegrationPattern || (exports.ServiceIntegrationPattern = {}));
//# sourceMappingURL=data:application/json;base64,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