"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ArtifactMetadataEntryType = void 0;
/**
 * Type of artifact metadata entry.
 */
var ArtifactMetadataEntryType;
(function (ArtifactMetadataEntryType) {
    /**
     * Asset in metadata.
     */
    ArtifactMetadataEntryType["ASSET"] = "aws:cdk:asset";
    /**
     * Metadata key used to print INFO-level messages by the toolkit when an app is syntheized.
     */
    ArtifactMetadataEntryType["INFO"] = "aws:cdk:info";
    /**
     * Metadata key used to print WARNING-level messages by the toolkit when an app is syntheized.
     */
    ArtifactMetadataEntryType["WARN"] = "aws:cdk:warning";
    /**
     * Metadata key used to print ERROR-level messages by the toolkit when an app is syntheized.
     */
    ArtifactMetadataEntryType["ERROR"] = "aws:cdk:error";
    /**
     * Represents the CloudFormation logical ID of a resource at a certain path.
     */
    ArtifactMetadataEntryType["LOGICAL_ID"] = "aws:cdk:logicalId";
    /**
     * Represents tags of a stack.
     */
    ArtifactMetadataEntryType["STACK_TAGS"] = "aws:cdk:stack-tags";
})(ArtifactMetadataEntryType = exports.ArtifactMetadataEntryType || (exports.ArtifactMetadataEntryType = {}));
//# sourceMappingURL=data:application/json;base64,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