"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.lookup = void 0;
const path = require("path");
const futils = require("./file-utils");
let cfnTypeToL1Mapping;
/**
 * Returns the fully-qualified name
 * (that is, including the NPM package name)
 * of a class that corresponds to this CloudFormation type,
 * or undefined if the given type was not found.
 *
 * For example, lookup("AWS::S3::Bucket")
 * returns "@aws-cdk/aws-s3.CfnBucket".
 */
function lookup(cfnType) {
    if (!cfnTypeToL1Mapping) {
        cfnTypeToL1Mapping = loadCfnTypeToL1Mapping();
    }
    return cfnTypeToL1Mapping[cfnType];
}
exports.lookup = lookup;
function loadCfnTypeToL1Mapping() {
    return futils.readJsonSync(path.join(__dirname, '..', 'cfn-types-2-classes.json'));
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2ZuLXR5cGUtdG8tbDEtbWFwcGluZy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImNmbi10eXBlLXRvLWwxLW1hcHBpbmcudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsNkJBQTZCO0FBQzdCLHVDQUF1QztBQUN2QyxJQUFJLGtCQUVILENBQUM7QUFDRjs7Ozs7Ozs7R0FRRztBQUNILFNBQWdCLE1BQU0sQ0FBQyxPQUFlO0lBQ2xDLElBQUksQ0FBQyxrQkFBa0IsRUFBRTtRQUNyQixrQkFBa0IsR0FBRyxzQkFBc0IsRUFBRSxDQUFDO0tBQ2pEO0lBQ0QsT0FBTyxrQkFBa0IsQ0FBQyxPQUFPLENBQUMsQ0FBQztBQUN2QyxDQUFDO0FBTEQsd0JBS0M7QUFDRCxTQUFTLHNCQUFzQjtJQUMzQixPQUFPLE1BQU0sQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsSUFBSSxFQUFFLDBCQUEwQixDQUFDLENBQUMsQ0FBQztBQUN2RixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgcGF0aCBmcm9tICdwYXRoJztcbmltcG9ydCAqIGFzIGZ1dGlscyBmcm9tICcuL2ZpbGUtdXRpbHMnO1xubGV0IGNmblR5cGVUb0wxTWFwcGluZzoge1xuICAgIFt0eXBlOiBzdHJpbmddOiBzdHJpbmc7XG59O1xuLyoqXG4gKiBSZXR1cm5zIHRoZSBmdWxseS1xdWFsaWZpZWQgbmFtZVxuICogKHRoYXQgaXMsIGluY2x1ZGluZyB0aGUgTlBNIHBhY2thZ2UgbmFtZSlcbiAqIG9mIGEgY2xhc3MgdGhhdCBjb3JyZXNwb25kcyB0byB0aGlzIENsb3VkRm9ybWF0aW9uIHR5cGUsXG4gKiBvciB1bmRlZmluZWQgaWYgdGhlIGdpdmVuIHR5cGUgd2FzIG5vdCBmb3VuZC5cbiAqXG4gKiBGb3IgZXhhbXBsZSwgbG9va3VwKFwiQVdTOjpTMzo6QnVja2V0XCIpXG4gKiByZXR1cm5zIFwiQGF3cy1jZGsvYXdzLXMzLkNmbkJ1Y2tldFwiLlxuICovXG5leHBvcnQgZnVuY3Rpb24gbG9va3VwKGNmblR5cGU6IHN0cmluZyk6IHN0cmluZyB8IHVuZGVmaW5lZCB7XG4gICAgaWYgKCFjZm5UeXBlVG9MMU1hcHBpbmcpIHtcbiAgICAgICAgY2ZuVHlwZVRvTDFNYXBwaW5nID0gbG9hZENmblR5cGVUb0wxTWFwcGluZygpO1xuICAgIH1cbiAgICByZXR1cm4gY2ZuVHlwZVRvTDFNYXBwaW5nW2NmblR5cGVdO1xufVxuZnVuY3Rpb24gbG9hZENmblR5cGVUb0wxTWFwcGluZygpOiBhbnkge1xuICAgIHJldHVybiBmdXRpbHMucmVhZEpzb25TeW5jKHBhdGguam9pbihfX2Rpcm5hbWUsICcuLicsICdjZm4tdHlwZXMtMi1jbGFzc2VzLmpzb24nKSk7XG59XG4iXX0=