"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileAssetPackaging = exports.AssetHashType = void 0;
/**
 * The type of asset hash
 *
 * NOTE: the hash is used in order to identify a specific revision of the asset, and
 * used for optimizing and caching deployment activities related to this asset such as
 * packaging, uploading to Amazon S3, etc.
 */
var AssetHashType;
(function (AssetHashType) {
    /**
     * Based on the content of the source path
     *
     * When bundling, use `SOURCE` when the content of the bundling output is not
     * stable across repeated bundling operations.
     */
    AssetHashType["SOURCE"] = "source";
    /**
     * Based on the content of the bundled path
     *
     * @deprecated use `OUTPUT` instead
     */
    AssetHashType["BUNDLE"] = "bundle";
    /**
     * Based on the content of the bundling output
     *
     * Use `OUTPUT` when the source of the asset is a top level folder containing
     * code and/or dependencies that are not directly linked to the asset.
     */
    AssetHashType["OUTPUT"] = "output";
    /**
     * Use a custom hash
     */
    AssetHashType["CUSTOM"] = "custom";
})(AssetHashType = exports.AssetHashType || (exports.AssetHashType = {}));
/**
 * Packaging modes for file assets.
 */
var FileAssetPackaging;
(function (FileAssetPackaging) {
    /**
     * The asset source path points to a directory, which should be archived using
     * zip and and then uploaded to Amazon S3.
     */
    FileAssetPackaging["ZIP_DIRECTORY"] = "zip";
    /**
     * The asset source path points to a single file, which should be uploaded
     * to Amazon S3.
     */
    FileAssetPackaging["FILE"] = "file";
})(FileAssetPackaging = exports.FileAssetPackaging || (exports.FileAssetPackaging = {}));
//# sourceMappingURL=data:application/json;base64,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