"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnMapping = void 0;
const cfn_element_1 = require("./cfn-element");
const cfn_fn_1 = require("./cfn-fn");
const token_1 = require("./token");
/**
 * Represents a CloudFormation mapping.
 */
class CfnMapping extends cfn_element_1.CfnRefElement {
    constructor(scope, id, props = {}) {
        super(scope, id);
        this.mapping = {};
        this.mapping = props.mapping || {};
    }
    /**
     * Sets a value in the map based on the two keys.
     */
    setValue(key1, key2, value) {
        if (!(key1 in this.mapping)) {
            this.mapping[key1] = {};
        }
        this.mapping[key1][key2] = value;
    }
    /**
     * @returns A reference to a value in the map based on the two keys.
     */
    findInMap(key1, key2) {
        // opportunistically check that the key exists (if the key does not contain tokens)
        if (!token_1.Token.isUnresolved(key1) && !(key1 in this.mapping)) {
            throw new Error(`Mapping doesn't contain top-level key '${key1}'`);
        }
        // opportunistically check that the second key exists (if the key does not contain tokens)
        if (!token_1.Token.isUnresolved(key1) && !token_1.Token.isUnresolved(key2) && !(key2 in this.mapping[key1])) {
            throw new Error(`Mapping doesn't contain second-level key '${key2}'`);
        }
        return cfn_fn_1.Fn.findInMap(this.logicalId, key1, key2);
    }
    /**
     * @internal
     */
    _toCloudFormation() {
        return {
            Mappings: {
                [this.logicalId]: this.mapping,
            },
        };
    }
}
exports.CfnMapping = CfnMapping;
//# sourceMappingURL=data:application/json;base64,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