"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhysicalName = void 0;
const physical_name_generator_1 = require("./private/physical-name-generator");
const token_1 = require("./token");
/**
 * Includes special markers for automatic generation of physical names.
 */
class PhysicalName {
    constructor() { }
}
exports.PhysicalName = PhysicalName;
/**
 * Use this to automatically generate a physical name for an AWS resource only
 * if the resource is referenced across environments (account/region).
 * Otherwise, the name will be allocated during deployment by CloudFormation.
 *
 * If you are certain that a resource will be referenced across environments,
 * you may also specify an explicit physical name for it. This option is
 * mostly designed for reusable constructs which may or may not be referenced
 * acrossed environments.
 */
PhysicalName.GENERATE_IF_NEEDED = token_1.Token.asString(new physical_name_generator_1.GeneratedWhenNeededMarker());
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGh5c2ljYWwtbmFtZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInBoeXNpY2FsLW5hbWUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsK0VBQThFO0FBQzlFLG1DQUFnQztBQUNoQzs7R0FFRztBQUNILE1BQWEsWUFBWTtJQVlyQixnQkFBd0IsQ0FBQzs7QUFaN0Isb0NBYUM7QUFaRzs7Ozs7Ozs7O0dBU0c7QUFDb0IsK0JBQWtCLEdBQUcsYUFBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLG1EQUF5QixFQUFFLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEdlbmVyYXRlZFdoZW5OZWVkZWRNYXJrZXIgfSBmcm9tICcuL3ByaXZhdGUvcGh5c2ljYWwtbmFtZS1nZW5lcmF0b3InO1xuaW1wb3J0IHsgVG9rZW4gfSBmcm9tICcuL3Rva2VuJztcbi8qKlxuICogSW5jbHVkZXMgc3BlY2lhbCBtYXJrZXJzIGZvciBhdXRvbWF0aWMgZ2VuZXJhdGlvbiBvZiBwaHlzaWNhbCBuYW1lcy5cbiAqL1xuZXhwb3J0IGNsYXNzIFBoeXNpY2FsTmFtZSB7XG4gICAgLyoqXG4gICAgICogVXNlIHRoaXMgdG8gYXV0b21hdGljYWxseSBnZW5lcmF0ZSBhIHBoeXNpY2FsIG5hbWUgZm9yIGFuIEFXUyByZXNvdXJjZSBvbmx5XG4gICAgICogaWYgdGhlIHJlc291cmNlIGlzIHJlZmVyZW5jZWQgYWNyb3NzIGVudmlyb25tZW50cyAoYWNjb3VudC9yZWdpb24pLlxuICAgICAqIE90aGVyd2lzZSwgdGhlIG5hbWUgd2lsbCBiZSBhbGxvY2F0ZWQgZHVyaW5nIGRlcGxveW1lbnQgYnkgQ2xvdWRGb3JtYXRpb24uXG4gICAgICpcbiAgICAgKiBJZiB5b3UgYXJlIGNlcnRhaW4gdGhhdCBhIHJlc291cmNlIHdpbGwgYmUgcmVmZXJlbmNlZCBhY3Jvc3MgZW52aXJvbm1lbnRzLFxuICAgICAqIHlvdSBtYXkgYWxzbyBzcGVjaWZ5IGFuIGV4cGxpY2l0IHBoeXNpY2FsIG5hbWUgZm9yIGl0LiBUaGlzIG9wdGlvbiBpc1xuICAgICAqIG1vc3RseSBkZXNpZ25lZCBmb3IgcmV1c2FibGUgY29uc3RydWN0cyB3aGljaCBtYXkgb3IgbWF5IG5vdCBiZSByZWZlcmVuY2VkXG4gICAgICogYWNyb3NzZWQgZW52aXJvbm1lbnRzLlxuICAgICAqL1xuICAgIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgR0VORVJBVEVfSUZfTkVFREVEID0gVG9rZW4uYXNTdHJpbmcobmV3IEdlbmVyYXRlZFdoZW5OZWVkZWRNYXJrZXIoKSk7XG4gICAgcHJpdmF0ZSBjb25zdHJ1Y3RvcigpIHsgfVxufVxuIl19