"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnUtilsProvider = void 0;
const construct_compat_1 = require("../construct-compat");
const custom_resource_provider_1 = require("../custom-resource-provider");
/**
 * A custom resource provider for CFN utilities such as `CfnJson`.
 */
class CfnUtilsProvider extends construct_compat_1.Construct {
    static getOrCreate(scope) {
        return custom_resource_provider_1.CustomResourceProvider.getOrCreate(scope, 'AWSCDKCfnUtilsProvider', {
            runtime: custom_resource_provider_1.CustomResourceProviderRuntime.NODEJS_12,
            codeDirectory: `${__dirname}/cfn-utils-provider`,
        });
    }
}
exports.CfnUtilsProvider = CfnUtilsProvider;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2ZuLXV0aWxzLXByb3ZpZGVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiY2ZuLXV0aWxzLXByb3ZpZGVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLDBEQUFnRDtBQUNoRCwwRUFBb0c7QUFDcEc7O0dBRUc7QUFDSCxNQUFhLGdCQUFpQixTQUFRLDRCQUFTO0lBQ3BDLE1BQU0sQ0FBQyxXQUFXLENBQUMsS0FBZ0I7UUFDdEMsT0FBTyxpREFBc0IsQ0FBQyxXQUFXLENBQUMsS0FBSyxFQUFFLHdCQUF3QixFQUFFO1lBQ3ZFLE9BQU8sRUFBRSx3REFBNkIsQ0FBQyxTQUFTO1lBQ2hELGFBQWEsRUFBRSxHQUFHLFNBQVMscUJBQXFCO1NBQ25ELENBQUMsQ0FBQztJQUNQLENBQUM7Q0FDSjtBQVBELDRDQU9DIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnLi4vY29uc3RydWN0LWNvbXBhdCc7XG5pbXBvcnQgeyBDdXN0b21SZXNvdXJjZVByb3ZpZGVyLCBDdXN0b21SZXNvdXJjZVByb3ZpZGVyUnVudGltZSB9IGZyb20gJy4uL2N1c3RvbS1yZXNvdXJjZS1wcm92aWRlcic7XG4vKipcbiAqIEEgY3VzdG9tIHJlc291cmNlIHByb3ZpZGVyIGZvciBDRk4gdXRpbGl0aWVzIHN1Y2ggYXMgYENmbkpzb25gLlxuICovXG5leHBvcnQgY2xhc3MgQ2ZuVXRpbHNQcm92aWRlciBleHRlbmRzIENvbnN0cnVjdCB7XG4gICAgcHVibGljIHN0YXRpYyBnZXRPckNyZWF0ZShzY29wZTogQ29uc3RydWN0KSB7XG4gICAgICAgIHJldHVybiBDdXN0b21SZXNvdXJjZVByb3ZpZGVyLmdldE9yQ3JlYXRlKHNjb3BlLCAnQVdTQ0RLQ2ZuVXRpbHNQcm92aWRlcicsIHtcbiAgICAgICAgICAgIHJ1bnRpbWU6IEN1c3RvbVJlc291cmNlUHJvdmlkZXJSdW50aW1lLk5PREVKU18xMixcbiAgICAgICAgICAgIGNvZGVEaXJlY3Rvcnk6IGAke19fZGlybmFtZX0vY2ZuLXV0aWxzLXByb3ZpZGVyYCxcbiAgICAgICAgfSk7XG4gICAgfVxufVxuIl19