"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
/**
 * Parses the value of "Value" and reflects it back as attribute.
 */
async function handler(event) {
    // dispatch based on resource type
    if (event.ResourceType === "Custom::AWSCDKCfnJson" /* CFN_JSON */) {
        return cfnJsonHandler(event);
    }
    throw new Error(`unexpected resource type "${event.ResourceType}`);
}
exports.handler = handler;
function cfnJsonHandler(event) {
    return {
        Data: {
            Value: JSON.parse(event.ResourceProperties.Value),
        },
    };
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFDQTs7R0FFRztBQUNJLEtBQUssVUFBVSxPQUFPLENBQUMsS0FBa0Q7SUFDNUUsa0NBQWtDO0lBQ2xDLElBQUksS0FBSyxDQUFDLFlBQVksMkNBQWtDLEVBQUU7UUFDdEQsT0FBTyxjQUFjLENBQUMsS0FBSyxDQUFDLENBQUM7S0FDaEM7SUFDRCxNQUFNLElBQUksS0FBSyxDQUFDLDZCQUE2QixLQUFLLENBQUMsWUFBWSxFQUFFLENBQUMsQ0FBQztBQUN2RSxDQUFDO0FBTkQsMEJBTUM7QUFDRCxTQUFTLGNBQWMsQ0FBQyxLQUFrRDtJQUN0RSxPQUFPO1FBQ0gsSUFBSSxFQUFFO1lBQ0YsS0FBSyxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLGtCQUFrQixDQUFDLEtBQUssQ0FBQztTQUNwRDtLQUNKLENBQUM7QUFDTixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ2ZuVXRpbHNSZXNvdXJjZVR5cGUgfSBmcm9tICcuL2NvbnN0cyc7XG4vKipcbiAqIFBhcnNlcyB0aGUgdmFsdWUgb2YgXCJWYWx1ZVwiIGFuZCByZWZsZWN0cyBpdCBiYWNrIGFzIGF0dHJpYnV0ZS5cbiAqL1xuZXhwb3J0IGFzeW5jIGZ1bmN0aW9uIGhhbmRsZXIoZXZlbnQ6IEFXU0xhbWJkYS5DbG91ZEZvcm1hdGlvbkN1c3RvbVJlc291cmNlRXZlbnQpIHtcbiAgICAvLyBkaXNwYXRjaCBiYXNlZCBvbiByZXNvdXJjZSB0eXBlXG4gICAgaWYgKGV2ZW50LlJlc291cmNlVHlwZSA9PT0gQ2ZuVXRpbHNSZXNvdXJjZVR5cGUuQ0ZOX0pTT04pIHtcbiAgICAgICAgcmV0dXJuIGNmbkpzb25IYW5kbGVyKGV2ZW50KTtcbiAgICB9XG4gICAgdGhyb3cgbmV3IEVycm9yKGB1bmV4cGVjdGVkIHJlc291cmNlIHR5cGUgXCIke2V2ZW50LlJlc291cmNlVHlwZX1gKTtcbn1cbmZ1bmN0aW9uIGNmbkpzb25IYW5kbGVyKGV2ZW50OiBBV1NMYW1iZGEuQ2xvdWRGb3JtYXRpb25DdXN0b21SZXNvdXJjZUV2ZW50KSB7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgRGF0YToge1xuICAgICAgICAgICAgVmFsdWU6IEpTT04ucGFyc2UoZXZlbnQuUmVzb3VyY2VQcm9wZXJ0aWVzLlZhbHVlKSxcbiAgICAgICAgfSxcbiAgICB9O1xufVxuIl19