"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RemovalPolicy = void 0;
var RemovalPolicy;
(function (RemovalPolicy) {
    /**
     * This is the default removal policy. It means that when the resource is
     * removed from the app, it will be physically destroyed.
     */
    RemovalPolicy["DESTROY"] = "destroy";
    /**
     * This uses the 'Retain' DeletionPolicy, which will cause the resource to be retained
     * in the account, but orphaned from the stack.
     */
    RemovalPolicy["RETAIN"] = "retain";
    /**
     * This retention policy deletes the resource,
     * but saves a snapshot of its data before deleting,
     * so that it can be re-created later.
     * Only available for some stateful resources,
     * like databases, EFS volumes, etc.
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html#aws-attribute-deletionpolicy-options
     */
    RemovalPolicy["SNAPSHOT"] = "snapshot";
})(RemovalPolicy = exports.RemovalPolicy || (exports.RemovalPolicy = {}));
//# sourceMappingURL=data:application/json;base64,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