"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StackSynthesizer = void 0;
const _shared_1 = require("./_shared");
/**
 * Base class for implementing an IStackSynthesizer
 *
 * This class needs to exist to provide public surface area for external
 * implementations of stack synthesizers. The protected methods give
 * access to functions that are otherwise @_internal to the framework
 * and could not be accessed by external implementors.
 */
class StackSynthesizer {
    /**
     * Have the stack write out its template
     */
    synthesizeStackTemplate(stack, session) {
        stack._synthesizeTemplate(session);
    }
    /**
     * Write the stack artifact to the session
     *
     * Use default settings to add a CloudFormationStackArtifact artifact to
     * the given synthesis session.
     */
    emitStackArtifact(stack, session, options = {}) {
        var _a;
        _shared_1.addStackArtifactToAssembly(session, stack, options !== null && options !== void 0 ? options : {}, (_a = options.additionalDependencies) !== null && _a !== void 0 ? _a : []);
    }
}
exports.StackSynthesizer = StackSynthesizer;
//# sourceMappingURL=data:application/json;base64,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