import * as cfn from "../../../aws-cloudformation";
import * as lambda from "../../../aws-lambda";
import * as logs from "../../../aws-logs";
import { Construct as CoreConstruct, Duration } from "../../../core";
import { Construct } from 'constructs';
/**
 * Initialization properties for the `Provider` construct.
 */
export interface ProviderProps {
    /**
     * The AWS Lambda function to invoke for all resource lifecycle operations
     * (CREATE/UPDATE/DELETE).
     *
     * This function is responsible to begin the requested resource operation
     * (CREATE/UPDATE/DELETE) and return any additional properties to add to the
     * event, which will later be passed to `isComplete`. The `PhysicalResourceId`
     * property must be included in the response.
     */
    readonly onEventHandler: lambda.IFunction;
    /**
     * The AWS Lambda function to invoke in order to determine if the operation is
     * complete.
     *
     * This function will be called immediately after `onEvent` and then
     * periodically based on the configured query interval as long as it returns
     * `false`. If the function still returns `false` and the alloted timeout has
     * passed, the operation will fail.
     *
     * @default - provider is synchronous. This means that the `onEvent` handler
     * is expected to finish all lifecycle operations within the initial invocation.
     */
    readonly isCompleteHandler?: lambda.IFunction;
    /**
     * Time between calls to the `isComplete` handler which determines if the
     * resource has been stabilized.
     *
     * The first `isComplete` will be called immediately after `handler` and then
     * every `queryInterval` seconds, and until `timeout` has been reached or until
     * `isComplete` returns `true`.
     *
     * @default Duration.seconds(5)
     */
    readonly queryInterval?: Duration;
    /**
     * Total timeout for the entire operation.
     *
     * The maximum timeout is 2 hours (yes, it can exceed the AWS Lambda 15 minutes)
     *
     * @default Duration.minutes(30)
     */
    readonly totalTimeout?: Duration;
    /**
     * The number of days framework log events are kept in CloudWatch Logs. When
     * updating this property, unsetting it doesn't remove the log retention policy.
     * To remove the retention policy, set the value to `INFINITE`.
     *
     * @default logs.RetentionDays.INFINITE
     */
    readonly logRetention?: logs.RetentionDays;
}
/**
 * Defines an AWS CloudFormation custom resource provider.
 */
export declare class Provider extends CoreConstruct implements cfn.ICustomResourceProvider {
    /**
     * The user-defined AWS Lambda function which is invoked for all resource
     * lifecycle operations (CREATE/UPDATE/DELETE).
     */
    readonly onEventHandler: lambda.IFunction;
    /**
     * The user-defined AWS Lambda function which is invoked asynchronously in
     * order to determine if the operation is complete.
     */
    readonly isCompleteHandler?: lambda.IFunction;
    /**
     * The service token to use in order to define custom resources that are
     * backed by this provider.
     */
    readonly serviceToken: string;
    private readonly entrypoint;
    private readonly logRetention?;
    constructor(scope: Construct, id: string, props: ProviderProps);
    /**
     * Called by `CustomResource` which uses this provider.
     * @deprecated use `provider.serviceToken` instead
     */
    bind(_: CoreConstruct): cfn.CustomResourceProviderConfig;
    private createFunction;
}
