"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.httpRequest = exports.invokeFunction = exports.startExecution = void 0;
/* istanbul ignore file */
const https = require("https");
// eslint-disable-next-line import/no-extraneous-dependencies
const AWS = require("aws-sdk");
const FRAMEWORK_HANDLER_TIMEOUT = 900000; // 15 minutes
// In order to honor the overall maximum timeout set for the target process,
// the default 2 minutes from AWS SDK has to be overriden:
// https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/Config.html#httpOptions-property
const awsSdkConfig = {
    httpOptions: { timeout: FRAMEWORK_HANDLER_TIMEOUT },
};
async function defaultHttpRequest(options, responseBody) {
    return new Promise((resolve, reject) => {
        try {
            const request = https.request(options, resolve);
            request.on('error', reject);
            request.write(responseBody);
            request.end();
        }
        catch (e) {
            reject(e);
        }
    });
}
let sfn;
let lambda;
async function defaultStartExecution(req) {
    if (!sfn) {
        sfn = new AWS.StepFunctions(awsSdkConfig);
    }
    return sfn.startExecution(req).promise();
}
async function defaultInvokeFunction(req) {
    if (!lambda) {
        lambda = new AWS.Lambda(awsSdkConfig);
    }
    return lambda.invoke(req).promise();
}
exports.startExecution = defaultStartExecution;
exports.invokeFunction = defaultInvokeFunction;
exports.httpRequest = defaultHttpRequest;
//# sourceMappingURL=data:application/json;base64,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