"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BUNDLING_STACKS = exports.DISABLE_METADATA_STACK_TRACE = exports.DISABLE_ASSET_STAGING_CONTEXT = exports.ANALYTICS_REPORTING_ENABLED_CONTEXT = exports.PATH_METADATA_ENABLE_CONTEXT = void 0;
// --------------------------------------------------------------------------------
// This file declares context keys that are used by the CLI to control the
// behavior of CDK apps. Contrary to feature flags (which are defined under
// `features.ts`) these options are not bound to be removed in the next major
// version.
// --------------------------------------------------------------------------------
/**
 * Enables the embedding of the "aws:cdk:path" in CloudFormation template metadata.
 */
exports.PATH_METADATA_ENABLE_CONTEXT = 'aws:cdk:enable-path-metadata';
/**
 * Enable the collection and reporting of version information.
 */
exports.ANALYTICS_REPORTING_ENABLED_CONTEXT = 'aws:cdk:version-reporting';
/**
 * If this is set, asset staging is disabled. This means that assets will not be copied to
 * the output directory and will be referenced with absolute source paths.
 */
exports.DISABLE_ASSET_STAGING_CONTEXT = 'aws:cdk:disable-asset-staging';
/**
 * If this context key is set, the CDK will stage assets under the specified
 * directory. Otherwise, assets will not be staged.
 * Omits stack traces from construct metadata entries.
 */
exports.DISABLE_METADATA_STACK_TRACE = 'aws:cdk:disable-stack-trace';
/**
 * Run bundling for stacks specified in this context key
 */
exports.BUNDLING_STACKS = 'aws:cdk:bundling-stacks';
//# sourceMappingURL=data:application/json;base64,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