"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EnvironmentUtils = exports.UNKNOWN_REGION = exports.UNKNOWN_ACCOUNT = void 0;
/**
 * Parser for the artifact environment field.
 *
 * Account validation is relaxed to allow account aliasing in the future.
 */
const AWS_ENV_REGEX = /aws\:\/\/([a-z0-9A-Z\-\@\.\_]+)\/([a-z\-0-9]+)/;
exports.UNKNOWN_ACCOUNT = 'unknown-account';
exports.UNKNOWN_REGION = 'unknown-region';
class EnvironmentUtils {
    static parse(environment) {
        const env = AWS_ENV_REGEX.exec(environment);
        if (!env) {
            throw new Error(`Unable to parse environment specification "${environment}". ` +
                'Expected format: aws://account/region');
        }
        const [, account, region] = env;
        if (!account || !region) {
            throw new Error(`Invalid environment specification: ${environment}`);
        }
        return { account, region, name: environment };
    }
    /**
     * Build an environment object from an account and region
     */
    static make(account, region) {
        return { account, region, name: this.format(account, region) };
    }
    /**
     * Format an environment string from an account and region
     */
    static format(account, region) {
        return `aws://${account}/${region}`;
    }
}
exports.EnvironmentUtils = EnvironmentUtils;
//# sourceMappingURL=data:application/json;base64,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