"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.futureFlagDefault = exports.FUTURE_FLAGS = exports.STACK_RELATIVE_EXPORTS_CONTEXT = exports.NEW_STYLE_STACK_SYNTHESIS_CONTEXT = exports.ENABLE_DIFF_NO_FAIL = exports.ENABLE_DIFF_NO_FAIL_CONTEXT = exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT = void 0;
// --------------------------------------------------------------------------------
// This file defines context keys that enable certain features that are
// implemented behind a flag in order to preserve backwards compatibility for
// existing apps. When a new app is initialized through `cdk init`, the CLI will
// automatically add enable these features by adding them to the generated
// `cdk.json` file. In the next major release of the CDK, these feature flags
// will be removed and will become the default behavior.
// See https://github.com/aws/aws-cdk-rfcs/blob/master/text/0055-feature-flags.md
// --------------------------------------------------------------------------------
/**
 * If this is set, multiple stacks can use the same stack name (e.g. deployed to
 * different environments). This means that the name of the synthesized template
 * file will be based on the construct path and not on the defined `stackName`
 * of the stack.
 *
 * This is a "future flag": the feature is disabled by default for backwards
 * compatibility, but new projects created using `cdk init` will have this
 * enabled through the generated `cdk.json`.
 */
exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT = '@aws-cdk/core:enableStackNameDuplicates';
/**
 * IF this is set, `cdk diff` will always exit with 0.
 *
 * Use `cdk diff --fail` to exit with 1 if there's a diff.
 */
exports.ENABLE_DIFF_NO_FAIL_CONTEXT = 'aws-cdk:enableDiffNoFail';
/** @deprecated use `ENABLE_DIFF_NO_FAIL_CONTEXT` */
exports.ENABLE_DIFF_NO_FAIL = exports.ENABLE_DIFF_NO_FAIL_CONTEXT;
/**
 * Switch to new stack synthesis method which enable CI/CD
 */
exports.NEW_STYLE_STACK_SYNTHESIS_CONTEXT = '@aws-cdk/core:newStyleStackSynthesis';
/**
 * Name exports based on the construct paths relative to the stack, rather than the global construct path
 *
 * Combined with the stack name this relative construct path is good enough to
 * ensure uniqueness, and makes the export names robust against refactoring
 * the location of the stack in the construct tree (specifically, moving the Stack
 * into a Stage).
 */
exports.STACK_RELATIVE_EXPORTS_CONTEXT = '@aws-cdk/core:stackRelativeExports';
/**
 * This map includes context keys and values for feature flags that enable
 * capabilities "from the future", which we could not introduce as the default
 * behavior due to backwards compatibility for existing projects.
 *
 * New projects generated through `cdk init` will include these flags in their
 * generated `cdk.json` file.
 *
 * When we release the next major version of the CDK, we will flip the logic of
 * these features and clean up the `cdk.json` generated by `cdk init`.
 *
 * Tests must cover the default (disabled) case and the future (enabled) case.
 */
exports.FUTURE_FLAGS = {
    [exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT]: 'true',
    [exports.ENABLE_DIFF_NO_FAIL_CONTEXT]: 'true',
    [exports.STACK_RELATIVE_EXPORTS_CONTEXT]: 'true',
};
/**
 * The set of defaults that should be applied if the feature flag is not
 * explicitly configured.
 */
const FUTURE_FLAGS_DEFAULTS = {
    [exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT]: false,
    [exports.ENABLE_DIFF_NO_FAIL_CONTEXT]: false,
    [exports.STACK_RELATIVE_EXPORTS_CONTEXT]: false,
    [exports.NEW_STYLE_STACK_SYNTHESIS_CONTEXT]: false,
};
function futureFlagDefault(flag) {
    return FUTURE_FLAGS_DEFAULTS[flag];
}
exports.futureFlagDefault = futureFlagDefault;
//# sourceMappingURL=data:application/json;base64,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