"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Files = void 0;
const s3assets = require("../../../aws-s3-assets"); // Automatically re-written from '@aws-cdk/aws-s3-assets'
/**
 * Additional files to use in a shell script
 */
class Files {
    /**
     * Use the files from a CodePipeline artifact
     */
    static fromArtifact(artifact) {
        if (!artifact) {
            // Typechecking may mess up
            throw new Error('Files.fromArtifact(): input artifact is required, got undefined');
        }
        return {
            bind: () => ({ artifact }),
            grantRead: () => { },
        };
    }
    /**
     * Create a new asset to bundle up the files in a directory on disk
     */
    static fromDirectory(directoryPath) {
        let realFiles;
        return {
            bind(scope) {
                realFiles = Files.fromAsset(new s3assets.Asset(scope, directoryPath, {
                    path: directoryPath,
                }));
                return realFiles.bind(scope);
            },
            grantRead(grantee) {
                if (!realFiles) {
                    throw new Error('bind() must be called first');
                }
                realFiles.grantRead(grantee);
            },
        };
    }
    /**
     * Use an existing asset as a file source
     */
    static fromAsset(asset) {
        return {
            bind: () => ({
                commands: [
                    `echo "Downloading additional files from ${asset.s3ObjectUrl}"`,
                    `aws s3 cp ${asset.s3ObjectUrl} /tmp/dl.zip`,
                    'unzip /tmp/dl.zip -d .',
                ],
            }),
            grantRead: (grantee) => asset.grantRead(grantee),
        };
    }
    constructor() {
    }
}
exports.Files = Files;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiX2ZpbGVzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiX2ZpbGVzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUVBLG1EQUFtRCxDQUFDLHlEQUF5RDtBQUU3Rzs7R0FFRztBQUNILE1BQXNCLEtBQUs7SUFDdkI7O09BRUc7SUFDSSxNQUFNLENBQUMsWUFBWSxDQUFDLFFBQStCO1FBQ3RELElBQUksQ0FBQyxRQUFRLEVBQUU7WUFDWCwyQkFBMkI7WUFDM0IsTUFBTSxJQUFJLEtBQUssQ0FBQyxpRUFBaUUsQ0FBQyxDQUFDO1NBQ3RGO1FBQ0QsT0FBTztZQUNILElBQUksRUFBRSxHQUFHLEVBQUUsQ0FBQyxDQUFDLEVBQUUsUUFBUSxFQUFFLENBQUM7WUFDMUIsU0FBUyxFQUFFLEdBQUcsRUFBRSxHQUFHLENBQUM7U0FDdkIsQ0FBQztJQUNOLENBQUM7SUFDRDs7T0FFRztJQUNJLE1BQU0sQ0FBQyxhQUFhLENBQUMsYUFBcUI7UUFDN0MsSUFBSSxTQUFnQixDQUFDO1FBQ3JCLE9BQU87WUFDSCxJQUFJLENBQUMsS0FBZ0I7Z0JBQ2pCLFNBQVMsR0FBRyxLQUFLLENBQUMsU0FBUyxDQUFDLElBQUksUUFBUSxDQUFDLEtBQUssQ0FBQyxLQUFLLEVBQUUsYUFBYSxFQUFFO29CQUNqRSxJQUFJLEVBQUUsYUFBYTtpQkFDdEIsQ0FBQyxDQUFDLENBQUM7Z0JBQ0osT0FBTyxTQUFTLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO1lBQ2pDLENBQUM7WUFDRCxTQUFTLENBQUMsT0FBbUI7Z0JBQ3pCLElBQUksQ0FBQyxTQUFTLEVBQUU7b0JBQ1osTUFBTSxJQUFJLEtBQUssQ0FBQyw2QkFBNkIsQ0FBQyxDQUFDO2lCQUNsRDtnQkFDRCxTQUFTLENBQUMsU0FBUyxDQUFDLE9BQU8sQ0FBQyxDQUFDO1lBQ2pDLENBQUM7U0FDSixDQUFDO0lBQ04sQ0FBQztJQUNEOztPQUVHO0lBQ0ksTUFBTSxDQUFDLFNBQVMsQ0FBQyxLQUFxQjtRQUN6QyxPQUFPO1lBQ0gsSUFBSSxFQUFFLEdBQUcsRUFBRSxDQUFDLENBQUM7Z0JBQ1QsUUFBUSxFQUFFO29CQUNOLDJDQUEyQyxLQUFLLENBQUMsV0FBVyxHQUFHO29CQUMvRCxhQUFhLEtBQUssQ0FBQyxXQUFXLGNBQWM7b0JBQzVDLHdCQUF3QjtpQkFDM0I7YUFDSixDQUFDO1lBQ0YsU0FBUyxFQUFFLENBQUMsT0FBTyxFQUFFLEVBQUUsQ0FBQyxLQUFLLENBQUMsU0FBUyxDQUFDLE9BQU8sQ0FBQztTQUNuRCxDQUFDO0lBQ04sQ0FBQztJQUNEO0lBQ0EsQ0FBQztDQVdKO0FBN0RELHNCQTZEQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNvZGVwaXBlbGluZSBmcm9tIFwiLi4vLi4vLi4vYXdzLWNvZGVwaXBlbGluZVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLWNvZGVwaXBlbGluZSdcbmltcG9ydCB7IElHcmFudGFibGUgfSBmcm9tIFwiLi4vLi4vLi4vYXdzLWlhbVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLWlhbSdcbmltcG9ydCAqIGFzIHMzYXNzZXRzIGZyb20gXCIuLi8uLi8uLi9hd3MtczMtYXNzZXRzXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3MtczMtYXNzZXRzJ1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSBcIi4uLy4uLy4uL2NvcmVcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2NvcmUnXG4vKipcbiAqIEFkZGl0aW9uYWwgZmlsZXMgdG8gdXNlIGluIGEgc2hlbGwgc2NyaXB0XG4gKi9cbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBGaWxlcyB7XG4gICAgLyoqXG4gICAgICogVXNlIHRoZSBmaWxlcyBmcm9tIGEgQ29kZVBpcGVsaW5lIGFydGlmYWN0XG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyBmcm9tQXJ0aWZhY3QoYXJ0aWZhY3Q6IGNvZGVwaXBlbGluZS5BcnRpZmFjdCk6IEZpbGVzIHtcbiAgICAgICAgaWYgKCFhcnRpZmFjdCkge1xuICAgICAgICAgICAgLy8gVHlwZWNoZWNraW5nIG1heSBtZXNzIHVwXG4gICAgICAgICAgICB0aHJvdyBuZXcgRXJyb3IoJ0ZpbGVzLmZyb21BcnRpZmFjdCgpOiBpbnB1dCBhcnRpZmFjdCBpcyByZXF1aXJlZCwgZ290IHVuZGVmaW5lZCcpO1xuICAgICAgICB9XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBiaW5kOiAoKSA9PiAoeyBhcnRpZmFjdCB9KSxcbiAgICAgICAgICAgIGdyYW50UmVhZDogKCkgPT4geyB9LFxuICAgICAgICB9O1xuICAgIH1cbiAgICAvKipcbiAgICAgKiBDcmVhdGUgYSBuZXcgYXNzZXQgdG8gYnVuZGxlIHVwIHRoZSBmaWxlcyBpbiBhIGRpcmVjdG9yeSBvbiBkaXNrXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyBmcm9tRGlyZWN0b3J5KGRpcmVjdG9yeVBhdGg6IHN0cmluZyk6IEZpbGVzIHtcbiAgICAgICAgbGV0IHJlYWxGaWxlczogRmlsZXM7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBiaW5kKHNjb3BlOiBDb25zdHJ1Y3QpIHtcbiAgICAgICAgICAgICAgICByZWFsRmlsZXMgPSBGaWxlcy5mcm9tQXNzZXQobmV3IHMzYXNzZXRzLkFzc2V0KHNjb3BlLCBkaXJlY3RvcnlQYXRoLCB7XG4gICAgICAgICAgICAgICAgICAgIHBhdGg6IGRpcmVjdG9yeVBhdGgsXG4gICAgICAgICAgICAgICAgfSkpO1xuICAgICAgICAgICAgICAgIHJldHVybiByZWFsRmlsZXMuYmluZChzY29wZSk7XG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgZ3JhbnRSZWFkKGdyYW50ZWU6IElHcmFudGFibGUpIHtcbiAgICAgICAgICAgICAgICBpZiAoIXJlYWxGaWxlcykge1xuICAgICAgICAgICAgICAgICAgICB0aHJvdyBuZXcgRXJyb3IoJ2JpbmQoKSBtdXN0IGJlIGNhbGxlZCBmaXJzdCcpO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICByZWFsRmlsZXMuZ3JhbnRSZWFkKGdyYW50ZWUpO1xuICAgICAgICAgICAgfSxcbiAgICAgICAgfTtcbiAgICB9XG4gICAgLyoqXG4gICAgICogVXNlIGFuIGV4aXN0aW5nIGFzc2V0IGFzIGEgZmlsZSBzb3VyY2VcbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIGZyb21Bc3NldChhc3NldDogczNhc3NldHMuQXNzZXQpOiBGaWxlcyB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBiaW5kOiAoKSA9PiAoe1xuICAgICAgICAgICAgICAgIGNvbW1hbmRzOiBbXG4gICAgICAgICAgICAgICAgICAgIGBlY2hvIFwiRG93bmxvYWRpbmcgYWRkaXRpb25hbCBmaWxlcyBmcm9tICR7YXNzZXQuczNPYmplY3RVcmx9XCJgLFxuICAgICAgICAgICAgICAgICAgICBgYXdzIHMzIGNwICR7YXNzZXQuczNPYmplY3RVcmx9IC90bXAvZGwuemlwYCxcbiAgICAgICAgICAgICAgICAgICAgJ3VuemlwIC90bXAvZGwuemlwIC1kIC4nLFxuICAgICAgICAgICAgICAgIF0sXG4gICAgICAgICAgICB9KSxcbiAgICAgICAgICAgIGdyYW50UmVhZDogKGdyYW50ZWUpID0+IGFzc2V0LmdyYW50UmVhZChncmFudGVlKSxcbiAgICAgICAgfTtcbiAgICB9XG4gICAgcHJvdGVjdGVkIGNvbnN0cnVjdG9yKCkge1xuICAgIH1cbiAgICAvKipcbiAgICAgKiBCaW5kIHRoZSBGaWxlcyB0byBhIHVzYWdlIGxvY2F0aW9uXG4gICAgICovXG4gICAgcHVibGljIGFic3RyYWN0IGJpbmQoc2NvcGU6IENvbnN0cnVjdCk6IEZpbGVzQ29uZmlnO1xuICAgIC8qKlxuICAgICAqIEdyYW50IHJlYWQgcGVybWlzc2lvbnMgdG8gdGhlIGZpbGUgc2V0IHRvIHRoZSBnaXZlbiBncmFudGFibGVcbiAgICAgKlxuICAgICAqIE11c3QgYmUgY2FsbGVkIGFmdGVyIGJpbmQoKS5cbiAgICAgKi9cbiAgICBwdWJsaWMgYWJzdHJhY3QgZ3JhbnRSZWFkKGdyYW50ZWU6IElHcmFudGFibGUpOiB2b2lkO1xufVxuLyoqXG4gKiBDb25maWcgZm9yIGEgRmlsZXMgc291cmNlXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgRmlsZXNDb25maWcge1xuICAgIC8qKlxuICAgICAqIENvZGVQaXBlbGluZSBhcnRpZmFjdCB0byBhZGQgdG8gdGhlIHNldCBvZiBpbnB1dCBhcnRpZmFjdHMgZm9yIHRoZSBwcm9qZWN0XG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCAtIE5vIGFydGlmYWN0XG4gICAgICovXG4gICAgcmVhZG9ubHkgYXJ0aWZhY3Q/OiBjb2RlcGlwZWxpbmUuQXJ0aWZhY3Q7XG4gICAgLyoqXG4gICAgICogQ29tbWFuZHMgdG8gYWRkIHRvIHRoZSBzZXQgb2YgY29tbWFuZHMgZm9yIHRoZSBwcm9qZWN0XG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCAtIE5vIGNvbW1hbmRzXG4gICAgICovXG4gICAgcmVhZG9ubHkgY29tbWFuZHM/OiBzdHJpbmdbXTtcbn1cbiJdfQ==