"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnPolicy = exports.CfnNotificationChannel = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2023-02-21T18:30:08.546Z","fingerprint":"qgZL/ArFvz73IWSp7WNWvpgWr6jBnB9GNRRgzRz5UQw="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("@aws-cdk/core");
const cfn_parse = require("@aws-cdk/core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnNotificationChannelProps`
 *
 * @param properties - the TypeScript properties of a `CfnNotificationChannelProps`
 *
 * @returns the result of the validation.
 */
function CfnNotificationChannelPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('snsRoleName', cdk.requiredValidator)(properties.snsRoleName));
    errors.collect(cdk.propertyValidator('snsRoleName', cdk.validateString)(properties.snsRoleName));
    errors.collect(cdk.propertyValidator('snsTopicArn', cdk.requiredValidator)(properties.snsTopicArn));
    errors.collect(cdk.propertyValidator('snsTopicArn', cdk.validateString)(properties.snsTopicArn));
    return errors.wrap('supplied properties not correct for "CfnNotificationChannelProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::NotificationChannel` resource
 *
 * @param properties - the TypeScript properties of a `CfnNotificationChannelProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::NotificationChannel` resource.
 */
// @ts-ignore TS6133
function cfnNotificationChannelPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnNotificationChannelPropsValidator(properties).assertSuccess();
    return {
        SnsRoleName: cdk.stringToCloudFormation(properties.snsRoleName),
        SnsTopicArn: cdk.stringToCloudFormation(properties.snsTopicArn),
    };
}
// @ts-ignore TS6133
function CfnNotificationChannelPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('snsRoleName', 'SnsRoleName', cfn_parse.FromCloudFormation.getString(properties.SnsRoleName));
    ret.addPropertyResult('snsTopicArn', 'SnsTopicArn', cfn_parse.FromCloudFormation.getString(properties.SnsTopicArn));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::FMS::NotificationChannel`
 *
 * Designates the IAM role and Amazon Simple Notification Service (SNS) topic to use to record SNS logs.
 *
 * To perform this action outside of the console, you must configure the SNS topic to allow the role `AWSServiceRoleForFMS` to publish SNS logs. For more information, see [Firewall Manager required permissions for API actions](https://docs.aws.amazon.com/waf/latest/developerguide/fms-api-permissions-ref.html) in the *AWS Firewall Manager Developer Guide* .
 *
 * @cloudformationResource AWS::FMS::NotificationChannel
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-notificationchannel.html
 */
class CfnNotificationChannel extends cdk.CfnResource {
    /**
     * Create a new `AWS::FMS::NotificationChannel`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnNotificationChannel.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_fms_CfnNotificationChannelProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnNotificationChannel);
            }
            throw error;
        }
        cdk.requireProperty(props, 'snsRoleName', this);
        cdk.requireProperty(props, 'snsTopicArn', this);
        this.snsRoleName = props.snsRoleName;
        this.snsTopicArn = props.snsTopicArn;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnNotificationChannelPropsFromCloudFormation(resourceProperties);
        const ret = new CfnNotificationChannel(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnNotificationChannel.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            snsRoleName: this.snsRoleName,
            snsTopicArn: this.snsTopicArn,
        };
    }
    renderProperties(props) {
        return cfnNotificationChannelPropsToCloudFormation(props);
    }
}
exports.CfnNotificationChannel = CfnNotificationChannel;
_a = JSII_RTTI_SYMBOL_1;
CfnNotificationChannel[_a] = { fqn: "@aws-cdk/aws-fms.CfnNotificationChannel", version: "1.194.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnNotificationChannel.CFN_RESOURCE_TYPE_NAME = "AWS::FMS::NotificationChannel";
/**
 * Determine whether the given properties match those of a `CfnPolicyProps`
 *
 * @param properties - the TypeScript properties of a `CfnPolicyProps`
 *
 * @returns the result of the validation.
 */
function CfnPolicyPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('deleteAllPolicyResources', cdk.validateBoolean)(properties.deleteAllPolicyResources));
    errors.collect(cdk.propertyValidator('excludeMap', CfnPolicy_IEMapPropertyValidator)(properties.excludeMap));
    errors.collect(cdk.propertyValidator('excludeResourceTags', cdk.requiredValidator)(properties.excludeResourceTags));
    errors.collect(cdk.propertyValidator('excludeResourceTags', cdk.validateBoolean)(properties.excludeResourceTags));
    errors.collect(cdk.propertyValidator('includeMap', CfnPolicy_IEMapPropertyValidator)(properties.includeMap));
    errors.collect(cdk.propertyValidator('policyDescription', cdk.validateString)(properties.policyDescription));
    errors.collect(cdk.propertyValidator('policyName', cdk.requiredValidator)(properties.policyName));
    errors.collect(cdk.propertyValidator('policyName', cdk.validateString)(properties.policyName));
    errors.collect(cdk.propertyValidator('remediationEnabled', cdk.requiredValidator)(properties.remediationEnabled));
    errors.collect(cdk.propertyValidator('remediationEnabled', cdk.validateBoolean)(properties.remediationEnabled));
    errors.collect(cdk.propertyValidator('resourceSetIds', cdk.listValidator(cdk.validateString))(properties.resourceSetIds));
    errors.collect(cdk.propertyValidator('resourceTags', cdk.listValidator(CfnPolicy_ResourceTagPropertyValidator))(properties.resourceTags));
    errors.collect(cdk.propertyValidator('resourceType', cdk.validateString)(properties.resourceType));
    errors.collect(cdk.propertyValidator('resourceTypeList', cdk.listValidator(cdk.validateString))(properties.resourceTypeList));
    errors.collect(cdk.propertyValidator('resourcesCleanUp', cdk.validateBoolean)(properties.resourcesCleanUp));
    errors.collect(cdk.propertyValidator('securityServicePolicyData', cdk.requiredValidator)(properties.securityServicePolicyData));
    errors.collect(cdk.propertyValidator('securityServicePolicyData', CfnPolicy_SecurityServicePolicyDataPropertyValidator)(properties.securityServicePolicyData));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(CfnPolicy_PolicyTagPropertyValidator))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnPolicyProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy` resource
 *
 * @param properties - the TypeScript properties of a `CfnPolicyProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy` resource.
 */
// @ts-ignore TS6133
function cfnPolicyPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicyPropsValidator(properties).assertSuccess();
    return {
        ExcludeResourceTags: cdk.booleanToCloudFormation(properties.excludeResourceTags),
        PolicyName: cdk.stringToCloudFormation(properties.policyName),
        RemediationEnabled: cdk.booleanToCloudFormation(properties.remediationEnabled),
        SecurityServicePolicyData: cfnPolicySecurityServicePolicyDataPropertyToCloudFormation(properties.securityServicePolicyData),
        DeleteAllPolicyResources: cdk.booleanToCloudFormation(properties.deleteAllPolicyResources),
        ExcludeMap: cfnPolicyIEMapPropertyToCloudFormation(properties.excludeMap),
        IncludeMap: cfnPolicyIEMapPropertyToCloudFormation(properties.includeMap),
        PolicyDescription: cdk.stringToCloudFormation(properties.policyDescription),
        ResourcesCleanUp: cdk.booleanToCloudFormation(properties.resourcesCleanUp),
        ResourceSetIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.resourceSetIds),
        ResourceTags: cdk.listMapper(cfnPolicyResourceTagPropertyToCloudFormation)(properties.resourceTags),
        ResourceType: cdk.stringToCloudFormation(properties.resourceType),
        ResourceTypeList: cdk.listMapper(cdk.stringToCloudFormation)(properties.resourceTypeList),
        Tags: cdk.listMapper(cfnPolicyPolicyTagPropertyToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnPolicyPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('excludeResourceTags', 'ExcludeResourceTags', cfn_parse.FromCloudFormation.getBoolean(properties.ExcludeResourceTags));
    ret.addPropertyResult('policyName', 'PolicyName', cfn_parse.FromCloudFormation.getString(properties.PolicyName));
    ret.addPropertyResult('remediationEnabled', 'RemediationEnabled', cfn_parse.FromCloudFormation.getBoolean(properties.RemediationEnabled));
    ret.addPropertyResult('securityServicePolicyData', 'SecurityServicePolicyData', CfnPolicySecurityServicePolicyDataPropertyFromCloudFormation(properties.SecurityServicePolicyData));
    ret.addPropertyResult('deleteAllPolicyResources', 'DeleteAllPolicyResources', properties.DeleteAllPolicyResources != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DeleteAllPolicyResources) : undefined);
    ret.addPropertyResult('excludeMap', 'ExcludeMap', properties.ExcludeMap != null ? CfnPolicyIEMapPropertyFromCloudFormation(properties.ExcludeMap) : undefined);
    ret.addPropertyResult('includeMap', 'IncludeMap', properties.IncludeMap != null ? CfnPolicyIEMapPropertyFromCloudFormation(properties.IncludeMap) : undefined);
    ret.addPropertyResult('policyDescription', 'PolicyDescription', properties.PolicyDescription != null ? cfn_parse.FromCloudFormation.getString(properties.PolicyDescription) : undefined);
    ret.addPropertyResult('resourcesCleanUp', 'ResourcesCleanUp', properties.ResourcesCleanUp != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ResourcesCleanUp) : undefined);
    ret.addPropertyResult('resourceSetIds', 'ResourceSetIds', properties.ResourceSetIds != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ResourceSetIds) : undefined);
    ret.addPropertyResult('resourceTags', 'ResourceTags', properties.ResourceTags != null ? cfn_parse.FromCloudFormation.getArray(CfnPolicyResourceTagPropertyFromCloudFormation)(properties.ResourceTags) : undefined);
    ret.addPropertyResult('resourceType', 'ResourceType', properties.ResourceType != null ? cfn_parse.FromCloudFormation.getString(properties.ResourceType) : undefined);
    ret.addPropertyResult('resourceTypeList', 'ResourceTypeList', properties.ResourceTypeList != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ResourceTypeList) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(CfnPolicyPolicyTagPropertyFromCloudFormation)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::FMS::Policy`
 *
 * An AWS Firewall Manager policy.
 *
 * Firewall Manager provides the following types of policies:
 *
 * - An AWS Shield Advanced policy, which applies Shield Advanced protection to specified accounts and resources.
 * - An AWS WAF policy (type WAFV2), which defines rule groups to run first in the corresponding AWS WAF web ACL and rule groups to run last in the web ACL.
 * - An AWS WAF Classic policy, which defines a rule group. AWS WAF Classic doesn't support rule groups in Amazon CloudFront , so, to create AWS WAF Classic policies through CloudFront , you first need to create your rule groups outside of CloudFront .
 * - A security group policy, which manages VPC security groups across your AWS organization.
 * - An AWS Network Firewall policy, which provides firewall rules to filter network traffic in specified Amazon VPCs.
 * - A DNS Firewall policy, which provides Amazon Route 53 Resolver DNS Firewall rules to filter DNS queries for specified Amazon VPCs.
 * - A third-party firewall policy, which manages a third-party firewall service such as the Palo Alto Networks Cloud Next-Generation Firewall.
 *
 * Each policy is specific to one of the types. If you want to enforce more than one policy type across accounts, create multiple policies. You can create multiple policies for each type.
 *
 * These policies require some setup to use. For more information, see the sections on prerequisites and getting started under [AWS Firewall Manager](https://docs.aws.amazon.com/waf/latest/developerguide/fms-prereq.html) .
 *
 * @cloudformationResource AWS::FMS::Policy
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html
 */
class CfnPolicy extends cdk.CfnResource {
    /**
     * Create a new `AWS::FMS::Policy`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnPolicy.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_fms_CfnPolicyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnPolicy);
            }
            throw error;
        }
        cdk.requireProperty(props, 'excludeResourceTags', this);
        cdk.requireProperty(props, 'policyName', this);
        cdk.requireProperty(props, 'remediationEnabled', this);
        cdk.requireProperty(props, 'securityServicePolicyData', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.excludeResourceTags = props.excludeResourceTags;
        this.policyName = props.policyName;
        this.remediationEnabled = props.remediationEnabled;
        this.securityServicePolicyData = props.securityServicePolicyData;
        this.deleteAllPolicyResources = props.deleteAllPolicyResources;
        this.excludeMap = props.excludeMap;
        this.includeMap = props.includeMap;
        this.policyDescription = props.policyDescription;
        this.resourcesCleanUp = props.resourcesCleanUp;
        this.resourceSetIds = props.resourceSetIds;
        this.resourceTags = props.resourceTags;
        this.resourceType = props.resourceType;
        this.resourceTypeList = props.resourceTypeList;
        this.tags = props.tags;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnPolicyPropsFromCloudFormation(resourceProperties);
        const ret = new CfnPolicy(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnPolicy.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            excludeResourceTags: this.excludeResourceTags,
            policyName: this.policyName,
            remediationEnabled: this.remediationEnabled,
            securityServicePolicyData: this.securityServicePolicyData,
            deleteAllPolicyResources: this.deleteAllPolicyResources,
            excludeMap: this.excludeMap,
            includeMap: this.includeMap,
            policyDescription: this.policyDescription,
            resourcesCleanUp: this.resourcesCleanUp,
            resourceSetIds: this.resourceSetIds,
            resourceTags: this.resourceTags,
            resourceType: this.resourceType,
            resourceTypeList: this.resourceTypeList,
            tags: this.tags,
        };
    }
    renderProperties(props) {
        return cfnPolicyPropsToCloudFormation(props);
    }
}
exports.CfnPolicy = CfnPolicy;
_b = JSII_RTTI_SYMBOL_1;
CfnPolicy[_b] = { fqn: "@aws-cdk/aws-fms.CfnPolicy", version: "1.194.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnPolicy.CFN_RESOURCE_TYPE_NAME = "AWS::FMS::Policy";
/**
 * Determine whether the given properties match those of a `IEMapProperty`
 *
 * @param properties - the TypeScript properties of a `IEMapProperty`
 *
 * @returns the result of the validation.
 */
function CfnPolicy_IEMapPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('account', cdk.listValidator(cdk.validateString))(properties.account));
    errors.collect(cdk.propertyValidator('orgunit', cdk.listValidator(cdk.validateString))(properties.orgunit));
    return errors.wrap('supplied properties not correct for "IEMapProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy.IEMap` resource
 *
 * @param properties - the TypeScript properties of a `IEMapProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy.IEMap` resource.
 */
// @ts-ignore TS6133
function cfnPolicyIEMapPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicy_IEMapPropertyValidator(properties).assertSuccess();
    return {
        ACCOUNT: cdk.listMapper(cdk.stringToCloudFormation)(properties.account),
        ORGUNIT: cdk.listMapper(cdk.stringToCloudFormation)(properties.orgunit),
    };
}
// @ts-ignore TS6133
function CfnPolicyIEMapPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('account', 'ACCOUNT', properties.ACCOUNT != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ACCOUNT) : undefined);
    ret.addPropertyResult('orgunit', 'ORGUNIT', properties.ORGUNIT != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ORGUNIT) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NetworkFirewallPolicyProperty`
 *
 * @param properties - the TypeScript properties of a `NetworkFirewallPolicyProperty`
 *
 * @returns the result of the validation.
 */
function CfnPolicy_NetworkFirewallPolicyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('firewallDeploymentModel', cdk.requiredValidator)(properties.firewallDeploymentModel));
    errors.collect(cdk.propertyValidator('firewallDeploymentModel', cdk.validateString)(properties.firewallDeploymentModel));
    return errors.wrap('supplied properties not correct for "NetworkFirewallPolicyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy.NetworkFirewallPolicy` resource
 *
 * @param properties - the TypeScript properties of a `NetworkFirewallPolicyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy.NetworkFirewallPolicy` resource.
 */
// @ts-ignore TS6133
function cfnPolicyNetworkFirewallPolicyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicy_NetworkFirewallPolicyPropertyValidator(properties).assertSuccess();
    return {
        FirewallDeploymentModel: cdk.stringToCloudFormation(properties.firewallDeploymentModel),
    };
}
// @ts-ignore TS6133
function CfnPolicyNetworkFirewallPolicyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('firewallDeploymentModel', 'FirewallDeploymentModel', cfn_parse.FromCloudFormation.getString(properties.FirewallDeploymentModel));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PolicyOptionProperty`
 *
 * @param properties - the TypeScript properties of a `PolicyOptionProperty`
 *
 * @returns the result of the validation.
 */
function CfnPolicy_PolicyOptionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('networkFirewallPolicy', CfnPolicy_NetworkFirewallPolicyPropertyValidator)(properties.networkFirewallPolicy));
    errors.collect(cdk.propertyValidator('thirdPartyFirewallPolicy', CfnPolicy_ThirdPartyFirewallPolicyPropertyValidator)(properties.thirdPartyFirewallPolicy));
    return errors.wrap('supplied properties not correct for "PolicyOptionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy.PolicyOption` resource
 *
 * @param properties - the TypeScript properties of a `PolicyOptionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy.PolicyOption` resource.
 */
// @ts-ignore TS6133
function cfnPolicyPolicyOptionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicy_PolicyOptionPropertyValidator(properties).assertSuccess();
    return {
        NetworkFirewallPolicy: cfnPolicyNetworkFirewallPolicyPropertyToCloudFormation(properties.networkFirewallPolicy),
        ThirdPartyFirewallPolicy: cfnPolicyThirdPartyFirewallPolicyPropertyToCloudFormation(properties.thirdPartyFirewallPolicy),
    };
}
// @ts-ignore TS6133
function CfnPolicyPolicyOptionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('networkFirewallPolicy', 'NetworkFirewallPolicy', properties.NetworkFirewallPolicy != null ? CfnPolicyNetworkFirewallPolicyPropertyFromCloudFormation(properties.NetworkFirewallPolicy) : undefined);
    ret.addPropertyResult('thirdPartyFirewallPolicy', 'ThirdPartyFirewallPolicy', properties.ThirdPartyFirewallPolicy != null ? CfnPolicyThirdPartyFirewallPolicyPropertyFromCloudFormation(properties.ThirdPartyFirewallPolicy) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PolicyTagProperty`
 *
 * @param properties - the TypeScript properties of a `PolicyTagProperty`
 *
 * @returns the result of the validation.
 */
function CfnPolicy_PolicyTagPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('key', cdk.requiredValidator)(properties.key));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('value', cdk.requiredValidator)(properties.value));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "PolicyTagProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy.PolicyTag` resource
 *
 * @param properties - the TypeScript properties of a `PolicyTagProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy.PolicyTag` resource.
 */
// @ts-ignore TS6133
function cfnPolicyPolicyTagPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicy_PolicyTagPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnPolicyPolicyTagPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('key', 'Key', cfn_parse.FromCloudFormation.getString(properties.Key));
    ret.addPropertyResult('value', 'Value', cfn_parse.FromCloudFormation.getString(properties.Value));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ResourceTagProperty`
 *
 * @param properties - the TypeScript properties of a `ResourceTagProperty`
 *
 * @returns the result of the validation.
 */
function CfnPolicy_ResourceTagPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('key', cdk.requiredValidator)(properties.key));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "ResourceTagProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy.ResourceTag` resource
 *
 * @param properties - the TypeScript properties of a `ResourceTagProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy.ResourceTag` resource.
 */
// @ts-ignore TS6133
function cfnPolicyResourceTagPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicy_ResourceTagPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnPolicyResourceTagPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('key', 'Key', cfn_parse.FromCloudFormation.getString(properties.Key));
    ret.addPropertyResult('value', 'Value', properties.Value != null ? cfn_parse.FromCloudFormation.getString(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `SecurityServicePolicyDataProperty`
 *
 * @param properties - the TypeScript properties of a `SecurityServicePolicyDataProperty`
 *
 * @returns the result of the validation.
 */
function CfnPolicy_SecurityServicePolicyDataPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('managedServiceData', cdk.validateString)(properties.managedServiceData));
    errors.collect(cdk.propertyValidator('policyOption', CfnPolicy_PolicyOptionPropertyValidator)(properties.policyOption));
    errors.collect(cdk.propertyValidator('type', cdk.requiredValidator)(properties.type));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    return errors.wrap('supplied properties not correct for "SecurityServicePolicyDataProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy.SecurityServicePolicyData` resource
 *
 * @param properties - the TypeScript properties of a `SecurityServicePolicyDataProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy.SecurityServicePolicyData` resource.
 */
// @ts-ignore TS6133
function cfnPolicySecurityServicePolicyDataPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicy_SecurityServicePolicyDataPropertyValidator(properties).assertSuccess();
    return {
        ManagedServiceData: cdk.stringToCloudFormation(properties.managedServiceData),
        PolicyOption: cfnPolicyPolicyOptionPropertyToCloudFormation(properties.policyOption),
        Type: cdk.stringToCloudFormation(properties.type),
    };
}
// @ts-ignore TS6133
function CfnPolicySecurityServicePolicyDataPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('managedServiceData', 'ManagedServiceData', properties.ManagedServiceData != null ? cfn_parse.FromCloudFormation.getString(properties.ManagedServiceData) : undefined);
    ret.addPropertyResult('policyOption', 'PolicyOption', properties.PolicyOption != null ? CfnPolicyPolicyOptionPropertyFromCloudFormation(properties.PolicyOption) : undefined);
    ret.addPropertyResult('type', 'Type', cfn_parse.FromCloudFormation.getString(properties.Type));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ThirdPartyFirewallPolicyProperty`
 *
 * @param properties - the TypeScript properties of a `ThirdPartyFirewallPolicyProperty`
 *
 * @returns the result of the validation.
 */
function CfnPolicy_ThirdPartyFirewallPolicyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('firewallDeploymentModel', cdk.requiredValidator)(properties.firewallDeploymentModel));
    errors.collect(cdk.propertyValidator('firewallDeploymentModel', cdk.validateString)(properties.firewallDeploymentModel));
    return errors.wrap('supplied properties not correct for "ThirdPartyFirewallPolicyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy.ThirdPartyFirewallPolicy` resource
 *
 * @param properties - the TypeScript properties of a `ThirdPartyFirewallPolicyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy.ThirdPartyFirewallPolicy` resource.
 */
// @ts-ignore TS6133
function cfnPolicyThirdPartyFirewallPolicyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicy_ThirdPartyFirewallPolicyPropertyValidator(properties).assertSuccess();
    return {
        FirewallDeploymentModel: cdk.stringToCloudFormation(properties.firewallDeploymentModel),
    };
}
// @ts-ignore TS6133
function CfnPolicyThirdPartyFirewallPolicyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('firewallDeploymentModel', 'FirewallDeploymentModel', cfn_parse.FromCloudFormation.getString(properties.FirewallDeploymentModel));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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