# -*- coding: utf-8 -*-
# Copyright © 2021 Contrast Security, Inc.
# See https://www.contrastsecurity.com/enduser-terms-0317a for more details.
ALL_ARGS = "ALL_ARGS"
ALL_KWARGS = "ALL_KWARGS"

OBJECT = "OBJ"
OBJECT_KEY = OBJECT[0]

RETURN = "RETURN"
RETURN_KEY = RETURN[0]

ARG = "ARG"
KWARG = "KWARG"
ARG_OR_KWARG = "P"

ALL_TYPE = "A"
CREATION_TYPE = "CREATION"
TRIGGER_TYPE = "TRIGGER"
TO_MARKER = "2"

SCOPE = "contrast"

CONTRAST_KEY = "contrast"
SOURCES_KEY = "sources"
PROPAGATION_KEY = "propagators"
TRIGGERS_KEY = "triggers"
DEADZONE_KEY = "deadzones"

DB_SOURCE_TYPE = "TAINTED_DATABASE"

DUNDER = "__"

CURRENT_FINDING_VERSION = 4

# For rare case of dataflow rules without routes
MINIMUM_FINDING_VERSION = 3

# For PolicyNode
VALID_TAGS = [
    "XML_ENCODED",
    "XML_DECODED",
    "HTML_ENCODED",
    "HTML_DECODED",
    "URL_ENCODED",
    "URL_DECODED",
    "CSS_ENCODED",
    "CSS_DECODED",
    "BASE64_ENCODED",
    "BASE64_DECODED",
    "JAVASCRIPT_ENCODED",
    "JAVASCRIPT_DECODED",
    "JAVA_ENCODED",
    "JAVA_DECODED",
    "CSV_ENCODED",
    "CSV_DECODED",
    "SQL_ENCODED",
    "SQL_DECODED",
    "LDAP_ENCODED",
    "LDAP_DECODED",
    "XPATH_ENCODED",
    "XPATH_DECODED",
    "OS_ENCODED",
    "OS_DECODED",
    "VBSCRIPT_ENCODED",
    "VBSCRIPT_DECODED",
    "POTENTIAL_SANITIZED",
    "POTENTIAL_VALIDATED",
    "XMLIF_VALIDATED_XXE",
    "NO_CONTROL_CHARS",
    "JS_ENCODED",
    "XSS_ENCODED",
    "LIMITED_CHARS",
    "SAFE_PATH",
    "CUSTOM",
    "CUSTOM_ENCODED",
    "CUSTOM_ENCODED_CMD_INJECTION",
    "CUSTOM_ENCODED_EXPRESSION_LANGUAGE_INJECTION",
    "CUSTOM_ENCODED_HEADER_INJECTION",
    "CUSTOM_ENCODED_HQL_INJECTION",
    "CUSTOM_ENCODED_LDAP_INJECTION",
    "CUSTOM_ENCODED_LOG_INJECTION",
    "CUSTOM_ENCODED_NOSQL_INJECTION",
    "CUSTOM_ENCODED_PATH_TRAVERSAL",
    "CUSTOM_ENCODED_REDOS",
    "CUSTOM_ENCODED_REFLECTED_XSS",
    "CUSTOM_ENCODED_REFLECTION_INJECTION",
    "CUSTOM_ENCODED_SMTP_INJECTION",
    "CUSTOM_ENCODED_SQL_INJECTION",
    "CUSTOM_ENCODED_SSRF",
    "CUSTOM_ENCODED_STORED_XSS",
    "CUSTOM_ENCODED_TRUST_BOUNDARY_VIOLATION",
    "CUSTOM_ENCODED_UNSAFE_CODE_EXECUTION",
    "CUSTOM_ENCODED_UNSAFE_READLINE",
    "CUSTOM_ENCODED_UNSAFE_XML_DECODE",
    "CUSTOM_ENCODED_UNTRUSTED_DESERIALIZATION",
    "CUSTOM_ENCODED_UNVALIDATED_FORWARD",
    "CUSTOM_ENCODED_UNVALIDATED_REDIRECT",
    "CUSTOM_ENCODED_XPATH_INJECTION",
    "CUSTOM_ENCODED_XXE",
    "CUSTOM_SECURITY_CONTROL_APPLIED",
    "CUSTOM_VALIDATED",
    "CUSTOM_VALIDATED_CMD_INJECTION",
    "CUSTOM_VALIDATED_EXPRESSION_LANGUAGE_INJECTION",
    "CUSTOM_VALIDATED_HEADER_INJECTION",
    "CUSTOM_VALIDATED_HQL_INJECTION",
    "CUSTOM_VALIDATED_LDAP_INJECTION",
    "CUSTOM_VALIDATED_LOG_INJECTION",
    "CUSTOM_VALIDATED_NOSQL_INJECTION",
    "CUSTOM_VALIDATED_PATH_TRAVERSAL",
    "CUSTOM_VALIDATED_REDOS",
    "CUSTOM_VALIDATED_REFLECTED_XSS",
    "CUSTOM_VALIDATED_REFLECTION_INJECTION",
    "CUSTOM_VALIDATED_SMTP_INJECTION",
    "CUSTOM_VALIDATED_SQL_INJECTION",
    "CUSTOM_VALIDATED_SSRF",
    "CUSTOM_VALIDATED_STORED_XSS",
    "CUSTOM_VALIDATED_TRUST_BOUNDARY_VIOLATION",
    "CUSTOM_VALIDATED_UNSAFE_CODE_EXECUTION",
    "CUSTOM_VALIDATED_UNSAFE_READLINE",
    "CUSTOM_VALIDATED_UNSAFE_XML_DECODE",
    "CUSTOM_VALIDATED_UNTRUSTED_DESERIALIZATION",
    "CUSTOM_VALIDATED_UNVALIDATED_FORWARD",
    "CUSTOM_VALIDATED_UNVALIDATED_REDIRECT",
    "CUSTOM_VALIDATED_XPATH_INJECTION",
    "CUSTOM_VALIDATED_XXE",
    "DATABASE_WRITE",
]

VALID_SOURCE_TAGS = ["NO_NEWLINES", "UNTRUSTED", "CROSS_SITE", "LIMITED_CHARS"]

JSON_NAME = "name"
JSON_MODULE = "module"
JSON_CLASS_NAME = "class_name"
JSON_INSTANCE_METHOD = "instance_method"
JSON_METHOD_NAME = "method_name"
JSON_SOURCE = "source"
JSON_TARGET = "target"
JSON_TAGS = "tags"
JSON_POLICY_PATCH = "policy_patch"
JSON_GOOD_VALUE = "good_value"
JSON_BAD_VALUE = "bad_value"
JSON_TYPE = "type"
JSON_SOURCE_NAME = "source_name"
JSON_ACTION = "action"
JSON_UNTAGS = "untags"
JSON_PACKAGE = "package"
JSON_VERSION = "version"
JSON_PY2_ONLY = "python2_only"
JSON_PY3_ONLY = "python3_only"
JSON_BUILTIN = "builtin"
JSON_PROTECT_MODE = "protect_mode"
JSON_UNSAFE_DEFAULT = "unsafe_default"
JSON_CONFIG_OPTION = "config_option"

# End of PolicyNode

TRIGGER_ACTION_DEFAULT = "DEFAULT"
TRIGGER_ACTION_REDOS = "REDOS"
TRIGGER_ACTION_SSRF = "SSRF"
