import logging

from globus_sdk.utils import safe_b64encode

from .base import StaticGlobusAuthorizer

log = logging.getLogger(__name__)


class BasicAuthorizer(StaticGlobusAuthorizer):
    """
    This Authorizer implements Basic Authentication.
    Given a "username" and "password", they are sent base64 encoded in the
    header.

    :param username: Username component for Basic Auth
    :type username: str
    :param password: Password component for Basic Auth
    :type password: str
    """

    def __init__(self, username: str, password: str):
        log.info(
            "Setting up a BasicAuthorizer. It will use an "
            "auth type of Basic and cannot handle 401s."
        )
        log.info(f"BasicAuthorizer.username = {username}")
        self.username = username
        self.password = password

        to_b64 = f"{username}:{password}"
        self.header_val = f"Basic {safe_b64encode(to_b64)}"
