"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoadBalancerListenerProtocol = exports.LoadBalancerType = exports.ContextProvider = void 0;
/**
 * Identifier for the context provider
 */
var ContextProvider;
(function (ContextProvider) {
    /**
     * AMI provider
     */
    ContextProvider["AMI_PROVIDER"] = "ami";
    /**
     * AZ provider
     */
    ContextProvider["AVAILABILITY_ZONE_PROVIDER"] = "availability-zones";
    /**
     * Route53 Hosted Zone provider
     */
    ContextProvider["HOSTED_ZONE_PROVIDER"] = "hosted-zone";
    /**
     * SSM Parameter Provider
     */
    ContextProvider["SSM_PARAMETER_PROVIDER"] = "ssm";
    /**
     * VPC Provider
     */
    ContextProvider["VPC_PROVIDER"] = "vpc-provider";
    /**
     * VPC Endpoint Service AZ Provider
     */
    ContextProvider["ENDPOINT_SERVICE_AVAILABILITY_ZONE_PROVIDER"] = "endpoint-service-availability-zones";
    /**
     * Load balancer provider
     */
    ContextProvider["LOAD_BALANCER_PROVIDER"] = "load-balancer";
    /**
     * Load balancer listener provider
     */
    ContextProvider["LOAD_BALANCER_LISTENER_PROVIDER"] = "load-balancer-listener";
    /**
     * Security group provider
     */
    ContextProvider["SECURITY_GROUP_PROVIDER"] = "security-group";
    /**
     * KMS Key Provider
     */
    ContextProvider["KEY_PROVIDER"] = "key-provider";
    /**
     * CCAPI Provider
     */
    ContextProvider["CC_API_PROVIDER"] = "cc-api-provider";
    /**
     * A plugin provider (the actual plugin name will be in the properties)
     */
    ContextProvider["PLUGIN"] = "plugin";
})(ContextProvider || (exports.ContextProvider = ContextProvider = {}));
/**
 * Type of load balancer
 */
var LoadBalancerType;
(function (LoadBalancerType) {
    /**
     * Network load balancer
     */
    LoadBalancerType["NETWORK"] = "network";
    /**
     * Application load balancer
     */
    LoadBalancerType["APPLICATION"] = "application";
})(LoadBalancerType || (exports.LoadBalancerType = LoadBalancerType = {}));
/**
 * The protocol for connections from clients to the load balancer
 */
var LoadBalancerListenerProtocol;
(function (LoadBalancerListenerProtocol) {
    /**
     * HTTP protocol
     */
    LoadBalancerListenerProtocol["HTTP"] = "HTTP";
    /**
     * HTTPS protocol
     */
    LoadBalancerListenerProtocol["HTTPS"] = "HTTPS";
    /**
     * TCP protocol
     */
    LoadBalancerListenerProtocol["TCP"] = "TCP";
    /**
     * TLS protocol
     */
    LoadBalancerListenerProtocol["TLS"] = "TLS";
    /**
     * UDP protocol
     * */
    LoadBalancerListenerProtocol["UDP"] = "UDP";
    /**
     * TCP and UDP protocol
     * */
    LoadBalancerListenerProtocol["TCP_UDP"] = "TCP_UDP";
})(LoadBalancerListenerProtocol || (exports.LoadBalancerListenerProtocol = LoadBalancerListenerProtocol = {}));
//# sourceMappingURL=data:application/json;base64,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