"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ArtifactMetadataEntryType = void 0;
/**
 * Type of artifact metadata entry.
 */
var ArtifactMetadataEntryType;
(function (ArtifactMetadataEntryType) {
    /**
     * Asset in metadata.
     */
    ArtifactMetadataEntryType["ASSET"] = "aws:cdk:asset";
    /**
     * Metadata key used to print INFO-level messages by the toolkit when an app is syntheized.
     */
    ArtifactMetadataEntryType["INFO"] = "aws:cdk:info";
    /**
     * Metadata key used to print WARNING-level messages by the toolkit when an app is syntheized.
     */
    ArtifactMetadataEntryType["WARN"] = "aws:cdk:warning";
    /**
     * Metadata key used to print ERROR-level messages by the toolkit when an app is syntheized.
     */
    ArtifactMetadataEntryType["ERROR"] = "aws:cdk:error";
    /**
     * Represents the CloudFormation logical ID of a resource at a certain path.
     */
    ArtifactMetadataEntryType["LOGICAL_ID"] = "aws:cdk:logicalId";
    /**
     * Represents tags of a stack.
     */
    ArtifactMetadataEntryType["STACK_TAGS"] = "aws:cdk:stack-tags";
})(ArtifactMetadataEntryType || (exports.ArtifactMetadataEntryType = ArtifactMetadataEntryType = {}));
//# sourceMappingURL=data:application/json;base64,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