"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ArtifactType = void 0;
/**
 * Type of cloud artifact.
 */
var ArtifactType;
(function (ArtifactType) {
    /**
     * Stub required because of JSII.
     */
    ArtifactType["NONE"] = "none";
    /**
     * The artifact is an AWS CloudFormation stack.
     */
    ArtifactType["AWS_CLOUDFORMATION_STACK"] = "aws:cloudformation:stack";
    /**
     * The artifact contains the CDK application's construct tree.
     */
    ArtifactType["CDK_TREE"] = "cdk:tree";
    /**
     * Manifest for all assets in the Cloud Assembly
     */
    ArtifactType["ASSET_MANIFEST"] = "cdk:asset-manifest";
    /**
     * Nested Cloud Assembly
     */
    ArtifactType["NESTED_CLOUD_ASSEMBLY"] = "cdk:cloud-assembly";
})(ArtifactType || (exports.ArtifactType = ArtifactType = {}));
//# sourceMappingURL=data:application/json;base64,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