"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RequireApproval = void 0;
/**
 * In what scenarios should the CLI ask for approval
 */
var RequireApproval;
(function (RequireApproval) {
    /**
     * Never ask for approval
     */
    RequireApproval["NEVER"] = "never";
    /**
     * Prompt for approval for any type of change to the stack
     */
    RequireApproval["ANYCHANGE"] = "any-change";
    /**
     * Only prompt for approval if there are security related changes
     */
    RequireApproval["BROADENING"] = "broadening";
})(RequireApproval || (exports.RequireApproval = RequireApproval = {}));
//# sourceMappingURL=data:application/json;base64,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