"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.QueryDefinition = exports.QueryString = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const _1 = require(".");
/**
 * Define a QueryString
 */
class QueryString {
    constructor(props = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_logs_QueryStringProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.fields = props.fields;
        this.parse = props.parse;
        this.filter = props.filter;
        this.stats = props.stats;
        this.sort = props.sort;
        this.limit = props.limit;
        this.display = props.display;
    }
    /**
    * String representation of this QueryString.
    */
    toString() {
        return noUndef({
            fields: this.fields !== undefined ? this.fields.join(', ') : this.fields,
            parse: this.parse,
            filter: this.filter,
            stats: this.stats,
            sort: this.sort,
            limit: this.limit,
            display: this.display,
        }).join(' | ');
    }
}
exports.QueryString = QueryString;
_a = JSII_RTTI_SYMBOL_1;
QueryString[_a] = { fqn: "@aws-cdk/aws-logs.QueryString", version: "1.153.1" };
function noUndef(x) {
    const ret = [];
    for (const [key, value] of Object.entries(x)) {
        if (value !== undefined) {
            ret.push(`${key} ${value}`);
        }
    }
    return ret;
}
/**
 * Define a query definition for CloudWatch Logs Insights
 */
class QueryDefinition extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.queryDefinitionName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_logs_QueryDefinitionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const queryDefinition = new _1.CfnQueryDefinition(this, 'Resource', {
            name: props.queryDefinitionName,
            queryString: props.queryString.toString(),
            logGroupNames: typeof props.logGroups === 'undefined' ? [] : props.logGroups.flatMap(logGroup => logGroup.logGroupName),
        });
        this.queryDefinitionId = queryDefinition.attrQueryDefinitionId;
    }
}
exports.QueryDefinition = QueryDefinition;
_b = JSII_RTTI_SYMBOL_1;
QueryDefinition[_b] = { fqn: "@aws-cdk/aws-logs.QueryDefinition", version: "1.153.1" };
//# sourceMappingURL=data:application/json;base64,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