import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeTablesConfig extends cdktf.TerraformMetaArguments {
    /**
    * The database from which to return the schemas from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/tables#database DataSnowflakeTables#database}
    */
    readonly database: string;
    /**
    * The schema from which to return the tables from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/tables#schema DataSnowflakeTables#schema}
    */
    readonly schema: string;
}
export declare class DataSnowflakeTablesTables extends cdktf.ComplexComputedList {
    get comment(): string;
    get database(): string;
    get name(): string;
    get schema(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/d/tables snowflake_tables}
*/
export declare class DataSnowflakeTables extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/d/tables snowflake_tables} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeTablesConfig
    */
    constructor(scope: Construct, id: string, config: DataSnowflakeTablesConfig);
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    get id(): string;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    tables(index: string): DataSnowflakeTablesTables;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
