"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NetworkPolicyAttachment = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/network_policy_attachment snowflake_network_policy_attachment}
*/
class NetworkPolicyAttachment extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/network_policy_attachment snowflake_network_policy_attachment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkPolicyAttachmentConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'snowflake_network_policy_attachment',
            terraformGeneratorMetadata: {
                providerName: 'snowflake'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._networkPolicyName = config.networkPolicyName;
        this._setForAccount = config.setForAccount;
        this._users = config.users;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get networkPolicyName() {
        return this.getStringAttribute('network_policy_name');
    }
    set networkPolicyName(value) {
        this._networkPolicyName = value;
    }
    // Temporarily expose input value. Use with caution.
    get networkPolicyNameInput() {
        return this._networkPolicyName;
    }
    get setForAccount() {
        return this.getBooleanAttribute('set_for_account');
    }
    set setForAccount(value) {
        this._setForAccount = value;
    }
    resetSetForAccount() {
        this._setForAccount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get setForAccountInput() {
        return this._setForAccount;
    }
    get users() {
        return cdktf.Fn.tolist(this.getListAttribute('users'));
    }
    set users(value) {
        this._users = value;
    }
    resetUsers() {
        this._users = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get usersInput() {
        return this._users;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            network_policy_name: cdktf.stringToTerraform(this._networkPolicyName),
            set_for_account: cdktf.booleanToTerraform(this._setForAccount),
            users: cdktf.listMapper(cdktf.stringToTerraform)(this._users),
        };
    }
}
exports.NetworkPolicyAttachment = NetworkPolicyAttachment;
_a = JSII_RTTI_SYMBOL_1;
NetworkPolicyAttachment[_a] = { fqn: "@cdktf/provider-snowflake.NetworkPolicyAttachment", version: "0.0.40" };
// =================
// STATIC PROPERTIES
// =================
NetworkPolicyAttachment.tfResourceType = "snowflake_network_policy_attachment";
//# sourceMappingURL=data:application/json;base64,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