"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CDK8sProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const provider_kubernetes_1 = require("@cdktf/provider-kubernetes");
const cdktf_1 = require("cdktf");
const yaml = require("yaml");
/**
 * @stability stable
 */
class CDK8sProvider extends provider_kubernetes_1.KubernetesProvider {
    /**
     * @stability stable
     */
    constructor(scope, id, config) {
        super(scope, id, config);
        cdktf_1.Aspects.of(scope).add({
            visit: (node) => {
                // Only run once
                if (node !== this)
                    return;
                const yamlManifests = yaml.parseAllDocuments(config.cdk8sApp.synthYaml());
                yamlManifests.forEach((yamlManifest) => {
                    new provider_kubernetes_1.Manifest(this, "cdk8s", {
                        manifest: yamlManifest.toJSON(),
                    });
                });
            },
        });
    }
}
exports.CDK8sProvider = CDK8sProvider;
_a = JSII_RTTI_SYMBOL_1;
CDK8sProvider[_a] = { fqn: "cdktf-cdk8s.CDK8sProvider", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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