# Copyright 2022 The KServe Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    KServe

    Python SDK for KServe  # noqa: E501

    The version of the OpenAPI document: v0.1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from kserve.configuration import Configuration


class V1alpha1ServingRuntimePodSpec(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'affinity': 'V1Affinity',
        'annotations': 'dict(str, str)',
        'containers': 'list[V1Container]',
        'image_pull_secrets': 'list[V1LocalObjectReference]',
        'labels': 'dict(str, str)',
        'node_selector': 'dict(str, str)',
        'tolerations': 'list[V1Toleration]',
        'volumes': 'list[V1Volume]'
    }

    attribute_map = {
        'affinity': 'affinity',
        'annotations': 'annotations',
        'containers': 'containers',
        'image_pull_secrets': 'imagePullSecrets',
        'labels': 'labels',
        'node_selector': 'nodeSelector',
        'tolerations': 'tolerations',
        'volumes': 'volumes'
    }

    def __init__(self, affinity=None, annotations=None, containers=None, image_pull_secrets=None, labels=None, node_selector=None, tolerations=None, volumes=None, local_vars_configuration=None):  # noqa: E501
        """V1alpha1ServingRuntimePodSpec - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._affinity = None
        self._annotations = None
        self._containers = None
        self._image_pull_secrets = None
        self._labels = None
        self._node_selector = None
        self._tolerations = None
        self._volumes = None
        self.discriminator = None

        if affinity is not None:
            self.affinity = affinity
        if annotations is not None:
            self.annotations = annotations
        self.containers = containers
        if image_pull_secrets is not None:
            self.image_pull_secrets = image_pull_secrets
        if labels is not None:
            self.labels = labels
        if node_selector is not None:
            self.node_selector = node_selector
        if tolerations is not None:
            self.tolerations = tolerations
        if volumes is not None:
            self.volumes = volumes

    @property
    def affinity(self):
        """Gets the affinity of this V1alpha1ServingRuntimePodSpec.  # noqa: E501


        :return: The affinity of this V1alpha1ServingRuntimePodSpec.  # noqa: E501
        :rtype: V1Affinity
        """
        return self._affinity

    @affinity.setter
    def affinity(self, affinity):
        """Sets the affinity of this V1alpha1ServingRuntimePodSpec.


        :param affinity: The affinity of this V1alpha1ServingRuntimePodSpec.  # noqa: E501
        :type: V1Affinity
        """

        self._affinity = affinity

    @property
    def annotations(self):
        """Gets the annotations of this V1alpha1ServingRuntimePodSpec.  # noqa: E501

        Annotations that will be add to the pod. More info: http://kubernetes.io/docs/user-guide/annotations  # noqa: E501

        :return: The annotations of this V1alpha1ServingRuntimePodSpec.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._annotations

    @annotations.setter
    def annotations(self, annotations):
        """Sets the annotations of this V1alpha1ServingRuntimePodSpec.

        Annotations that will be add to the pod. More info: http://kubernetes.io/docs/user-guide/annotations  # noqa: E501

        :param annotations: The annotations of this V1alpha1ServingRuntimePodSpec.  # noqa: E501
        :type: dict(str, str)
        """

        self._annotations = annotations

    @property
    def containers(self):
        """Gets the containers of this V1alpha1ServingRuntimePodSpec.  # noqa: E501

        List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. Cannot be updated.  # noqa: E501

        :return: The containers of this V1alpha1ServingRuntimePodSpec.  # noqa: E501
        :rtype: list[V1Container]
        """
        return self._containers

    @containers.setter
    def containers(self, containers):
        """Sets the containers of this V1alpha1ServingRuntimePodSpec.

        List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. Cannot be updated.  # noqa: E501

        :param containers: The containers of this V1alpha1ServingRuntimePodSpec.  # noqa: E501
        :type: list[V1Container]
        """
        if self.local_vars_configuration.client_side_validation and containers is None:  # noqa: E501
            raise ValueError("Invalid value for `containers`, must not be `None`")  # noqa: E501

        self._containers = containers

    @property
    def image_pull_secrets(self):
        """Gets the image_pull_secrets of this V1alpha1ServingRuntimePodSpec.  # noqa: E501

        ImagePullSecrets is an optional list of references to secrets in the same namespace to use for pulling any of the images used by this PodSpec. If specified, these secrets will be passed to individual puller implementations for them to use. For example, in the case of docker, only DockerConfig type secrets are honored. More info: https://kubernetes.io/docs/concepts/containers/images#specifying-imagepullsecrets-on-a-pod  # noqa: E501

        :return: The image_pull_secrets of this V1alpha1ServingRuntimePodSpec.  # noqa: E501
        :rtype: list[V1LocalObjectReference]
        """
        return self._image_pull_secrets

    @image_pull_secrets.setter
    def image_pull_secrets(self, image_pull_secrets):
        """Sets the image_pull_secrets of this V1alpha1ServingRuntimePodSpec.

        ImagePullSecrets is an optional list of references to secrets in the same namespace to use for pulling any of the images used by this PodSpec. If specified, these secrets will be passed to individual puller implementations for them to use. For example, in the case of docker, only DockerConfig type secrets are honored. More info: https://kubernetes.io/docs/concepts/containers/images#specifying-imagepullsecrets-on-a-pod  # noqa: E501

        :param image_pull_secrets: The image_pull_secrets of this V1alpha1ServingRuntimePodSpec.  # noqa: E501
        :type: list[V1LocalObjectReference]
        """

        self._image_pull_secrets = image_pull_secrets

    @property
    def labels(self):
        """Gets the labels of this V1alpha1ServingRuntimePodSpec.  # noqa: E501

        Labels that will be add to the pod. More info: http://kubernetes.io/docs/user-guide/labels  # noqa: E501

        :return: The labels of this V1alpha1ServingRuntimePodSpec.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this V1alpha1ServingRuntimePodSpec.

        Labels that will be add to the pod. More info: http://kubernetes.io/docs/user-guide/labels  # noqa: E501

        :param labels: The labels of this V1alpha1ServingRuntimePodSpec.  # noqa: E501
        :type: dict(str, str)
        """

        self._labels = labels

    @property
    def node_selector(self):
        """Gets the node_selector of this V1alpha1ServingRuntimePodSpec.  # noqa: E501

        NodeSelector is a selector which must be true for the pod to fit on a node. Selector which must match a node's labels for the pod to be scheduled on that node. More info: https://kubernetes.io/docs/concepts/configuration/assign-pod-node/  # noqa: E501

        :return: The node_selector of this V1alpha1ServingRuntimePodSpec.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._node_selector

    @node_selector.setter
    def node_selector(self, node_selector):
        """Sets the node_selector of this V1alpha1ServingRuntimePodSpec.

        NodeSelector is a selector which must be true for the pod to fit on a node. Selector which must match a node's labels for the pod to be scheduled on that node. More info: https://kubernetes.io/docs/concepts/configuration/assign-pod-node/  # noqa: E501

        :param node_selector: The node_selector of this V1alpha1ServingRuntimePodSpec.  # noqa: E501
        :type: dict(str, str)
        """

        self._node_selector = node_selector

    @property
    def tolerations(self):
        """Gets the tolerations of this V1alpha1ServingRuntimePodSpec.  # noqa: E501

        If specified, the pod's tolerations.  # noqa: E501

        :return: The tolerations of this V1alpha1ServingRuntimePodSpec.  # noqa: E501
        :rtype: list[V1Toleration]
        """
        return self._tolerations

    @tolerations.setter
    def tolerations(self, tolerations):
        """Sets the tolerations of this V1alpha1ServingRuntimePodSpec.

        If specified, the pod's tolerations.  # noqa: E501

        :param tolerations: The tolerations of this V1alpha1ServingRuntimePodSpec.  # noqa: E501
        :type: list[V1Toleration]
        """

        self._tolerations = tolerations

    @property
    def volumes(self):
        """Gets the volumes of this V1alpha1ServingRuntimePodSpec.  # noqa: E501

        List of volumes that can be mounted by containers belonging to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes  # noqa: E501

        :return: The volumes of this V1alpha1ServingRuntimePodSpec.  # noqa: E501
        :rtype: list[V1Volume]
        """
        return self._volumes

    @volumes.setter
    def volumes(self, volumes):
        """Sets the volumes of this V1alpha1ServingRuntimePodSpec.

        List of volumes that can be mounted by containers belonging to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes  # noqa: E501

        :param volumes: The volumes of this V1alpha1ServingRuntimePodSpec.  # noqa: E501
        :type: list[V1Volume]
        """

        self._volumes = volumes

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1alpha1ServingRuntimePodSpec):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1alpha1ServingRuntimePodSpec):
            return True

        return self.to_dict() != other.to_dict()
