# Copyright 2022 The KServe Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    KServe

    Python SDK for KServe  # noqa: E501

    The version of the OpenAPI document: v0.1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from kserve.configuration import Configuration


class V1beta1ModelStatus(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'copies': 'V1beta1ModelCopies',
        'last_failure_info': 'V1beta1FailureInfo',
        'states': 'V1beta1ModelRevisionStates',
        'transition_status': 'str'
    }

    attribute_map = {
        'copies': 'copies',
        'last_failure_info': 'lastFailureInfo',
        'states': 'states',
        'transition_status': 'transitionStatus'
    }

    def __init__(self, copies=None, last_failure_info=None, states=None, transition_status='', local_vars_configuration=None):  # noqa: E501
        """V1beta1ModelStatus - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._copies = None
        self._last_failure_info = None
        self._states = None
        self._transition_status = None
        self.discriminator = None

        if copies is not None:
            self.copies = copies
        if last_failure_info is not None:
            self.last_failure_info = last_failure_info
        if states is not None:
            self.states = states
        self.transition_status = transition_status

    @property
    def copies(self):
        """Gets the copies of this V1beta1ModelStatus.  # noqa: E501


        :return: The copies of this V1beta1ModelStatus.  # noqa: E501
        :rtype: V1beta1ModelCopies
        """
        return self._copies

    @copies.setter
    def copies(self, copies):
        """Sets the copies of this V1beta1ModelStatus.


        :param copies: The copies of this V1beta1ModelStatus.  # noqa: E501
        :type: V1beta1ModelCopies
        """

        self._copies = copies

    @property
    def last_failure_info(self):
        """Gets the last_failure_info of this V1beta1ModelStatus.  # noqa: E501


        :return: The last_failure_info of this V1beta1ModelStatus.  # noqa: E501
        :rtype: V1beta1FailureInfo
        """
        return self._last_failure_info

    @last_failure_info.setter
    def last_failure_info(self, last_failure_info):
        """Sets the last_failure_info of this V1beta1ModelStatus.


        :param last_failure_info: The last_failure_info of this V1beta1ModelStatus.  # noqa: E501
        :type: V1beta1FailureInfo
        """

        self._last_failure_info = last_failure_info

    @property
    def states(self):
        """Gets the states of this V1beta1ModelStatus.  # noqa: E501


        :return: The states of this V1beta1ModelStatus.  # noqa: E501
        :rtype: V1beta1ModelRevisionStates
        """
        return self._states

    @states.setter
    def states(self, states):
        """Sets the states of this V1beta1ModelStatus.


        :param states: The states of this V1beta1ModelStatus.  # noqa: E501
        :type: V1beta1ModelRevisionStates
        """

        self._states = states

    @property
    def transition_status(self):
        """Gets the transition_status of this V1beta1ModelStatus.  # noqa: E501

        Whether the available predictor endpoints reflect the current Spec or is in transition  # noqa: E501

        :return: The transition_status of this V1beta1ModelStatus.  # noqa: E501
        :rtype: str
        """
        return self._transition_status

    @transition_status.setter
    def transition_status(self, transition_status):
        """Sets the transition_status of this V1beta1ModelStatus.

        Whether the available predictor endpoints reflect the current Spec or is in transition  # noqa: E501

        :param transition_status: The transition_status of this V1beta1ModelStatus.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and transition_status is None:  # noqa: E501
            raise ValueError("Invalid value for `transition_status`, must not be `None`")  # noqa: E501

        self._transition_status = transition_status

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1beta1ModelStatus):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1beta1ModelStatus):
            return True

        return self.to_dict() != other.to_dict()
