from __future__ import annotations

from vfbLib.parsers import (
    BaseParser,
    # EncodedValueParser,
    EncodedValueListParser,
    EncodedValueListWithCountParser,
    EncodedKeyValuesParser,
    EncodedKeyValuesParser1742,
    GaspParser,
    GlyphEncodingParser,
    OpenTypeClassFlagsParser,
    StringParser,
)
from vfbLib.parsers.bitmap import BackgroundBitmapParser, GlyphBitmapParser
from vfbLib.parsers.cmap import CustomCmapParser
from vfbLib.parsers.glyph import (
    GlyphAnchorsParser,
    GlyphAnchorsSuppParser,
    GlyphGDEFParser,
    GlyphOriginParser,
    GlyphParser,
    GlyphUnicodeParser,
    GlyphUnicodeSuppParser,
    LinkParser,
    MaskParser,
)
from vfbLib.parsers.guides import (
    GlobalGuidesParser,
    GuidePropertiesParser,
)
from vfbLib.parsers.mm import AxisMappingsParser, PrimaryInstancesParser
from vfbLib.parsers.numeric import (
    DoubleParser,
    IntParser,
    IntListParser,
    PanoseParser,
    SignedIntParser,
)
from vfbLib.parsers.options import ExportOptionsParser
from vfbLib.parsers.ps import PostScriptInfoParser
from vfbLib.parsers.text import NameRecordsParser
from vfbLib.parsers.truetype import (
    TrueTypeInfoParser,
    TrueTypeStemPpemsParser,
    TrueTypeStemsParser,
    TrueTypeZoneDeltasParser,
    TrueTypeZonesParser,
)


parser_classes = {
    1024: ("sgn", StringParser),
    1025: ("ffn", StringParser),
    1026: ("psn", StringParser),
    1027: ("tfn", StringParser),
    1028: ("weight_name", StringParser),
    1029: ("Italic Angle", DoubleParser),
    1030: ("underlinePosition", SignedIntParser),
    1031: ("underlineThickness", IntParser),
    1034: ("Monospaced", IntParser),
    1037: ("copyright", StringParser),
    1038: ("description", StringParser),
    1039: ("manufacturer", StringParser),
    1044: ("Type 1 Unique ID", SignedIntParser),
    1046: ("version full", StringParser),
    1047: ("Slant Angle", DoubleParser),
    1048: ("weight", SignedIntParser),  # Weight Class
    1054: ("MS Character Set", IntParser),
    1056: ("Menu Name", StringParser),
    1057: ("PCL ID", IntParser),
    1058: ("VP ID", IntParser),
    1059: ("1059", BaseParser),
    1060: ("MS ID", IntParser),
    1061: ("trademark", StringParser),
    1062: ("designer", StringParser),
    1063: ("designerURL", StringParser),
    1064: ("manufacturerURL", StringParser),
    1065: ("width_name", StringParser),
    1066: ("Default Glyph", StringParser),
    1068: ("1068", EncodedValueListWithCountParser),
    1069: ("License", StringParser),
    1070: ("License URL", StringParser),
    1090: ("FOND Family ID", IntParser),
    1092: ("FOND Name", StringParser),
    1093: ("1093", BaseParser),
    1118: ("panose", PanoseParser),
    1121: ("vendorID", StringParser),
    1127: ("Style Name", StringParser),
    1128: ("version", StringParser),
    1129: ("UniqueID", StringParser),
    1130: ("versionMajor", IntParser),
    1131: ("versionMinor", IntParser),
    1132: ("year", IntParser),
    1133: ("Type 1 XUIDs", IntListParser),
    1134: ("Type 1 XUIDs Count", IntParser),
    1135: ("upm", IntParser),
    1136: ("PCLT Table", EncodedValueListParser),
    1137: ("tsn", StringParser),
    1138: ("Name Records", NameRecordsParser),
    1139: ("OT Mac Name", StringParser),
    1140: ("1140", BaseParser),
    1141: ("Custom CMAPs", CustomCmapParser),
    1250: ("Glyph Unicode", GlyphUnicodeParser),
    1253: ("Glyph Unicode Non-BMP", GlyphUnicodeSuppParser),
    1254: ("Primary Instances", PrimaryInstancesParser),
    1255: ("TrueType Zones", TrueTypeZonesParser),
    1264: ("TrueType Info", TrueTypeInfoParser),
    1265: ("Gasp Ranges", GaspParser),
    1267: ("Selection", IntParser),
    1268: ("TrueType Stem PPEMs", TrueTypeStemPpemsParser),
    1269: ("TrueType Stems", TrueTypeStemsParser),
    1270: ("hhea_line_gap", IntParser),
    1271: ("1271", EncodedValueListParser),
    1272: ("Pixel Snap", IntParser),
    1273: ("TrueType Zone Deltas", TrueTypeZoneDeltasParser),
    1274: ("Zone Stop PPEM", IntParser),
    1275: ("Code Stop PPEM", IntParser),
    1276: ("openTypeFeatures", StringParser),
    1277: ("OpenType Class", StringParser),
    1278: ("hhea_ascender", SignedIntParser),
    1279: ("hhea_descender", SignedIntParser),
    1294: ("Global Guides", GlobalGuidesParser),
    1296: ("Global Guide Properties", GuidePropertiesParser),
    1500: ("Encoding", GlyphEncodingParser),
    1501: ("Encoding Mac", GlyphEncodingParser),
    1502: ("1502", IntParser),
    1503: ("Master Count", IntParser),
    1504: ("Master Name", StringParser),
    1505: ("1505", BaseParser),
    1513: ("Axis Count", IntParser),
    1514: ("Axis Name", StringParser),
    1516: ("Axis Mapping", AxisMappingsParser),
    1517: ("1517", DoubleParser),
    1524: ("1524", EncodedValueListParser),
    1530: ("Blue Values Count", IntParser),
    1531: ("Other Blues Count", IntParser),
    1532: ("Family Blues Count", IntParser),
    1533: ("Family Other Blues Count", IntParser),
    1534: ("StemSnapH Count", IntParser),
    1535: ("StemSnapV Count", IntParser),
    1536: ("PostScript Info", PostScriptInfoParser),
    1604: ("1604", IntParser),
    1742: ("1742", EncodedKeyValuesParser1742),
    1743: ("OpenType Export Options", EncodedKeyValuesParser),
    1744: ("Export Options", ExportOptionsParser),
    2001: ("Glyph", GlyphParser),
    2007: ("Background Bitmap", BackgroundBitmapParser),
    2008: ("Links", LinkParser),
    2009: ("Mask", MaskParser),
    2010: ("2010", BaseParser),
    2011: ("2011", BaseParser),
    2012: ("Mark Color", IntParser),
    2013: ("Glyph Bitmaps", GlyphBitmapParser),
    2015: ("Glyph User Data", StringParser),
    2016: ("Font User Data", StringParser),
    2017: ("Glyph Note", StringParser),
    2018: ("Glyph GDEF Data", GlyphGDEFParser),
    2020: ("Glyph Anchors Supplemental", GlyphAnchorsSuppParser),
    2021: ("Unicode Ranges", IntParser),
    2022: ("Export PCLT Table", IntParser),
    2023: ("2023", EncodedValueListParser),  # Glyph
    2024: ("OpenType Metrics Class Flags", OpenTypeClassFlagsParser),
    2025: ("fontNote", StringParser),
    2026: ("OpenType Kerning Class Flags", OpenTypeClassFlagsParser),
    2027: ("Glyph Origin", GlyphOriginParser),
    2029: ("Glyph Anchors MM", GlyphAnchorsParser),  # MM-compatible
    2031: ("Glyph Guide Properties", GuidePropertiesParser),
    2032: ("2032", IntParser),
}

ignore_minimal = [
    "Background Bitmap",
    "fontNote",
    "Global Guides",
    "Glyph Bitmaps",
    "Glyph Guide Properties",
    "Mark Color",
    "Mask",
]
